/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.metamodel;

import com.gs.fw.common.mithra.generator.metamodel.MithraEmbeddedValueObjectResourceType;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorMarshaller;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorUnmarshaller;
import com.gs.fw.common.mithra.generator.metamodel.MithraInterfaceResourceType;
import com.gs.fw.common.mithra.generator.metamodel.MithraObjectResourceType;
import com.gs.fw.common.mithra.generator.metamodel.MithraPureObjectResourceType;
import com.gs.fw.common.mithra.generator.metamodel.MithraTempObjectResourceType;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class MithraTypeAbstract
implements Serializable {
    private boolean generateInterfaces = false;
    private boolean _isGenerateInterfacesSet;
    private boolean readOnlyInterfaces = false;
    private boolean _isReadOnlyInterfacesSet;
    private boolean enableOffHeap = false;
    private boolean _isEnableOffHeapSet;
    private static Map<String, Integer> elementNameStates = new HashMap<String, Integer>();
    private List<MithraObjectResourceType> mithraObjectResources = MithraGeneratorUnmarshaller.emptyList();
    private List<MithraPureObjectResourceType> mithraPureObjectResources = MithraGeneratorUnmarshaller.emptyList();
    private List<MithraTempObjectResourceType> mithraTempObjectResources = MithraGeneratorUnmarshaller.emptyList();
    private List<MithraInterfaceResourceType> mithraInterfaceResources = MithraGeneratorUnmarshaller.emptyList();
    private List<MithraEmbeddedValueObjectResourceType> mithraEmbeddedValueObjectResources = MithraGeneratorUnmarshaller.emptyList();
    private Object _parent;

    public Object parent() {
        return this._parent;
    }

    public void _setParent(Object parent) {
        this._parent = parent;
    }

    public void parse(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        this.parseAttributes(unmarshaller);
        this.parseElements(unmarshaller, typeName);
    }

    protected void initListElements(MithraGeneratorUnmarshaller unmarshaller) {
        this.mithraObjectResources = unmarshaller.newList();
        this.mithraPureObjectResources = unmarshaller.newList();
        this.mithraTempObjectResources = unmarshaller.newList();
        this.mithraInterfaceResources = unmarshaller.newList();
        this.mithraEmbeddedValueObjectResources = unmarshaller.newList();
    }

    protected void parseElements(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        this.initListElements(unmarshaller);
        int eventType = unmarshaller.getNextStartOrEnd();
        if (!unmarshaller.isAtEnd(eventType, typeName)) {
            XMLStreamReader xmlStreamReader = unmarshaller.getXmlStreamReader();
            int currentElementState = Integer.MAX_VALUE;
            int state = 0;
            while (eventType == 1) {
                String elementName = xmlStreamReader.getLocalName();
                currentElementState = this.getState(elementName);
                if (state <= currentElementState) {
                    if (state < 0) {
                        unmarshaller.throwException("unexpected element in MithraType: " + elementName);
                    }
                } else {
                    unmarshaller.throwException("element out of order " + elementName + " in type MithraType");
                }
                this.parseElement(unmarshaller, state, elementName);
                state = currentElementState;
                eventType = unmarshaller.getNextStartOrEnd();
            }
            unmarshaller.expectEnd(eventType, typeName);
            this.checkListMinOccurs(unmarshaller);
        }
    }

    protected void checkListMinOccurs(MithraGeneratorUnmarshaller unmarshaller) {
    }

    protected int getState(String elementName) throws XMLStreamException {
        Integer state = elementNameStates.get(elementName);
        if (state != null) {
            return state;
        }
        return -1;
    }

    protected void parseElement(MithraGeneratorUnmarshaller unmarshaller, int state, String elementName) throws XMLStreamException {
        if (elementName.equals("MithraObjectResource")) {
            MithraObjectResourceType _mithraObjectResource = new MithraObjectResourceType();
            _mithraObjectResource.parse(unmarshaller, "MithraObjectResource");
            _mithraObjectResource._setParent(this);
            this.getMithraObjectResources().add(_mithraObjectResource);
        }
        if (elementName.equals("MithraPureObjectResource")) {
            MithraPureObjectResourceType _mithraPureObjectResource = new MithraPureObjectResourceType();
            _mithraPureObjectResource.parse(unmarshaller, "MithraPureObjectResource");
            _mithraPureObjectResource._setParent(this);
            this.getMithraPureObjectResources().add(_mithraPureObjectResource);
        }
        if (elementName.equals("MithraTempObjectResource")) {
            MithraTempObjectResourceType _mithraTempObjectResource = new MithraTempObjectResourceType();
            _mithraTempObjectResource.parse(unmarshaller, "MithraTempObjectResource");
            _mithraTempObjectResource._setParent(this);
            this.getMithraTempObjectResources().add(_mithraTempObjectResource);
        }
        if (elementName.equals("MithraInterfaceResource")) {
            MithraInterfaceResourceType _mithraInterfaceResource = new MithraInterfaceResourceType();
            _mithraInterfaceResource.parse(unmarshaller, "MithraInterfaceResource");
            _mithraInterfaceResource._setParent(this);
            this.getMithraInterfaceResources().add(_mithraInterfaceResource);
        }
        if (elementName.equals("MithraEmbeddedValueObjectResource")) {
            MithraEmbeddedValueObjectResourceType _mithraEmbeddedValueObjectResource = new MithraEmbeddedValueObjectResourceType();
            _mithraEmbeddedValueObjectResource.parse(unmarshaller, "MithraEmbeddedValueObjectResource");
            _mithraEmbeddedValueObjectResource._setParent(this);
            this.getMithraEmbeddedValueObjectResources().add(_mithraEmbeddedValueObjectResource);
        }
    }

    protected void parseAttributes(MithraGeneratorUnmarshaller unmarshaller) throws XMLStreamException {
        XMLStreamReader xmlStreamReader = unmarshaller.getXmlStreamReader();
        int attributes = xmlStreamReader.getAttributeCount();
        for (int i = 0; i < attributes; ++i) {
            String attributeValue;
            String attributeName = xmlStreamReader.getAttributeName(i).getLocalPart();
            if (this.parseAttribute(unmarshaller, attributeName, attributeValue = xmlStreamReader.getAttributeValue(i))) continue;
            unmarshaller.unknownAttribute(attributeName, attributeValue);
        }
    }

    protected boolean parseAttribute(MithraGeneratorUnmarshaller unmarshaller, String attributeName, String attributeValue) throws XMLStreamException {
        if (attributeName.equals("generateInterfaces")) {
            this.setGenerateInterfaces(unmarshaller.parseBoolean("generateInterfaces", attributeValue));
            return true;
        }
        if (attributeName.equals("readOnlyInterfaces")) {
            this.setReadOnlyInterfaces(unmarshaller.parseBoolean("readOnlyInterfaces", attributeValue));
            return true;
        }
        if (attributeName.equals("enableOffHeap")) {
            this.setEnableOffHeap(unmarshaller.parseBoolean("enableOffHeap", attributeValue));
            return true;
        }
        return false;
    }

    public boolean isGenerateInterfaces() {
        return this.generateInterfaces;
    }

    public void setGenerateInterfaces(boolean generateInterfaces) {
        this.generateInterfaces = generateInterfaces;
        this._isGenerateInterfacesSet = true;
    }

    public boolean isGenerateInterfacesSet() {
        return this._isGenerateInterfacesSet;
    }

    public void unsetGenerateInterfaces() {
        this._isGenerateInterfacesSet = false;
        this.generateInterfaces = false;
    }

    public boolean isReadOnlyInterfaces() {
        return this.readOnlyInterfaces;
    }

    public void setReadOnlyInterfaces(boolean readOnlyInterfaces) {
        this.readOnlyInterfaces = readOnlyInterfaces;
        this._isReadOnlyInterfacesSet = true;
    }

    public boolean isReadOnlyInterfacesSet() {
        return this._isReadOnlyInterfacesSet;
    }

    public void unsetReadOnlyInterfaces() {
        this._isReadOnlyInterfacesSet = false;
        this.readOnlyInterfaces = false;
    }

    public boolean isEnableOffHeap() {
        return this.enableOffHeap;
    }

    public void setEnableOffHeap(boolean enableOffHeap) {
        this.enableOffHeap = enableOffHeap;
        this._isEnableOffHeapSet = true;
    }

    public boolean isEnableOffHeapSet() {
        return this._isEnableOffHeapSet;
    }

    public void unsetEnableOffHeap() {
        this._isEnableOffHeapSet = false;
        this.enableOffHeap = false;
    }

    public List<MithraObjectResourceType> getMithraObjectResources() {
        return this.mithraObjectResources;
    }

    public void setMithraObjectResources(List<MithraObjectResourceType> mithraObjectResources) {
        this.mithraObjectResources = mithraObjectResources;
    }

    public boolean isMithraObjectResourcesSet() {
        return this.mithraObjectResources != null && this.mithraObjectResources.size() > 0;
    }

    public List<MithraPureObjectResourceType> getMithraPureObjectResources() {
        return this.mithraPureObjectResources;
    }

    public void setMithraPureObjectResources(List<MithraPureObjectResourceType> mithraPureObjectResources) {
        this.mithraPureObjectResources = mithraPureObjectResources;
    }

    public boolean isMithraPureObjectResourcesSet() {
        return this.mithraPureObjectResources != null && this.mithraPureObjectResources.size() > 0;
    }

    public List<MithraTempObjectResourceType> getMithraTempObjectResources() {
        return this.mithraTempObjectResources;
    }

    public void setMithraTempObjectResources(List<MithraTempObjectResourceType> mithraTempObjectResources) {
        this.mithraTempObjectResources = mithraTempObjectResources;
    }

    public boolean isMithraTempObjectResourcesSet() {
        return this.mithraTempObjectResources != null && this.mithraTempObjectResources.size() > 0;
    }

    public List<MithraInterfaceResourceType> getMithraInterfaceResources() {
        return this.mithraInterfaceResources;
    }

    public void setMithraInterfaceResources(List<MithraInterfaceResourceType> mithraInterfaceResources) {
        this.mithraInterfaceResources = mithraInterfaceResources;
    }

    public boolean isMithraInterfaceResourcesSet() {
        return this.mithraInterfaceResources != null && this.mithraInterfaceResources.size() > 0;
    }

    public List<MithraEmbeddedValueObjectResourceType> getMithraEmbeddedValueObjectResources() {
        return this.mithraEmbeddedValueObjectResources;
    }

    public void setMithraEmbeddedValueObjectResources(List<MithraEmbeddedValueObjectResourceType> mithraEmbeddedValueObjectResources) {
        this.mithraEmbeddedValueObjectResources = mithraEmbeddedValueObjectResources;
    }

    public boolean isMithraEmbeddedValueObjectResourcesSet() {
        return this.mithraEmbeddedValueObjectResources != null && this.mithraEmbeddedValueObjectResources.size() > 0;
    }

    protected void marshallAttributes(MithraGeneratorMarshaller marshaller) throws IOException {
        if (this.isGenerateInterfacesSet()) {
            marshaller.writeAttribute("generateInterfaces", this.generateInterfaces);
        }
        if (this.isReadOnlyInterfacesSet()) {
            marshaller.writeAttribute("readOnlyInterfaces", this.readOnlyInterfaces);
        }
        if (this.isEnableOffHeapSet()) {
            marshaller.writeAttribute("enableOffHeap", this.enableOffHeap);
        }
    }

    protected void marshallContent(MithraGeneratorMarshaller marshaller) throws IOException {
    }

    protected void marshallElements(MithraGeneratorMarshaller marshaller) throws IOException {
        if (this.isMithraObjectResourcesSet()) {
            for (MithraObjectResourceType mithraObjectResource : this.mithraObjectResources) {
                mithraObjectResource.toXml(marshaller, "MithraObjectResource");
            }
        }
        if (this.isMithraPureObjectResourcesSet()) {
            for (MithraPureObjectResourceType mithraPureObjectResource : this.mithraPureObjectResources) {
                mithraPureObjectResource.toXml(marshaller, "MithraPureObjectResource");
            }
        }
        if (this.isMithraTempObjectResourcesSet()) {
            for (MithraTempObjectResourceType mithraTempObjectResource : this.mithraTempObjectResources) {
                mithraTempObjectResource.toXml(marshaller, "MithraTempObjectResource");
            }
        }
        if (this.isMithraInterfaceResourcesSet()) {
            for (MithraInterfaceResourceType mithraInterfaceResource : this.mithraInterfaceResources) {
                mithraInterfaceResource.toXml(marshaller, "MithraInterfaceResource");
            }
        }
        if (this.isMithraEmbeddedValueObjectResourcesSet()) {
            for (MithraEmbeddedValueObjectResourceType mithraEmbeddedValueObjectResource : this.mithraEmbeddedValueObjectResources) {
                mithraEmbeddedValueObjectResource.toXml(marshaller, "MithraEmbeddedValueObjectResource");
            }
        }
    }

    public void toXml(MithraGeneratorMarshaller marshaller, String tagName) throws IOException {
        marshaller.writeStartTag(tagName);
        this.marshallAttributes(marshaller);
        this.marshallContent(marshaller);
        this.marshallElements(marshaller);
        marshaller.writeEndTag(tagName);
    }

    static {
        elementNameStates.put("MithraObjectResource", 1);
        elementNameStates.put("MithraPureObjectResource", 2);
        elementNameStates.put("MithraTempObjectResource", 3);
        elementNameStates.put("MithraInterfaceResource", 4);
        elementNameStates.put("MithraEmbeddedValueObjectResource", 5);
    }
}

