/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.queryparser;

import com.gs.fw.common.mithra.generator.queryparser.MithraQL;
import com.gs.fw.common.mithra.generator.queryparser.MithraQLVisitor;
import com.gs.fw.common.mithra.generator.queryparser.Operator;
import com.gs.fw.common.mithra.generator.queryparser.SimpleNode;

public class ASTRelationalOperator
extends SimpleNode
implements Operator {
    private boolean equal;
    private boolean notEqual;
    private boolean greaterThan;
    private boolean lesserThan;
    private boolean greaterThanOrEqualTo;
    private boolean lesserThanOrEqualTo;
    private String string;

    @Override
    public boolean isIsNullOrIsNotNull() {
        return false;
    }

    @Override
    public boolean isIsNotNull() {
        return false;
    }

    @Override
    public boolean isGreaterThan() {
        return this.greaterThan;
    }

    public void setGreaterThan(boolean greaterThan) {
        this.greaterThan = greaterThan;
    }

    @Override
    public boolean isLesserThan() {
        return this.lesserThan;
    }

    public void setLesserThan(boolean lesserThan) {
        this.lesserThan = lesserThan;
    }

    @Override
    public boolean isGreaterThanOrEqualTo() {
        return this.greaterThanOrEqualTo;
    }

    public void setGreaterThanOrEqualTo(boolean greaterThanOrEqualTo) {
        this.greaterThanOrEqualTo = greaterThanOrEqualTo;
    }

    @Override
    public boolean isLesserThanOrEqualTo() {
        return this.lesserThanOrEqualTo;
    }

    public void setLesserThanOrEqualTo(boolean lesserThanOrEqualTo) {
        this.lesserThanOrEqualTo = lesserThanOrEqualTo;
    }

    public ASTRelationalOperator(int id) {
        super(id);
    }

    public ASTRelationalOperator(MithraQL p, int id) {
        super(p, id);
    }

    @Override
    public boolean isEqual() {
        return this.equal;
    }

    public void setEqual(boolean equal) {
        this.equal = equal;
    }

    @Override
    public boolean isNotEqual() {
        return this.notEqual;
    }

    public void setNotEqual(boolean notEqual) {
        this.notEqual = notEqual;
    }

    @Override
    public String toString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }

    @Override
    public Operator getReverseOperator() {
        return this;
    }

    @Override
    public boolean isIn() {
        return false;
    }

    public String getPrimitiveOperator() {
        if (this.isEqual()) {
            return " == ";
        }
        if (this.isLesserThan()) {
            return " < ";
        }
        if (this.isLesserThanOrEqualTo()) {
            return " <= ";
        }
        if (this.isGreaterThan()) {
            return " > ";
        }
        if (this.isGreaterThanOrEqualTo()) {
            return " >= ";
        }
        if (this.isNotEqual()) {
            return " != ";
        }
        throw new RuntimeException("relational operator '" + this.toString() + "' not implemented");
    }

    @Override
    public String getMethodName() {
        if (this.isEqual()) {
            return "eq";
        }
        if (this.isLesserThan()) {
            return "lessThan";
        }
        if (this.isLesserThanOrEqualTo()) {
            return "lessThanEquals";
        }
        if (this.isGreaterThan()) {
            return "greaterThan";
        }
        if (this.isGreaterThanOrEqualTo()) {
            return "greaterThanEquals";
        }
        if (this.isNotEqual()) {
            return "notEq";
        }
        throw new RuntimeException("relational operator '" + this.toString() + "' not implemented");
    }

    @Override
    public Object jjtAccept(MithraQLVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean equalsOther(SimpleNode other) {
        if (other instanceof ASTRelationalOperator) {
            return ((ASTRelationalOperator)other).getMethodName().equals(this.getMethodName());
        }
        return false;
    }

    @Override
    public boolean isUnary() {
        return false;
    }

    @Override
    public boolean isEqualsEdgePoint() {
        return false;
    }

    @Override
    public String getPrimitiveExpression(String left, String right) {
        return left + this.getPrimitiveOperator() + right;
    }

    @Override
    public String getNonPrimitiveExpression(String left, String right) {
        String result = left + " != null && ";
        if (this.isEqual()) {
            result = result + left + ".equals(" + right + ")";
        } else if (this.isLesserThan()) {
            result = result + left + ".compareTo(" + right + ") < 0";
        } else if (this.isLesserThanOrEqualTo()) {
            result = result + left + ".compareTo(" + right + ") <= 0";
        } else if (this.isGreaterThan()) {
            result = result + left + ".compareTo(" + right + ") > 0";
        } else if (this.isGreaterThanOrEqualTo()) {
            result = result + left + ".compareTo(" + right + ") >= 0";
        } else if (this.isNotEqual()) {
            result = result + "!" + left + ".equals(" + right + ")";
        } else {
            throw new RuntimeException("relational operator '" + this.toString() + "' not implemented");
        }
        return result;
    }
}

