/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.JavaType;

public class BigDecimalJavaType
extends JavaType {
    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public String getTypeName() {
        return "BIGDECIMAL";
    }

    @Override
    public String getJavaTypeString() {
        return "BigDecimal";
    }

    @Override
    public String getJavaTypeStringPrimary() {
        return "BigDecimal";
    }

    @Override
    public String getIoType() {
        return "Object";
    }

    @Override
    public String getIoCast() {
        return "(BigDecimal)";
    }

    @Override
    public String convertToObject(String name) {
        return name;
    }

    @Override
    public String convertToPrimitive(String name) {
        return name;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public int getSqlType() {
        return 3;
    }

    @Override
    public String getSqlTypeAsString() {
        return "java.sql.Types.DECIMAL";
    }

    @Override
    public String getSqlDataType() {
        return "decimal";
    }

    @Override
    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForBigDecimal();
    }

    @Override
    public String getDefaultInitialValue() {
        return "null";
    }

    @Override
    public boolean isComparableTo(ASTLiteral node) {
        return node.isFloatingPoint() || node.isInteger();
    }

    @Override
    public boolean isComparableTo(JavaType other) {
        return other instanceof BigDecimalJavaType;
    }

    @Override
    public String getJavaTypeClass() {
        return "BigDecimal.class";
    }

    @Override
    public String getObjectComparisonString(String obj1, String obj2) {
        return obj1 + ".equals(" + obj2 + ")";
    }

    @Override
    public int getOffHeapSize() {
        throw new RuntimeException("not implemented");
    }
}

