/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.BeanState;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.JavaType;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class BooleanJavaType
extends PrimitiveWrapperJavaType {
    @Override
    public String getTypeName() {
        return "BOOLEAN";
    }

    @Override
    public String getJavaTypeString() {
        return "boolean";
    }

    @Override
    public String getJavaTypeStringPrimary() {
        return "Boolean";
    }

    @Override
    public String convertToObject(String name) {
        return "Boolean.valueOf(" + name + ")";
    }

    @Override
    public String convertToPrimitive(String name) {
        return name + ".booleanValue()";
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public int getSqlType() {
        return -7;
    }

    @Override
    public String getSqlTypeAsString() {
        return "java.sql.Types.BIT";
    }

    @Override
    public String getSqlDataType() {
        return "bit";
    }

    @Override
    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        if (nullable) {
            return databaseType.getSqlDataTypeForNullableBoolean();
        }
        return databaseType.getSqlDataTypeForBoolean();
    }

    @Override
    public String getDefaultInitialValue() {
        return "false";
    }

    @Override
    public boolean isComparableTo(ASTLiteral node) {
        return node.isBoolean();
    }

    @Override
    public boolean isComparableTo(JavaType other) {
        return other instanceof BooleanJavaType;
    }

    @Override
    public String getValueIfNull(String valueIfNull) {
        Boolean result = Boolean.valueOf(valueIfNull);
        return result.toString();
    }

    @Override
    public String getJavaTypeClass() {
        return "Boolean.TYPE";
    }

    @Override
    public String getSetCollectionClass() {
        return "BooleanDirectSet";
    }

    @Override
    public String getGetterPrefix() {
        return "is";
    }

    @Override
    public String getBeanSetter(BeanState beanState) {
        return "setI" + beanState.getIntCount() + "AsBoolean";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public int getOffHeapSize() {
        return 1;
    }

    @Override
    public String getSqlTypeAsStringForNull() {
        return "dt.getNullableBooleanJavaSqlType()";
    }
}

