/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.JavaType;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class CharJavaType
extends PrimitiveWrapperJavaType {
    @Override
    public String getTypeName() {
        return "CHAR";
    }

    @Override
    public String getJavaTypeString() {
        return "char";
    }

    @Override
    public String getResultSetName() {
        return "String";
    }

    @Override
    public String getJavaTypeStringPrimary() {
        return "Char";
    }

    @Override
    public String convertToObject(String name) {
        return this.getValueIfNull(name);
    }

    @Override
    public String convertToPrimitive(String name) {
        return this.getValueIfNull(name);
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public int getSqlType() {
        return 1;
    }

    @Override
    public String getSqlTypeAsString() {
        return "java.sql.Types.CHAR";
    }

    @Override
    public String getSqlDataType() {
        return "char";
    }

    @Override
    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForChar();
    }

    @Override
    public String getDefaultInitialValue() {
        return "' '";
    }

    @Override
    public boolean isComparableTo(ASTLiteral node) {
        return node.isCharacter();
    }

    @Override
    public boolean isComparableTo(JavaType other) {
        return other instanceof CharJavaType;
    }

    @Override
    public String getValueIfNull(String valueIfNull) {
        if (valueIfNull.length() == 0) {
            return "' '";
        }
        return "'" + valueIfNull.substring(0, 1) + "'";
    }

    @Override
    public String getJavaTypeClass() {
        return "Char.TYPE";
    }

    @Override
    public String convertSqlParameter(String param) {
        return "String.valueOf(" + param + ")";
    }

    @Override
    public int getOffHeapSize() {
        return 2;
    }
}

