/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.BeanState;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class DoubleJavaType
extends PrimitiveWrapperJavaType {
    @Override
    public String getTypeName() {
        return "DOUBLE";
    }

    @Override
    public String getJavaTypeString() {
        return "double";
    }

    @Override
    public String getJavaTypeStringPrimary() {
        return "Double";
    }

    @Override
    public String convertToObject(String name) {
        return "new Double(" + name + ")";
    }

    @Override
    public String convertToPrimitive(String name) {
        return name + ".doubleValue()";
    }

    @Override
    public int getSqlType() {
        return 8;
    }

    @Override
    public String getSqlTypeAsString() {
        return "java.sql.Types.DOUBLE";
    }

    @Override
    public String getSqlDataType() {
        return "DOUBLE";
    }

    @Override
    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForDouble();
    }

    @Override
    public String getDefaultInitialValue() {
        return "0.00D";
    }

    @Override
    public boolean isComparableTo(ASTLiteral node) {
        return node.isFloatingPoint() || node.isInteger();
    }

    @Override
    public String getJavaTypeClass() {
        return "Double.TYPE";
    }

    @Override
    public String getPrimitiveComparisonString(String p1, String p2) {
        return "Math.abs(" + p1 + " - " + p2 + ") > toleranceForFloatingPointFields";
    }

    @Override
    public String getBeanGetter(int intCount, int longCount, int objectCount) {
        return "getL" + longCount + "AsDouble";
    }

    @Override
    public boolean isBeanIntType() {
        return false;
    }

    @Override
    public boolean isBeanLongType() {
        return true;
    }

    @Override
    public String getBeanSetter(BeanState beanState) {
        return "setL" + beanState.getLongCount() + "AsDouble";
    }

    @Override
    public int getOffHeapSize() {
        return 8;
    }
}

