/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.BeanState;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class FloatJavaType
extends PrimitiveWrapperJavaType {
    @Override
    public String getTypeName() {
        return "FLOAT";
    }

    @Override
    public String getJavaTypeString() {
        return "float";
    }

    @Override
    public String getJavaTypeStringPrimary() {
        return "Float";
    }

    @Override
    public String convertToObject(String name) {
        return "new Float(" + name + ")";
    }

    @Override
    public String convertToPrimitive(String name) {
        return name + ".floatValue()";
    }

    @Override
    public int getSqlType() {
        return 6;
    }

    @Override
    public String getSqlDataType() {
        return "float";
    }

    @Override
    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForFloat();
    }

    @Override
    public String getSqlTypeAsString() {
        return "java.sql.Types.FLOAT";
    }

    @Override
    public String getDefaultInitialValue() {
        return "0.00F";
    }

    @Override
    public boolean isComparableTo(ASTLiteral node) {
        return node.isFloatingPoint() || node.isInteger();
    }

    @Override
    public String getJavaTypeClass() {
        return "Float.TYPE";
    }

    @Override
    public String getPrimitiveComparisonString(String p1, String p2) {
        return "Math.abs(" + p1 + " - " + p2 + ") > toleranceForFloatingPointFields";
    }

    @Override
    public String parseLiteralAndCast(String value) {
        return "(float)" + value;
    }

    @Override
    public String getBeanSetter(BeanState beanState) {
        return "setI" + beanState.getIntCount() + "AsFloat";
    }

    @Override
    public int getOffHeapSize() {
        return 4;
    }
}

