/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.BeanState;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.computedattribute.type.Type;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.BigDecimalJavaType;
import com.gs.fw.common.mithra.generator.type.BooleanJavaType;
import com.gs.fw.common.mithra.generator.type.ByteArrayJavaType;
import com.gs.fw.common.mithra.generator.type.ByteJavaType;
import com.gs.fw.common.mithra.generator.type.CharJavaType;
import com.gs.fw.common.mithra.generator.type.DateJavaType;
import com.gs.fw.common.mithra.generator.type.DoubleJavaType;
import com.gs.fw.common.mithra.generator.type.FloatJavaType;
import com.gs.fw.common.mithra.generator.type.IntJavaType;
import com.gs.fw.common.mithra.generator.type.JavaTypeException;
import com.gs.fw.common.mithra.generator.type.LongJavaType;
import com.gs.fw.common.mithra.generator.type.ShortJavaType;
import com.gs.fw.common.mithra.generator.type.StringJavaType;
import com.gs.fw.common.mithra.generator.type.TimeJavaType;
import com.gs.fw.common.mithra.generator.type.TimestampJavaType;
import com.gs.fw.common.mithra.generator.util.StringUtility;

public abstract class JavaType {
    public abstract String getTypeName();

    public abstract String getJavaTypeString();

    public abstract String getJavaTypeStringPrimary();

    public String getResultSetName() {
        return this.getJavaTypeString();
    }

    public String getIoType() {
        return StringUtility.firstLetterToUpper(this.getJavaTypeString());
    }

    public String getIoCast() {
        return "";
    }

    public String getPrintableForm(String getter, String nullGetter, boolean isNullable) {
        if (isNullable) {
            return "(" + nullGetter + " ? \"null\" : " + this.getPrintableForm(getter) + ")";
        }
        return this.getPrintableForm(getter);
    }

    protected String getPrintableForm(String getter) {
        return "(\"\"+" + getter + ")";
    }

    public abstract String convertToObject(String var1);

    public abstract String convertToPrimitive(String var1);

    public abstract boolean isPrimitive();

    public boolean isNumber() {
        return false;
    }

    public boolean isBigDecimal() {
        return false;
    }

    public boolean isIntOrLong() {
        return false;
    }

    public abstract int getSqlType();

    public abstract String getSqlTypeAsString();

    public abstract String getSqlDataType();

    public abstract String getSqlDataType(CommonDatabaseType var1, boolean var2);

    public abstract String getDefaultInitialValue();

    public abstract boolean isComparableTo(ASTLiteral var1);

    public abstract boolean isComparableTo(JavaType var1);

    public String getExtractionMethodName() {
        return StringUtility.firstLetterToLower(this.getJavaTypeString()) + "ValueOf";
    }

    public static JavaType create(String javaTypeName) throws JavaTypeException {
        if (javaTypeName.equalsIgnoreCase("INT")) {
            return new IntJavaType();
        }
        if (javaTypeName.equalsIgnoreCase("STRING")) {
            return new StringJavaType();
        }
        if (javaTypeName.equalsIgnoreCase("DOUBLE")) {
            return new DoubleJavaType();
        }
        if (javaTypeName.equalsIgnoreCase("FLOAT")) {
            return new FloatJavaType();
        }
        if (javaTypeName.equalsIgnoreCase("BOOLEAN")) {
            return new BooleanJavaType();
        }
        if (javaTypeName.equalsIgnoreCase("DATE")) {
            return new DateJavaType();
        }
        if (javaTypeName.equalsIgnoreCase("TIME")) {
            return new TimeJavaType();
        }
        if (javaTypeName.equalsIgnoreCase("TIMESTAMP")) {
            return new TimestampJavaType();
        }
        if (javaTypeName.equalsIgnoreCase("CHAR")) {
            return new CharJavaType();
        }
        if (javaTypeName.equalsIgnoreCase("LONG")) {
            return new LongJavaType();
        }
        if (javaTypeName.equalsIgnoreCase("BYTE")) {
            return new ByteJavaType();
        }
        if (javaTypeName.equalsIgnoreCase("SHORT")) {
            return new ShortJavaType();
        }
        if (javaTypeName.equalsIgnoreCase("BYTE[]")) {
            return new ByteArrayJavaType();
        }
        if (javaTypeName.equalsIgnoreCase("BIGDECIMAL")) {
            return new BigDecimalJavaType();
        }
        throw new JavaTypeException("Invalid JavaType " + javaTypeName);
    }

    public String getFinderAttributeType() {
        return this.getJavaTypeStringPrimary() + "Attribute";
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof JavaType) {
            return this.getTypeName().equals(((JavaType)obj).getTypeName());
        }
        return false;
    }

    public int hashCode() {
        return this.getTypeName().hashCode();
    }

    public String createEquals(String value1, String value2) {
        if (this.isPrimitive()) {
            return value1 + " == " + value2;
        }
        return value1 + ".equals(" + value2 + ")";
    }

    public String getValueIfNull(String valueIfNull) {
        return valueIfNull;
    }

    public String getGetterPrefix() {
        return "get";
    }

    public abstract String getJavaTypeClass();

    public String getValueSetterMethodName() {
        return "set" + StringUtility.firstLetterToUpper(this.getJavaTypeString()) + "Value";
    }

    public String getArgumentForInOperation(String values, MithraObjectTypeWrapper fromObject) {
        throw new RuntimeException("in operation not supported for " + this.getJavaTypeString());
    }

    public String getSetCollectionClass() {
        if (this.isPrimitive()) {
            return StringUtility.firstLetterToUpper(this.getJavaTypeString()) + "OpenHashSet";
        }
        return "HashSet";
    }

    public String getConnectionManagerClassName() {
        throw new RuntimeException("operation not suppported for " + this.getJavaTypeString());
    }

    public String convertSqlParameter(String param) {
        return param;
    }

    public String getFinderAttributeSuperClassType() {
        return "SingleColumn" + this.getJavaTypeStringPrimary() + "Attribute";
    }

    public String getObjectComparisonString(String obj1, String obj2) {
        throw new RuntimeException("operation not suppported for " + this.getJavaTypeString());
    }

    public String getPrimitiveComparisonString(String p1, String p2) {
        throw new RuntimeException("operation not suppported for " + this.getJavaTypeString());
    }

    public boolean isTimestamp() {
        return false;
    }

    public boolean canBePooled() {
        return false;
    }

    public boolean mayBeIdentity() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public String parseLiteralAndCast(String value) {
        return value;
    }

    public String getBeanGetter(int intCount, int longCount, int objectCount) {
        return "getO" + objectCount + "As" + StringUtility.firstLetterToUpper(this.getJavaTypeStringPrimary());
    }

    public boolean isBeanIntType() {
        return false;
    }

    public boolean isBeanLongType() {
        return false;
    }

    public boolean isBeanObjectType() {
        return true;
    }

    public String getBeanSetter(BeanState beanState) {
        return "setO" + beanState.getObjectCount();
    }

    public abstract int getOffHeapSize();

    public boolean isBoolean() {
        return false;
    }

    public Type asComputedAttributeType() {
        throw new RuntimeException("not implemented");
    }

    public boolean isTime() {
        return false;
    }

    public String getSqlTypeAsStringForNull() {
        return this.getSqlTypeAsString();
    }
}

