/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class ShortJavaType
extends PrimitiveWrapperJavaType {
    @Override
    public String getTypeName() {
        return "SHORT";
    }

    @Override
    public String getJavaTypeString() {
        return "short";
    }

    @Override
    public String getJavaTypeStringPrimary() {
        return "Short";
    }

    @Override
    public String convertToObject(String name) {
        return "new Short(" + name + ")";
    }

    @Override
    public String convertToPrimitive(String name) {
        return name + ".shortValue()";
    }

    @Override
    public int getSqlType() {
        return 5;
    }

    @Override
    public String getSqlTypeAsString() {
        return "java.sql.Types.SMALLINT";
    }

    @Override
    public String getSqlDataType() {
        return "smallint";
    }

    @Override
    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForShortJava();
    }

    @Override
    public String getDefaultInitialValue() {
        return "0";
    }

    @Override
    public boolean isComparableTo(ASTLiteral node) {
        if (node.isInteger()) {
            int intValue = Integer.parseInt(node.getValue());
            return intValue >= Short.MIN_VALUE && intValue <= Short.MAX_VALUE;
        }
        return false;
    }

    @Override
    public String getArgumentForInOperation(String values, MithraObjectTypeWrapper fromObject) {
        return fromObject.getConstantShortSet(values);
    }

    @Override
    public String getJavaTypeClass() {
        return "Short.TYPE";
    }

    @Override
    public String parseLiteralAndCast(String value) {
        return "(short)" + value;
    }

    @Override
    public int getOffHeapSize() {
        return 2;
    }
}

