/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.computedattribute.type.StringType;
import com.gs.fw.common.mithra.generator.computedattribute.type.Type;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.JavaType;

public class StringJavaType
extends JavaType {
    @Override
    public String getTypeName() {
        return "STRING";
    }

    @Override
    public String getJavaTypeString() {
        return "String";
    }

    @Override
    public String getIoType() {
        return "Object";
    }

    @Override
    public String getIoCast() {
        return "(String)";
    }

    @Override
    public String getJavaTypeStringPrimary() {
        return "String";
    }

    @Override
    public String getPrintableForm(String getter) {
        return "\"'\"+" + getter + "+\"'\"";
    }

    @Override
    public String convertToObject(String name) {
        return name;
    }

    @Override
    public String convertToPrimitive(String name) {
        return name;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public int getSqlType() {
        return 12;
    }

    @Override
    public String getSqlTypeAsString() {
        return "java.sql.Types.VARCHAR";
    }

    @Override
    public String getSqlDataType() {
        return "varchar";
    }

    @Override
    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForString();
    }

    @Override
    public String getDefaultInitialValue() {
        return "null";
    }

    @Override
    public boolean isComparableTo(ASTLiteral node) {
        return node.isString();
    }

    @Override
    public boolean isComparableTo(JavaType other) {
        return other instanceof StringJavaType;
    }

    @Override
    public String getValueIfNull(String valueIfNull) {
        return "\"" + valueIfNull + "\"";
    }

    @Override
    public String getJavaTypeClass() {
        return "String.class";
    }

    @Override
    public String getArgumentForInOperation(String values, MithraObjectTypeWrapper fromObject) {
        return fromObject.getConstantStringSet(values);
    }

    @Override
    public String getConnectionManagerClassName() {
        return "com.gs.fw.common.mithra.connectionmanager.ObjectSourceConnectionManager";
    }

    @Override
    public String getObjectComparisonString(String obj1, String obj2) {
        return obj1 + ".equals(" + obj2 + ")";
    }

    @Override
    public boolean canBePooled() {
        return true;
    }

    @Override
    public int getOffHeapSize() {
        return 4;
    }

    @Override
    public Type asComputedAttributeType() {
        return new StringType();
    }
}

