/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.GenerationLog;
import com.gs.fw.common.mithra.generator.GenerationLogger;
import com.gs.fw.common.mithra.generator.Logger;
import com.gs.fw.common.mithra.generator.MithraEmbeddedValueObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.MithraGeneratorException;
import com.gs.fw.common.mithra.generator.MithraGeneratorImport;
import com.gs.fw.common.mithra.generator.MithraImportXMLObjectTypeParser;
import com.gs.fw.common.mithra.generator.MithraObjectTypeParser;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.MithraSuperTypeWrapper;
import com.gs.fw.common.mithra.generator.MithraXMLObjectTypeParser;
import com.gs.fw.common.mithra.generator.filesystem.FauxFileSystem;
import com.gs.fw.common.mithra.generator.filesystem.GeneratedFileManager;
import com.gs.fw.common.mithra.generator.filesystem.PlainFileSystem;
import com.gs.fw.common.mithra.generator.metamodel.MithraInterfaceType;
import com.gs.fw.common.mithra.generator.type.JavaTypeException;
import com.gs.fw.common.mithra.generator.util.AutoShutdownThreadExecutor;
import com.gs.fw.common.mithra.generator.util.AwaitingThreadExecutor;
import com.gs.fw.common.mithra.generator.util.ChopAndStickResource;
import com.gs.fw.common.mithra.generator.util.FullFileBuffer;
import com.gs.fw.common.mithra.generator.util.SerialResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public class BaseMithraGenerator {
    public static final String DATED = "dated";
    public static final String READ_ONLY = "read-only";
    public static final String DATED_READ_ONLY = "datedread-only";
    public static final String TRANSACTIONAL = "transactional";
    public static final String DATED_TRANSACTIONAL = "datedtransactional";
    public static final String EMBEDDED_VALUE = "embedded-value";
    public static final String ENUMERATION = "enumeration";
    public static final String MITHRA_INTERFACE = "mithra-interface";
    private static final int MD5_LENGTH = 32;
    private String md5 = null;
    protected Logger logger;
    private GenerationLogger generationLogger = null;
    private AwaitingThreadExecutor executor;
    private Throwable executorError;
    private static final int IO_THREADS = 1;
    private String xml;
    private String generatedDir;
    private String nonGeneratedDir;
    private boolean ignoreNonGeneratedAbstractClasses = false;
    private boolean ignoreTransactionalMethods = false;
    private boolean ignorePackageNamingConvention = false;
    private boolean defaultFinalGetters = false;
    private boolean forceOffHeap = false;
    private ThreadLocal<FullFileBuffer> fullFileBufferThreadLocal = new ThreadLocal();
    private boolean generateFileHeaders = false;
    private ChopAndStickResource chopAndStickResource = new ChopAndStickResource(new Semaphore(Runtime.getRuntime().availableProcessors()), new Semaphore(1), new SerialResource());
    private List<MithraGeneratorImport> imports = new ArrayList<MithraGeneratorImport>();
    private Map<String, MithraObjectTypeWrapper> mithraObjects = new ConcurrentHashMap<String, MithraObjectTypeWrapper>();
    private List<MithraObjectTypeWrapper> sortedMithraObjects;
    private Map<String, MithraEmbeddedValueObjectTypeWrapper> mithraEmbeddedValueObjects = new ConcurrentHashMap<String, MithraEmbeddedValueObjectTypeWrapper>();
    private List<MithraEmbeddedValueObjectTypeWrapper> sortedMithraEmbeddedValueObjects;
    private Map<String, MithraInterfaceType> mithraInterfaces = new ConcurrentHashMap<String, MithraInterfaceType>();
    protected MithraObjectTypeParser mithraObjectTypeParser;
    protected GeneratedFileManager generatedFileManager;
    protected FauxFileSystem fauxFileSystem = new PlainFileSystem();

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setGenerationLogger(GenerationLogger generationLogger) {
        this.generationLogger = generationLogger;
    }

    public GenerationLogger getGenerationLogger() {
        if (this.generationLogger == null) {
            this.generationLogger = new SimpleGenerationLogger();
        }
        return this.generationLogger;
    }

    public void setFauxFileSystem(FauxFileSystem fauxFileSystem) {
        this.fauxFileSystem = fauxFileSystem;
    }

    private FullFileBuffer getFullFileBuffer() {
        FullFileBuffer result = this.fullFileBufferThreadLocal.get();
        if (result == null) {
            result = new FullFileBuffer();
            this.fullFileBufferThreadLocal.set(result);
        }
        return result;
    }

    public void setIgnorePackageNamingConvention(boolean ignorePackageNamingConvention) {
        this.ignorePackageNamingConvention = ignorePackageNamingConvention;
    }

    public void setForceOffHeap(boolean forceOffHeap) {
        this.forceOffHeap = forceOffHeap;
    }

    public String getMd5() {
        if (this.md5 == null) {
            this.md5 = "";
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/gs/fw/common/mithra/generator/mithragen.md5");
            if (is != null) {
                byte[] md5Bytes = new byte[32];
                try {
                    this.fullyRead(is, md5Bytes);
                    this.md5 = new String(md5Bytes);
                    is.close();
                    return this.md5;
                }
                catch (IOException e) {
                    this.logger.error("got an IOException reading md5 file " + e.getClass().getName() + ": " + e.getMessage());
                }
            } else {
                this.logger.error("Could not find md5. Will regenerate everything");
            }
        }
        return this.md5;
    }

    private void fullyRead(InputStream is, byte[] bytes) throws IOException {
        for (int read = 0; read < bytes.length; read += is.read(bytes, read, bytes.length - read)) {
        }
    }

    public String getCrc() {
        return this.mithraObjectTypeParser.getChecksum();
    }

    public void setGenerateFileHeaders(boolean generateFileHeaders) {
        this.generateFileHeaders = generateFileHeaders;
    }

    public List<MithraGeneratorImport> getImports() {
        return this.imports;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
        this.mithraObjectTypeParser = new MithraXMLObjectTypeParser(xml);
    }

    public String getGeneratedDir() {
        return this.generatedDir;
    }

    public void setGeneratedDir(String generatedDir) {
        this.generatedDir = generatedDir;
    }

    public String getNonGeneratedDir() {
        return this.nonGeneratedDir;
    }

    public void setNonGeneratedDir(String nonGeneratedDir) {
        this.nonGeneratedDir = nonGeneratedDir;
    }

    public void setIgnoreNonGeneratedAbstractClasses(boolean ignoreNonGeneratedAbstractClasses) {
        this.ignoreNonGeneratedAbstractClasses = ignoreNonGeneratedAbstractClasses;
    }

    public void setIgnoreTransactionalMethods(boolean ignoreTransactionalMethods) {
        this.ignoreTransactionalMethods = ignoreTransactionalMethods;
    }

    public boolean isDefaultFinalGetters() {
        return this.defaultFinalGetters;
    }

    public void setDefaultFinalGetters(boolean defaultFinalGetters) {
        this.defaultFinalGetters = defaultFinalGetters;
    }

    public Map<String, MithraObjectTypeWrapper> getMithraObjects() {
        return this.mithraObjects;
    }

    public List<MithraObjectTypeWrapper> getSortedMithraObjects() {
        return this.sortedMithraObjects;
    }

    public Map<String, MithraEmbeddedValueObjectTypeWrapper> getMithraEmbeddedValueObjects() {
        return this.mithraEmbeddedValueObjects;
    }

    public Map<String, MithraInterfaceType> getMithraInterfaces() {
        return this.mithraInterfaces;
    }

    public boolean extractMithraInterfaceRelationshipsAndSuperInterfaces() {
        boolean allGood = true;
        for (MithraInterfaceType mithraInterfaceType : this.mithraInterfaces.values()) {
            List<String> errors = mithraInterfaceType.extractRelationshipsAndSuperInterfaces(this.mithraInterfaces, this.mithraObjects);
            allGood = this.processErrorsIfAny(errors, allGood, mithraInterfaceType.getSourceFileName());
        }
        return allGood;
    }

    private int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    private void waitForExecutorWithCheck() {
        this.getExecutor().waitUntilDone();
        if (this.executorError != null) {
            throw new MithraGeneratorException("exception while generating", this.executorError);
        }
    }

    private void checkClassName(String objectName, String className) {
        if (objectName.contains("/")) {
            objectName = objectName.substring(objectName.lastIndexOf(47) + 1);
        }
        if (!objectName.equals(className)) {
            throw new MithraGeneratorException("XML filename: '" + objectName + "' must match class name specified: '" + className + "'");
        }
    }

    private void createSortedList() {
        this.sortedMithraObjects = new ArrayList<MithraObjectTypeWrapper>(this.mithraObjects.values());
        Collections.sort(this.sortedMithraObjects, new ParentClassComparator());
    }

    private void createSortedEmbeddedValueObjectList() {
        this.sortedMithraEmbeddedValueObjects = new ArrayList<MithraEmbeddedValueObjectTypeWrapper>(this.mithraEmbeddedValueObjects.values());
    }

    public String parseAndValidate() {
        String filePath = this.parseMithraObjectTypes();
        this.parseImportedMithraObjectTypes();
        this.validateMithraObjectTypes();
        return filePath;
    }

    private String parseMithraObjectTypes() {
        this.mithraObjectTypeParser.setLogger(this.logger);
        this.mithraObjectTypeParser.setForceOffHeap(this.forceOffHeap);
        this.mithraObjectTypeParser.setDefaultFinalGetters(this.defaultFinalGetters);
        this.mithraObjectTypeParser.setFauxFileSystem(this.fauxFileSystem);
        String filePath = this.mithraObjectTypeParser.parse();
        this.mithraObjects.putAll(this.mithraObjectTypeParser.getMithraObjects());
        this.mithraEmbeddedValueObjects.putAll(this.mithraObjectTypeParser.getMithraEmbeddedValueObjects());
        this.mithraInterfaces.putAll(this.mithraObjectTypeParser.getMithraInterfaces());
        return filePath;
    }

    private void parseImportedMithraObjectTypes() {
        for (MithraGeneratorImport generatorImport : this.getImports()) {
            generatorImport.setFauxFileSystem(this.fauxFileSystem);
            MithraImportXMLObjectTypeParser importXMLParser = new MithraImportXMLObjectTypeParser(generatorImport);
            importXMLParser.setLogger(this.logger);
            importXMLParser.setForceOffHeap(this.forceOffHeap);
            importXMLParser.setDefaultFinalGetters(this.defaultFinalGetters);
            importXMLParser.setFauxFileSystem(this.fauxFileSystem);
            importXMLParser.parse();
            this.mithraObjects.putAll(importXMLParser.getMithraObjects());
            this.mithraEmbeddedValueObjects.putAll(importXMLParser.getMithraEmbeddedValueObjects());
            this.mithraInterfaces.putAll(importXMLParser.getMithraInterfaces());
        }
    }

    public void validateMithraObjectTypes() {
        this.createSortedList();
        this.createSortedEmbeddedValueObjectList();
        boolean mithraInterfaceSuccess = this.extractMithraInterfaceRelationshipsAndSuperInterfaces();
        boolean mithraEmbeddedValueObjectXmlSuccess = this.validateMithraEmbeddedValueObjectXml();
        boolean mithraObjectXmlSuccess = this.validateMithraObjectXml();
        if (!(mithraInterfaceSuccess && mithraEmbeddedValueObjectXmlSuccess && mithraObjectXmlSuccess)) {
            throw new MithraGeneratorException("One or more error(s) while validating mithra xml. See error logs.\n");
        }
    }

    public boolean validateMithraEmbeddedValueObjectXml() {
        return this.resolveMithraObjectEmbeddedValueTypes();
    }

    public boolean validateMithraObjectXml() {
        boolean result = this.checkAllNames();
        result &= this.resolveAttributes();
        result &= this.resolveEmbeddedValues();
        result &= this.resolveSuperClasses();
        result &= this.resolveIndices();
        result &= this.checkRelationships();
        result &= this.resolveMithraInterfaces();
        this.processForeignKeys();
        return result &= this.postValidate();
    }

    private void processForeignKeys() {
        for (MithraObjectTypeWrapper mithraObjectTypeWrapper : this.sortedMithraObjects) {
            mithraObjectTypeWrapper.processForeignKeys();
        }
    }

    private boolean resolveMithraObjectEmbeddedValueTypes() throws JavaTypeException {
        boolean allGood = true;
        for (MithraEmbeddedValueObjectTypeWrapper wrapper : this.sortedMithraEmbeddedValueObjects) {
            List<String> errors = wrapper.resolveNestedEmbeddedValueObjects(this.getMithraEmbeddedValueObjects());
            allGood = this.processErrorsIfAny(errors, allGood, wrapper.getSourceFileName());
        }
        return allGood;
    }

    private boolean checkAllNames() {
        boolean result = true;
        for (MithraObjectTypeWrapper mithraObjectTypeWrapper : this.sortedMithraObjects) {
            List<String> errors = mithraObjectTypeWrapper.checkAllNames(this.mithraObjects);
            result = this.processErrorsIfAny(errors, result, mithraObjectTypeWrapper.getSourceFileName());
        }
        return result;
    }

    private boolean resolveAttributes() throws JavaTypeException {
        boolean allGood = true;
        for (MithraObjectTypeWrapper mithraObjectTypeWrapper : this.sortedMithraObjects) {
            List<String> errors = mithraObjectTypeWrapper.resolveAttributes(this.mithraObjects);
            allGood = this.processErrorsIfAny(errors, allGood, mithraObjectTypeWrapper.getSourceFileName());
        }
        return allGood;
    }

    private boolean resolveIndices() throws JavaTypeException {
        boolean allGood = true;
        for (MithraObjectTypeWrapper mithraObjectTypeWrapper : this.sortedMithraObjects) {
            List<String> errors = mithraObjectTypeWrapper.resolveIndices();
            allGood = this.processErrorsIfAny(errors, allGood, mithraObjectTypeWrapper.getSourceFileName());
        }
        return allGood;
    }

    private boolean resolveSuperClasses() throws JavaTypeException {
        List<String> errors;
        boolean allGood = true;
        for (MithraObjectTypeWrapper mithraObjectTypeWrapper : this.sortedMithraObjects) {
            errors = mithraObjectTypeWrapper.resolveSuperClasses(this.mithraObjects);
            allGood = this.processErrorsIfAny(errors, allGood, mithraObjectTypeWrapper.getSourceFileName());
        }
        if (allGood) {
            for (MithraObjectTypeWrapper mithraObjectTypeWrapper : this.sortedMithraObjects) {
                errors = mithraObjectTypeWrapper.resolveSuperClassGeneration();
                allGood = this.processErrorsIfAny(errors, allGood, mithraObjectTypeWrapper.getSourceFileName());
            }
            if (allGood) {
                this.assignSuperClassPackage();
            }
        }
        return allGood;
    }

    private void assignSuperClassPackage() {
        HashMap<MithraSuperTypeWrapper, ArrayList<MithraObjectTypeWrapper>> map = new HashMap<MithraSuperTypeWrapper, ArrayList<MithraObjectTypeWrapper>>();
        for (MithraObjectTypeWrapper mithraObjectTypeWrapper : this.sortedMithraObjects) {
            MithraSuperTypeWrapper superType = mithraObjectTypeWrapper.getSubstituteSuperType();
            if (superType == null) continue;
            ArrayList<MithraObjectTypeWrapper> typeWrappers = (ArrayList<MithraObjectTypeWrapper>)map.get(superType);
            if (typeWrappers == null) {
                typeWrappers = new ArrayList<MithraObjectTypeWrapper>();
                map.put(superType, typeWrappers);
            }
            typeWrappers.add(mithraObjectTypeWrapper);
        }
        for (Map.Entry entry : map.entrySet()) {
            List typeWrappers = (List)entry.getValue();
            MithraSuperTypeWrapper superTypeWrapper = (MithraSuperTypeWrapper)entry.getKey();
            if (superTypeWrapper.getPackageName() == null) {
                String bestPackage = ((MithraObjectTypeWrapper)typeWrappers.get(0)).getPackageName();
                for (int i = 1; i < typeWrappers.size(); ++i) {
                    String pkg = ((MithraObjectTypeWrapper)typeWrappers.get(i)).getPackageName();
                    if (pkg.compareTo(bestPackage) >= 0) continue;
                    bestPackage = pkg;
                }
                superTypeWrapper.setPackageName(bestPackage);
            }
            for (int i = 0; i < typeWrappers.size(); ++i) {
                ((MithraObjectTypeWrapper)typeWrappers.get(i)).setSubstituteSuperType(superTypeWrapper);
            }
        }
    }

    private boolean resolveEmbeddedValues() throws JavaTypeException {
        boolean allGood = true;
        for (MithraObjectTypeWrapper mithraObjectTypeWrapper : this.sortedMithraObjects) {
            List errors = mithraObjectTypeWrapper.resolveEmbeddedValueObjects(this.getMithraEmbeddedValueObjects(), this.mithraObjects);
            allGood = this.processErrorsIfAny(errors, allGood, mithraObjectTypeWrapper.getSourceFileName());
        }
        return allGood;
    }

    private boolean resolveMithraInterfaces() throws JavaTypeException {
        boolean allGood = true;
        for (MithraObjectTypeWrapper mithraObjectTypeWrapper : this.sortedMithraObjects) {
            List errors = mithraObjectTypeWrapper.resolveMithraInterfaces(this.getMithraInterfaces());
            allGood = this.processErrorsIfAny(errors, allGood, mithraObjectTypeWrapper.getSourceFileName());
        }
        return allGood;
    }

    private boolean checkRelationships() {
        boolean result = true;
        for (MithraObjectTypeWrapper mithraObjectTypeWrapper : this.sortedMithraObjects) {
            List<String> indexErrors;
            Map<String, List<String>> errors = mithraObjectTypeWrapper.checkRelationships(this.mithraObjects);
            if (errors.size() > 0) {
                result = false;
                this.logger.error("\n" + mithraObjectTypeWrapper.getSourceFileName() + ": ");
                for (String key : errors.keySet()) {
                    this.logger.error("\n-- Relationship '" + key + "' -- ");
                    this.printErrors(errors.get(key));
                }
            }
            if ((indexErrors = mithraObjectTypeWrapper.checkAttributeNamesInIndices()).size() <= 0) continue;
            this.logger.error("\n" + mithraObjectTypeWrapper.getSourceFileName() + ": ");
            result = false;
            this.printErrors(indexErrors);
        }
        return result;
    }

    private boolean postValidate() throws JavaTypeException {
        boolean allGood = true;
        for (MithraObjectTypeWrapper mithraObjectTypeWrapper : this.sortedMithraObjects) {
            List<String> errors = mithraObjectTypeWrapper.postValidate();
            allGood = this.processErrorsIfAny(errors, allGood, mithraObjectTypeWrapper.getSourceFileName());
        }
        return allGood;
    }

    private boolean processErrorsIfAny(List errors, boolean allGood, String sourceFileName) {
        if (errors.size() > 0) {
            allGood = false;
            this.logger.error("\n" + sourceFileName + ": ");
            this.printErrors(errors);
        }
        return allGood;
    }

    private void printErrors(List errors) {
        for (int i = 0; i < errors.size(); ++i) {
            this.logger.error("\t" + errors.get(i));
        }
    }

    public void addConfiguredMithraImport(MithraGeneratorImport importElement) {
        importElement.init();
        this.imports.add(importElement);
    }

    public ChopAndStickResource getChopAndStickResource() {
        return this.chopAndStickResource;
    }

    public AwaitingThreadExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = new AwaitingThreadExecutor(Runtime.getRuntime().availableProcessors() + 1, "Mithra Generator");
            this.executor.setExceptionHandler(new AutoShutdownThreadExecutor.ExceptionHandler(){

                @Override
                public void handleException(AutoShutdownThreadExecutor executor, Runnable target, Throwable exception) {
                    executor.shutdownNow();
                    BaseMithraGenerator.this.logger.error("Error in runnable target. Shutting down queue " + exception.getClass().getName() + " :" + exception.getMessage());
                    BaseMithraGenerator.this.executorError = exception;
                }
            });
        }
        return this.executor;
    }

    public void execute() {
        this.logger.info("nothing to do");
    }

    public void setMithraObjectTypeParser(MithraObjectTypeParser mithraObjectTypeParser) {
        this.mithraObjectTypeParser = mithraObjectTypeParser;
    }

    public static class SimpleGenerationLogger
    implements GenerationLogger {
        private GenerationLog oldGenerationLog;
        private GenerationLog newGenerationLog;

        @Override
        public GenerationLog getOldGenerationLog() {
            return this.oldGenerationLog;
        }

        @Override
        public GenerationLog getNewGenerationLog() {
            return this.newGenerationLog;
        }

        @Override
        public void setOldGenerationLog(GenerationLog log) {
            this.oldGenerationLog = log;
        }

        @Override
        public void setNewGenerationLog(GenerationLog log) {
            this.newGenerationLog = log;
        }
    }

    public abstract class GeneratorTask
    implements Runnable {
        private int resourceNumber;

        public GeneratorTask(int resourceNumber) {
            this.resourceNumber = resourceNumber;
        }

        public void acquireSerialResource() {
            BaseMithraGenerator.this.getChopAndStickResource().acquireSerialResource(this.resourceNumber);
        }

        public void releaseSerialResource() {
            BaseMithraGenerator.this.getChopAndStickResource().releaseSerialResource();
        }
    }

    private class ParentClassComparator
    implements Comparator {
        private ParentClassComparator() {
        }

        public int compare(Object o1, Object o2) {
            MithraObjectTypeWrapper left = (MithraObjectTypeWrapper)o1;
            MithraObjectTypeWrapper right = (MithraObjectTypeWrapper)o2;
            Map<String, MithraObjectTypeWrapper> mithraObjects = BaseMithraGenerator.this.getMithraObjects();
            int result = left.getHierarchyDepth(mithraObjects) - right.getHierarchyDepth(mithraObjects);
            if (result == 0) {
                result = left.getClassName().compareTo(right.getClassName());
            }
            return result;
        }
    }
}

