/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.EmbeddedValue;
import com.gs.fw.common.mithra.generator.MithraGeneratorException;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.metamodel.EmbeddedValueMappingType;
import com.gs.fw.common.mithra.generator.metamodel.SimulatedSequenceType;
import com.gs.fw.common.mithra.generator.metamodel.TimePrecisionType;
import com.gs.fw.common.mithra.generator.metamodel.TimestampPrecisionType;
import com.gs.fw.common.mithra.generator.metamodel.TimezoneConversionType;
import com.gs.fw.common.mithra.generator.type.StringJavaType;
import com.gs.fw.common.mithra.generator.util.StringUtility;

public class EmbeddedValueMapping
extends Attribute {
    private EmbeddedValueMappingType wrapped;
    private EmbeddedValue parent;
    private String mappingName;
    private String shortName;

    public EmbeddedValueMapping(EmbeddedValueMappingType wrapped, MithraObjectTypeWrapper owner, EmbeddedValue parent) {
        this(wrapped, owner, parent, wrapped.getAttribute());
    }

    private EmbeddedValueMapping(EmbeddedValueMappingType wrapped, MithraObjectTypeWrapper owner, EmbeddedValue parent, String name) {
        super(owner);
        this.wrapped = wrapped;
        this.parent = parent;
        this.mappingName = name;
        this.shortName = name;
        if (this.wrapped.getUnderlyingAttribute() != null) {
            this.setName(this.wrapped.getUnderlyingAttribute());
        } else {
            this.setName(parent.getNestedName() + StringUtility.firstLetterToUpper(this.getShortName()));
        }
    }

    private EmbeddedValueMappingType getMappingType() {
        return this.wrapped;
    }

    public EmbeddedValue getParent() {
        return this.parent;
    }

    public String getMappingName() {
        return this.mappingName;
    }

    @Override
    public boolean isFinalGetter() {
        return this.wrapped.isFinalGetterSet() ? this.wrapped.isFinalGetter() : this.getOwner().isDefaultFinalGetters();
    }

    @Override
    public String getName() {
        return this.getMappingType().getAttribute();
    }

    @Override
    protected void setName(String name) {
        this.getMappingType().setAttribute(name);
    }

    @Override
    public String getPlainColumnName() {
        return this.getMappingType().getColumnName();
    }

    @Override
    public void setColumnName(String columnName) {
        this.getMappingType().setColumnName(columnName);
    }

    @Override
    public boolean hasMaxLength() {
        return this.getMappingType().isMaxLengthSet();
    }

    @Override
    public int getMaxLength() {
        return this.getMappingType().getMaxLength();
    }

    @Override
    public boolean mustTrim() {
        return this.isStringAttribute() && this.getMappingType().isTrim();
    }

    @Override
    public boolean hasModifyTimePrecisionOnSet() {
        return this.getMappingType().isModifyTimePrecisionOnSetSet();
    }

    @Override
    public TimePrecisionType getModifyTimePrecisionOnSet() {
        return this.getMappingType().getModifyTimePrecisionOnSet();
    }

    @Override
    public int getMaxLengthForComparison() {
        if (this.hasMaxLength()) {
            return this.getMappingType().getMaxLength();
        }
        return 255;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.getMappingType().isPrimaryKey();
    }

    @Override
    public boolean isIdentity() {
        return this.getMappingType().isIdentitySet();
    }

    @Override
    public boolean isMutablePrimaryKey() {
        return this.getMappingType().isMutablePrimaryKey();
    }

    @Override
    public boolean isPrimaryKeyUsingSimulatedSequence() {
        return this.getMappingType().isSimulatedSequenceSet();
    }

    @Override
    public SimulatedSequenceType getSimulatedSequence() {
        return this.getMappingType().getSimulatedSequence();
    }

    @Override
    public boolean isSetPrimaryKeyGeneratorStrategy() {
        return this.getMappingType() != null && this.getMappingType().isPrimaryKeyGeneratorStrategySet();
    }

    @Override
    public String getPrimaryKeyGeneratorStrategy() {
        return this.getMappingType().getPrimaryKeyGeneratorStrategy().value();
    }

    @Override
    public boolean isNullable() {
        return this.getMappingType().isNullable() && (this.getMappingType().isNullableSet() || !this.getMappingType().isPrimaryKey());
    }

    @Override
    public boolean isPoolable() {
        if (this.getMappingType().isPoolableSet() && !(this.getType() instanceof StringJavaType)) {
            throw new MithraGeneratorException("In " + this.getOwner().getClassName() + ".xml: Cannot specify 'poolable' on attribute '" + this.getName() + "' of type '" + super.getTypeAsString() + "' because it not of type 'String'");
        }
        return this.getType() instanceof StringJavaType && this.getMappingType().isPoolable();
    }

    @Override
    public String getDefaultIfNull() {
        return this.getMappingType().getDefaultIfNull();
    }

    @Override
    public boolean trimString() {
        if (this.getMappingType().isTrimSet() && !(this.getType() instanceof StringJavaType)) {
            throw new MithraGeneratorException("In " + this.getOwner().getClassName() + ".xml: Cannot specify 'trim' on attribute '" + this.getName() + "' of type '" + super.getTypeAsString() + "' because it not of type 'String'");
        }
        return this.getType() instanceof StringJavaType && this.getMappingType().isTrim();
    }

    @Override
    public boolean isReadonly() {
        return this.getMappingType().isReadonly();
    }

    @Override
    public boolean isUsedForOptimisticLocking() {
        return this.getMappingType().isUseForOptimisticLocking();
    }

    @Override
    public boolean truncate() {
        return this.getMappingType().isTruncate();
    }

    @Override
    public TimezoneConversionType getTimezoneConversion() {
        TimezoneConversionType timezoneConversion = this.getMappingType().getTimezoneConversion();
        if (timezoneConversion == null) {
            timezoneConversion = this.getDefaultTimezoneConversion();
        }
        return timezoneConversion;
    }

    @Override
    public TimestampPrecisionType getTimestampPrecision() {
        return this.getMappingType().getTimestampPrecision();
    }

    public boolean isRoot() {
        return this.parent.isRoot();
    }

    public boolean isNested() {
        return this.parent.isNested();
    }

    public int getHierarchyDepth() {
        return this.parent.getHierarchyDepth();
    }

    @Override
    protected void validateIsSetPoolable(Attribute superClassAttribute) {
        boolean isPoolable;
        boolean isSetPoolable;
        if (superClassAttribute instanceof EmbeddedValueMapping) {
            isSetPoolable = ((EmbeddedValueMapping)superClassAttribute).getMappingType().isPoolableSet();
            isPoolable = ((EmbeddedValueMapping)superClassAttribute).getMappingType().isPoolable();
        } else {
            isSetPoolable = superClassAttribute.getAttributeType().isPoolableSet();
            isPoolable = superClassAttribute.getAttributeType().isPoolable();
        }
        if (!this.getMappingType().isPoolableSet() && isSetPoolable) {
            this.getMappingType().setPoolable(isPoolable);
        }
    }

    @Override
    protected void validateIsSetTrim(Attribute superClassAttribute) {
        boolean isTrim;
        boolean isSetTrim;
        if (superClassAttribute instanceof EmbeddedValueMapping) {
            isSetTrim = ((EmbeddedValueMapping)superClassAttribute).getMappingType().isTrimSet();
            isTrim = ((EmbeddedValueMapping)superClassAttribute).getMappingType().isTrim();
        } else {
            isSetTrim = superClassAttribute.getAttributeType().isTrimSet();
            isTrim = superClassAttribute.getAttributeType().isTrim();
        }
        if (!this.getMappingType().isTrimSet() && isSetTrim) {
            this.getMappingType().setTrim(isTrim);
        }
    }

    @Override
    protected void validateIsSetTruncate(Attribute superClassAttribute) {
        boolean isTruncate;
        boolean isSetTruncate;
        if (superClassAttribute instanceof EmbeddedValueMapping) {
            isSetTruncate = ((EmbeddedValueMapping)superClassAttribute).getMappingType().isTruncateSet();
            isTruncate = ((EmbeddedValueMapping)superClassAttribute).getMappingType().isTruncate();
        } else {
            isSetTruncate = superClassAttribute.getAttributeType().isTruncateSet();
            isTruncate = superClassAttribute.getAttributeType().isTruncate();
        }
        if (!this.getMappingType().isTruncateSet() && isSetTruncate) {
            this.getMappingType().setTruncate(isTruncate);
        }
    }

    @Override
    protected void validateIsSetNullable(Attribute superClassAttribute) {
        boolean isNullable;
        boolean isSetNullable;
        if (superClassAttribute instanceof EmbeddedValueMapping) {
            isSetNullable = ((EmbeddedValueMapping)superClassAttribute).getMappingType().isNullableSet();
            isNullable = ((EmbeddedValueMapping)superClassAttribute).getMappingType().isNullable();
        } else {
            isSetNullable = superClassAttribute.getAttributeType().isNullableSet();
            isNullable = superClassAttribute.getAttributeType().isNullable();
        }
        if (!this.getMappingType().isNullableSet() && isSetNullable) {
            this.getMappingType().setNullable(isNullable);
        }
    }

    @Override
    protected void validateIsSetTimezoneConversion(Attribute superClassAttribute) {
        TimezoneConversionType timezoneConversion;
        boolean isSetTimezoneConversion;
        if (superClassAttribute instanceof EmbeddedValueMapping) {
            isSetTimezoneConversion = ((EmbeddedValueMapping)superClassAttribute).getMappingType().isTimezoneConversionSet();
            timezoneConversion = ((EmbeddedValueMapping)superClassAttribute).getMappingType().getTimezoneConversion();
        } else {
            isSetTimezoneConversion = superClassAttribute.getAttributeType().isTimezoneConversionSet();
            timezoneConversion = superClassAttribute.getAttributeType().getTimezoneConversion();
        }
        if (!this.getMappingType().isTimezoneConversionSet() && isSetTimezoneConversion) {
            this.getMappingType().setTimezoneConversion(timezoneConversion);
        }
    }

    @Override
    protected void validateColumnName(Attribute superClassAttribute) {
        if (this.getMappingType().getColumnName() == null) {
            this.getMappingType().setColumnName(superClassAttribute.getColumnName());
        }
    }

    @Override
    protected void validateDefaultIfNull(Attribute superClassAttribute) {
        if (this.getMappingType().getDefaultIfNull() == null) {
            this.getMappingType().setDefaultIfNull(superClassAttribute.getDefaultIfNull());
        }
    }

    @Override
    public EmbeddedValueMapping cloneForNewOwner(MithraObjectTypeWrapper newOwner) {
        EmbeddedValueMapping result = new EmbeddedValueMapping(this.getMappingType(), newOwner, this.getParent(), this.getShortName());
        result.setJavaType(this.getTypeAsString());
        return result;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getShortNameNullGetter() {
        return "is" + StringUtility.firstLetterToUpper(this.getShortName()) + "Null()";
    }

    public String getShortNameGetter() {
        return "get" + StringUtility.firstLetterToUpper(this.getShortName());
    }

    public String getShortNameSetter() {
        return "set" + StringUtility.firstLetterToUpper(this.getShortName());
    }

    public String getChainedNullGetter() {
        return this.parent.getChainedGetter() + "()." + this.getShortNameNullGetter();
    }

    public String getChainedGetter() {
        return this.parent.getChainedGetter() + "()." + this.getShortNameGetter();
    }

    public String getChainedGetterAfterDepth(int hierarchyDepth) {
        return this.parent.getChainedGetterAfterDepth(hierarchyDepth) + "()." + this.getShortNameGetter();
    }

    public String getChainedNullGetterAfterDepth(int hierarchyDepth) {
        return this.parent.getChainedGetterAfterDepth(hierarchyDepth) + "()." + this.getShortNameNullGetter();
    }

    public String getChainedSetter() {
        return this.parent.getChainedGetter() + "()." + this.getShortNameSetter();
    }

    public String getSetterUntil() {
        return super.getSetter() + "Until";
    }

    @Override
    public String getVisibility() {
        return "protected";
    }

    @Override
    public int getScale() {
        return this.wrapped.getScale();
    }

    @Override
    public int getPrecision() {
        return this.wrapped.getPrecision();
    }

    @Override
    public boolean isMapped() {
        return false;
    }
}

