/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.metamodel.TransactionalMethodSignatureType;
import com.gs.fw.common.mithra.generator.type.JavaType;
import com.gs.fw.common.mithra.generator.type.JavaTypeException;
import com.gs.fw.common.mithra.generator.util.StringUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TransactionalMethodSignature {
    private TransactionalMethodSignatureType wrapped;

    public TransactionalMethodSignature(TransactionalMethodSignatureType wrapped) {
        this.wrapped = wrapped;
    }

    public boolean isParentImplements() {
        return this.wrapped.isParentImplements();
    }

    protected String getMethodExceptions() {
        StringTokenizer tokenizer = new StringTokenizer(this.getOriginalMethodSignature(), ")");
        tokenizer.nextToken();
        if (tokenizer.hasMoreTokens()) {
            return tokenizer.nextToken().trim();
        }
        return "";
    }

    public String getOriginalMethodSignature() {
        return this.wrapped.value();
    }

    public List<String> getExceptions() {
        String tmp = this.getMethodExceptions();
        tmp = StringUtility.replaceStr(tmp, "throws", "");
        StringTokenizer tokenizer = new StringTokenizer(tmp, ",");
        ArrayList<String> exceptions = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String exception = tokenizer.nextToken().trim();
            if (exception.equals("MithraBusinessException")) continue;
            exceptions.add(exception);
        }
        return exceptions;
    }

    protected String getMethodParameters() {
        StringTokenizer tokenizer = new StringTokenizer(this.getOriginalMethodSignature(), "(");
        tokenizer.nextToken();
        if (tokenizer.hasMoreTokens()) {
            String result = tokenizer.nextToken(")").trim().substring(1);
            if (!result.equals("")) {
                result = result + ",";
            }
            return result;
        }
        return "";
    }

    public String getMethodParametersNoType() {
        String tmp = this.getMethodParameters();
        StringTokenizer tokenizer = new StringTokenizer(tmp, ",");
        String parameters = "";
        int noOfArguments = tokenizer.countTokens();
        if (noOfArguments > 0) {
            while (tokenizer.hasMoreTokens()) {
                String param = tokenizer.nextToken().trim();
                parameters = parameters + param.substring(param.indexOf(" ")).trim() + ",";
            }
        }
        return parameters;
    }

    public String getMethodName() {
        StringTokenizer tokenizer = new StringTokenizer(this.getOriginalMethodSignature(), "(");
        String tmp = tokenizer.nextToken();
        return tmp.substring(tmp.lastIndexOf(" ")).trim();
    }

    public String getReturnType() {
        StringTokenizer tokenizer = new StringTokenizer(this.getOriginalMethodSignature(), "(");
        String tmp = tokenizer.nextToken();
        tmp = StringUtility.replaceStr(tmp, this.getMethodName(), "");
        tmp = StringUtility.replaceStr(tmp, "public", "");
        tmp = StringUtility.replaceStr(tmp, "private", "");
        tmp = StringUtility.replaceStr(tmp, "protected", "");
        tmp = StringUtility.replaceStr(tmp, "final", "");
        return tmp.trim();
    }

    public boolean isVoid() {
        return this.getReturnType().equals("void");
    }

    protected String getMethodScope() {
        StringTokenizer tokenizer = new StringTokenizer(this.getOriginalMethodSignature(), "(");
        String tmp = tokenizer.nextToken();
        tmp = StringUtility.replaceStr(tmp, this.getMethodName(), "");
        tmp = StringUtility.replaceStr(tmp, this.getReturnType(), "");
        return tmp.trim();
    }

    public String getImplMethodSignature() {
        if (this.wrapped.isParentImplements()) {
            return "";
        }
        String result = "protected abstract ";
        result = result + this.getReturnType() + " ";
        result = result + this.getMethodName() + "Impl";
        result = result + "(" + this.getMethodParameters() + " MithraTransaction mithraTransaction)";
        result = result + this.getMethodExceptions();
        result = result + ";";
        return result;
    }

    public String getMethodSignatureWithRetryCount() {
        String result = "protected ";
        result = result + this.getReturnType() + " ";
        result = result + this.getMethodName();
        result = result + "(" + this.getMethodParameters() + " int _retryCount)";
        result = result + this.getMethodExceptions();
        return result;
    }

    public String getDefaultInitialValueForReturnType() {
        try {
            JavaType type = JavaType.create(this.getReturnType());
            return type.getDefaultInitialValue();
        }
        catch (JavaTypeException e) {
            return "null";
        }
    }
}

