/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.computedattribute;

import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.computedattribute.CaseFragment;
import com.gs.fw.common.mithra.generator.computedattribute.Expression;
import com.gs.fw.common.mithra.generator.computedattribute.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CaseExpression
extends Expression {
    private Expression sourceExpression;
    private List<CaseFragment> fragments = new ArrayList<CaseFragment>();
    private boolean finished;

    public CaseExpression(Expression expression) {
        this.sourceExpression = expression;
    }

    public void markFinished() {
        this.finished = true;
    }

    public void startNewKey() {
        this.fragments.add(new CaseFragment(this.sourceExpression.getType()));
    }

    public void endKey() {
        this.lastFragment().endKey();
    }

    public CaseFragment lastFragment() {
        return this.fragments.get(this.fragments.size() - 1);
    }

    public void addNullKey() {
        this.lastFragment().addNullKey();
    }

    public void addStringConstantKey(String constant) {
        this.lastFragment().addStringKey(constant);
    }

    public void addNumberKey(double nval) {
        this.lastFragment().addNumberKey(nval);
    }

    public void addBooleanKey(boolean value) {
        this.lastFragment().addBooleanKey(value);
    }

    public void addDefaultKey() {
        this.lastFragment().addDefaultKey();
    }

    public void setValue(Expression param) {
        this.lastFragment().setValue(param);
    }

    @Override
    public void addAttributeList(Set<String> result) {
        this.sourceExpression.addAttributeList(result);
        for (int i = 0; i < this.fragments.size(); ++i) {
            this.fragments.get(i).addAttributeList(result);
        }
    }

    @Override
    public void resolveAttributes(MithraObjectTypeWrapper wrapper, List<String> errors) {
        this.sourceExpression.resolveAttributes(wrapper, errors);
        for (int i = 0; i < this.fragments.size(); ++i) {
            this.fragments.get(i).resolveAttributes(wrapper, errors);
        }
    }

    @Override
    public Type getType() {
        Type valueType = this.fragments.get(0).getValueType();
        for (int i = 1; i < this.fragments.size(); ++i) {
            valueType = valueType.computeMostCompatibleType(this.fragments.get(1).getValueType());
        }
        return valueType;
    }
}

