/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.filesystem;

import com.gs.fw.common.mithra.generator.MithraGeneratorException;
import com.gs.fw.common.mithra.generator.filesystem.FauxFile;
import com.gs.fw.common.mithra.generator.filesystem.GeneratedFileManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;

public class StandardGeneratedFileManager
implements GeneratedFileManager {
    private GeneratedFileManager.Options options;

    @Override
    public void setOptions(GeneratedFileManager.Options options) {
        this.options = options;
    }

    @Override
    public boolean shouldCreateFile(boolean replaceIfExists, String packageName, String className, String outputFileSuffix) {
        String targetDir = replaceIfExists ? this.options.generatedDir : this.options.nonGeneratedDir;
        FauxFile outDir = this.options.fauxFileSystem.newFile(targetDir, packageName);
        FauxFile outFile = this.options.fauxFileSystem.newFile(outDir, className + outputFileSuffix + ".java");
        if (outFile.exists() && !replaceIfExists) {
            return false;
        }
        if (!(outFile.exists() || replaceIfExists || this.options.generateConcreteClasses)) {
            if (this.options.warnAboutConcreteClasses) {
                this.options.logger.info("concrete class file '" + outFile + "' does not exist and generateConcreteClasses flag is turned off. This might lead to compilation errors");
            }
            return false;
        }
        if (outFile.exists() && this.options.generationLogger.getNewGenerationLog().isSame(this.options.generationLogger.getOldGenerationLog())) {
            this.options.logger.info("skipping " + outFile.getName() + " because it's new and no changes to generator have been made");
            return false;
        }
        return true;
    }

    @Override
    public void writeFile(boolean replaceIfExists, String packageName, String className, String outputFileSuffix, byte[] fileData, AtomicInteger count) throws IOException {
        String targetDir = replaceIfExists ? this.options.generatedDir : this.options.nonGeneratedDir;
        FauxFile outDir = this.options.fauxFileSystem.newFile(targetDir, packageName);
        FauxFile outFile = this.options.fauxFileSystem.newFile(outDir, className + outputFileSuffix);
        outDir.mkdirs();
        this.copyIfChanged(fileData, outFile, count);
    }

    public void copyIfChanged(byte[] src, FauxFile outFile, AtomicInteger count) throws IOException {
        boolean copyFile = false;
        if (!outFile.exists() || outFile.length() != (long)src.length) {
            copyFile = true;
        } else {
            byte[] outContent = this.readFile(outFile);
            for (int i = 0; i < src.length; ++i) {
                if (src[i] == outContent[i]) continue;
                copyFile = true;
                break;
            }
        }
        if (copyFile && outFile.exists() && !outFile.canWrite()) {
            throw new MithraGeneratorException(outFile + " must be updated, but it is readonly.");
        }
        if (copyFile) {
            OutputStream fout = outFile.newFileOutputStream();
            fout.write(src);
            fout.close();
            count.incrementAndGet();
            this.options.logger.info("wrote file: " + outFile.getName());
        }
    }

    @Override
    public byte[] readFileInGeneratedDir(String relativePath) throws IOException {
        FauxFile file = this.options.fauxFileSystem.newFile(this.options.generatedDir, relativePath);
        if (file.exists() && !file.isDirectory()) {
            return this.readFile(file);
        }
        return null;
    }

    private byte[] readFile(FauxFile file) throws IOException {
        int length = (int)file.length();
        InputStream fis = file.newFileInputStream();
        byte[] result = new byte[length];
        for (int pos = 0; pos < length; pos += fis.read(result, pos, length - pos)) {
        }
        fis.close();
        return result;
    }
}

