/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.mapper;

import com.gs.fw.common.mithra.generator.AbstractAttribute;
import com.gs.fw.common.mithra.generator.AsOfAttribute;
import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.Index;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.RelationshipAttribute;
import com.gs.fw.common.mithra.generator.SourceAttribute;
import com.gs.fw.common.mithra.generator.queryparser.ASTAndExpression;
import com.gs.fw.common.mithra.generator.queryparser.ASTAttributeName;
import com.gs.fw.common.mithra.generator.queryparser.ASTInLiteral;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.queryparser.ASTOrExpression;
import com.gs.fw.common.mithra.generator.queryparser.ASTRelationalExpression;
import com.gs.fw.common.mithra.generator.queryparser.MithraQLVisitorAdapter;
import com.gs.fw.common.mithra.generator.queryparser.Operator;
import com.gs.fw.common.mithra.generator.queryparser.SimpleNode;
import com.gs.fw.common.mithra.generator.util.StringUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Join {
    private MithraObjectTypeWrapper left;
    private MithraObjectTypeWrapper right;
    private boolean isJoinedToThis;
    private SimpleNode leftFilters;
    private SimpleNode rightFilters;
    private List<ASTRelationalExpression> joins = new ArrayList<ASTRelationalExpression>();
    private List<String> filterLiterals;
    private RelationshipAttribute relationshipAttribute;

    public Join(MithraObjectTypeWrapper left, MithraObjectTypeWrapper right, boolean joinedToThis, RelationshipAttribute relationshipAttribute) {
        this.left = left;
        this.right = right;
        this.isJoinedToThis = joinedToThis;
        this.relationshipAttribute = relationshipAttribute;
    }

    public void addIndices() {
        FilterIndexVisitor visitor;
        List<AbstractAttribute> leftAttributes = this.getLeftRelationshipAttributes();
        List<AbstractAttribute> rightAttributes = this.getRightRelationshipAttributes();
        if (this.leftFilters != null) {
            visitor = new FilterIndexVisitor();
            this.leftFilters.jjtAccept(visitor, null);
            leftAttributes.addAll(visitor.getAttributes());
        }
        if (this.rightFilters != null) {
            visitor = new FilterIndexVisitor();
            this.rightFilters.jjtAccept(visitor, null);
            rightAttributes.addAll(visitor.getAttributes());
        }
        this.left.addIndex(leftAttributes, this.right);
        this.right.addIndex(rightAttributes, this.left);
    }

    public List<AbstractAttribute> getLeftRelationshipAttributes() {
        ArrayList<AbstractAttribute> leftAttributes = new ArrayList<AbstractAttribute>();
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            leftAttributes.add(exp.getLeft().getAttribute());
        }
        return leftAttributes;
    }

    public Attribute[] getLeftRelationshipAttributesAsArray() {
        List<AbstractAttribute> leftAttributes = this.getLeftRelationshipAttributes();
        Attribute[] attributeArray = new Attribute[leftAttributes.size()];
        for (int i = 0; i < attributeArray.length; ++i) {
            attributeArray[i] = (Attribute)leftAttributes.get(i);
        }
        return attributeArray;
    }

    public List<AbstractAttribute> getRightRelationshipAttributes() {
        ArrayList<AbstractAttribute> rightAttributes = new ArrayList<AbstractAttribute>();
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            rightAttributes.add(((ASTAttributeName)exp.getRight()).getAttribute());
        }
        return rightAttributes;
    }

    public Attribute[] getRightRelationshipAttributesAsArray() {
        List<AbstractAttribute> rightAttributes = this.getRightRelationshipAttributes();
        Attribute[] attributeArray = new Attribute[rightAttributes.size()];
        for (int i = 0; i < attributeArray.length; ++i) {
            attributeArray[i] = (Attribute)rightAttributes.get(i);
        }
        return attributeArray;
    }

    public void autoAddSourceAndAsOfAttributeJoins() {
        this.autoAddSourceAttributeJoin();
        this.autoAddAsOfAttributeJoins();
    }

    public void autoAddSourceAttributeJoin() {
        if (this.right.hasSourceAttribute() && this.left.hasSourceAttribute()) {
            SourceAttribute rightSource = this.right.getSourceAttribute();
            SourceAttribute leftSource = this.left.getSourceAttribute();
            if (leftSource.getType().equals(rightSource.getType()) && leftSource.getName().equals(rightSource.getName()) && this.hasNoOperationForRightAttribute(rightSource)) {
                this.joins.add(new ASTRelationalExpression((AbstractAttribute)leftSource, rightSource, this.isJoinedToThis));
            }
        }
    }

    public void autoAddAsOfAttributeJoins() {
        if (this.right.hasAsOfAttributes() && this.left.hasAsOfAttributes()) {
            AsOfAttribute[] rightAsOfAttributes = this.right.getAsOfAttributes();
            for (int i = 0; i < rightAsOfAttributes.length; ++i) {
                AsOfAttribute leftAsOfAttribute;
                if (!this.hasNoOperationForRightAttribute(rightAsOfAttributes[i]) || (leftAsOfAttribute = this.left.getCompatibleAsOfAttribute(rightAsOfAttributes[i])) == null) continue;
                this.joins.add(new ASTRelationalExpression((AbstractAttribute)leftAsOfAttribute, rightAsOfAttributes[i], this.isJoinedToThis));
            }
        }
    }

    public MithraObjectTypeWrapper getLeft() {
        return this.left;
    }

    public MithraObjectTypeWrapper getRight() {
        return this.right;
    }

    public String constructMapper(String variable, String finalExpression) {
        if (this.leftFilters != null || this.rightFilters != null) {
            return this.constructFilteredMapper(variable, finalExpression);
        }
        return this.constructPureMapper(variable, finalExpression);
    }

    public String constructMapper(String variable) {
        return this.constructMapper(variable, "Mapper " + variable + " = ");
    }

    public String constructPureMapper(String variable) {
        return this.constructPureMapper(variable, "Mapper " + variable + " = ");
    }

    public String constructPureMapper(String variable, String finalExpression) {
        if (this.joins.size() > 1) {
            return this.constructMultiEqualityMapper(variable, finalExpression);
        }
        return this.constructEqualityMapper(finalExpression);
    }

    private String constructMultiEqualityMapper(String variable, String finalExpression) {
        String result = "InternalList " + variable + "MapperList = new InternalList(" + this.joins.size() + "); \n";
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            result = result + variable + "MapperList.add(" + this.getJoinExpression(exp) + "); \n";
        }
        result = result + finalExpression + " new MultiEqualityMapper(" + variable + "MapperList);";
        return result;
    }

    private String constructFilteredMapper(String variable, String finalExpression) {
        String result = this.constructPureMapper(variable + "InnerMapper", "Mapper " + variable + "InnerMapper = ");
        result = result + "\n" + finalExpression + " new FilteredMapper(" + variable + "InnerMapper, " + this.constructFilters(this.leftFilters) + ", " + this.constructFilters(this.rightFilters) + ");";
        return result;
    }

    private String constructEqualityMapper(String finalExpression) {
        ASTRelationalExpression join = this.joins.get(0);
        return finalExpression + this.getJoinExpression(join) + ";";
    }

    private String constructFilters(SimpleNode filters) {
        if (filters == null) {
            return "null";
        }
        FilterVisitor filterVisitor = new FilterVisitor();
        filters.jjtAccept(filterVisitor, null);
        return filterVisitor.getResult();
    }

    private int countEqualityFilters(SimpleNode filters) {
        if (filters == null) {
            return 0;
        }
        EqualityFilterCountVisitor filterVisitor = new EqualityFilterCountVisitor();
        filters.jjtAccept(filterVisitor, null);
        return filterVisitor.getResult();
    }

    private String getJoinExpression(ASTRelationalExpression join) {
        String result = null;
        MithraObjectTypeWrapper owner = join.getLeft().getOwner();
        int index = owner.getJoinIndexFromConstantPool(join);
        if (index < 0) {
            owner = ((ASTAttributeName)join.getRight()).getOwner();
            index = owner.getJoinIndexFromConstantPool(join);
        }
        if (index >= 0) {
            result = owner.getFinderClassName() + ".zGetConstantJoin(" + index + ")";
        }
        if (result == null) {
            result = join.getJoinExpression();
        }
        return result;
    }

    private boolean hasNoOperationForRightAttribute(AbstractAttribute rightSource) {
        boolean found = false;
        for (int i = 0; !found && i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            found = ((ASTAttributeName)exp.getRight()).getAttribute().getName().equals(rightSource.getName());
        }
        if (!found) {
            found = this.hasFilterForAttribute(this.rightFilters, rightSource);
        }
        return !found;
    }

    private boolean hasNoOperationForLeftAttribute(AbstractAttribute leftSource) {
        boolean found = false;
        for (int i = 0; !found && i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            found = exp.getLeft().getAttribute().getName().equals(leftSource.getName());
        }
        if (!found) {
            found = this.hasFilterForAttribute(this.leftFilters, leftSource);
        }
        return !found;
    }

    private boolean hasFilterForAttribute(SimpleNode rightFilters, AbstractAttribute rightSource) {
        boolean found = false;
        if (rightFilters != null) {
            HasAttributeVisitor hasAttributeVisitor = new HasAttributeVisitor(rightSource);
            rightFilters.childrenPolymorphicAccept(hasAttributeVisitor, null);
            found = hasAttributeVisitor.isFound();
        }
        return found;
    }

    public boolean addJoin(ASTRelationalExpression join) {
        boolean added = false;
        ASTAttributeName rightAttribute = (ASTAttributeName)join.getRight();
        if (this.isJoinedToThis == join.involvesThis()) {
            if (this.isJoinedToThis) {
                added = this.hasObject(rightAttribute.getOwner());
            } else {
                ASTAttributeName leftAttribute = join.getLeft();
                if (this.hasObject(leftAttribute.getOwner()) && this.hasObject(rightAttribute.getOwner())) {
                    added = true;
                    join.reAlignForOwner(this.left);
                }
            }
        }
        if (added) {
            this.joins.add(join);
        }
        return added;
    }

    private void addLeftFilter(SimpleNode constraint) {
        this.leftFilters = this.leftFilters == null ? constraint : this.combine(this.leftFilters, constraint);
    }

    private void addRightFilter(SimpleNode constraint) {
        this.rightFilters = this.rightFilters == null ? constraint : this.combine(this.rightFilters, constraint);
    }

    private SimpleNode combine(SimpleNode filters, SimpleNode constraint) {
        if (filters instanceof ASTAndExpression) {
            ASTAndExpression and = (ASTAndExpression)filters;
            and.jjtAddChild(constraint, and.jjtGetNumChildren());
            return and;
        }
        ASTAndExpression result = new ASTAndExpression(0);
        result.jjtAddChild(filters, 0);
        result.jjtAddChild(constraint, 1);
        return result;
    }

    public boolean addConstraint(ASTRelationalExpression constraint) {
        boolean added = false;
        if (this.isJoinedToThis) {
            if (constraint.getLeft().belongsToThis()) {
                this.addLeftFilter(constraint);
                added = true;
            } else if (constraint.getLeft().getOwner().equals(this.right)) {
                this.addRightFilter(constraint);
                added = true;
            }
        } else if (constraint.getLeft().getOwner().equals(this.left)) {
            this.addLeftFilter(constraint);
            added = true;
        } else if (constraint.getLeft().getOwner().equals(this.right)) {
            this.addRightFilter(constraint);
            added = true;
        }
        return added;
    }

    public boolean equals(Object obj) {
        Join other = (Join)obj;
        return other.isJoinedToThis == this.isJoinedToThis && (other.left.getClassName().equals(this.left.getClassName()) && other.right.getClassName().equals(this.right.getClassName()) || other.right.getClassName().equals(this.left.getClassName()) && other.left.getClassName().equals(this.right.getClassName()));
    }

    public int hashCode() {
        return this.left.getClassName().hashCode() ^ this.right.getClassName().hashCode();
    }

    public boolean hasObject(MithraObjectTypeWrapper lastRight) {
        return this.left.getClassName().equals(lastRight.getClassName()) || this.right.getClassName().equals(lastRight.getClassName());
    }

    public boolean addOrConstraint(MithraObjectTypeWrapper constrainedClass, ASTOrExpression node, boolean nodeBelongsToThis) {
        boolean added = false;
        if (this.isJoinedToThis) {
            if (nodeBelongsToThis) {
                this.addLeftFilter(node);
                added = true;
            } else if (constrainedClass.getClassName().equals(this.right.getClassName())) {
                this.addRightFilter(node);
                added = true;
            }
        } else if (this.left.getClassName().equals(constrainedClass.getClassName())) {
            this.addLeftFilter(node);
            added = true;
        } else if (this.right.getClassName().equals(constrainedClass.getClassName())) {
            this.addRightFilter(node);
            added = true;
        }
        return added;
    }

    public void addJoinsToConstantPool() {
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            MithraObjectTypeWrapper toAdd = this.left.chooseForRelationshipAdd(this.right);
            toAdd.addJoinToConstantPool(exp);
            ASTRelationalExpression reverse = this.getReverseJoin(exp);
            toAdd.addJoinToConstantPool(reverse);
        }
    }

    private ASTRelationalExpression getReverseJoin(ASTRelationalExpression exp) {
        return new ASTRelationalExpression(((ASTAttributeName)exp.getRight()).getAttribute(), exp.getLeft().getAttribute(), false);
    }

    public void addOperationsToConstantPool() {
        if (this.leftFilters != null) {
            this.addOperationToConstantPool(this.left, this.leftFilters);
        }
        if (this.rightFilters != null) {
            this.addOperationToConstantPool(this.right, this.rightFilters);
        }
    }

    private void addOperationToConstantPool(MithraObjectTypeWrapper objectTypeWrapper, SimpleNode filters) {
        ConstantPoolAdderVisitor visitor = new ConstantPoolAdderVisitor(objectTypeWrapper);
        filters.childrenPolymorphicAccept(visitor, null);
    }

    public boolean isSingleAttributeJoinIgnoringRightSourceAttribute() {
        if (this.joins.size() > 2) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            SimpleNode right = exp.getRight();
            if (!exp.getOperator().isEqual()) {
                return false;
            }
            ASTAttributeName rightAstAttribute = (ASTAttributeName)right;
            if (rightAstAttribute.isSourceAttribute()) continue;
            ++count;
        }
        return count <= 1;
    }

    public boolean isSingleAttributeJoinIgnoringRightSourceAndAsOfAttribute() {
        if (this.joins.size() > 4) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            SimpleNode right = exp.getRight();
            if (!exp.getOperator().isEqual()) {
                return false;
            }
            ASTAttributeName rightAstAttribute = (ASTAttributeName)right;
            if (rightAstAttribute.isAsOfAttribute() || rightAstAttribute.isSourceAttribute()) continue;
            ++count;
        }
        return count <= 1;
    }

    private Attribute[] getUniqueAttributes(Collection attributeSet) {
        HashSet<String> names = new HashSet<String>();
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (Attribute attribute : attributeSet) {
            if (names.contains(attribute.getName())) continue;
            names.add(attribute.getName());
            list.add(attribute);
        }
        Attribute[] result = new Attribute[list.size()];
        if (list.size() > 0) {
            list.toArray(result);
        }
        return result;
    }

    public Attribute[] getLeftJoinAttributes() {
        HashSet<AbstractAttribute> set = new HashSet<AbstractAttribute>();
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            if (!exp.getOperator().isEqual()) {
                throw new RuntimeException("not implemented");
            }
            ASTAttributeName left = exp.getLeft();
            AbstractAttribute attribute = left.getAttribute();
            set.add(attribute);
        }
        return this.getUniqueAttributes(set);
    }

    public Attribute[] getAttributesForInClauseEval() {
        HashSet<AbstractAttribute> set = new HashSet<AbstractAttribute>();
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            SimpleNode right = exp.getRight();
            if (!exp.getOperator().isEqual()) {
                throw new RuntimeException("not implemented");
            }
            ASTAttributeName rightAstAttribute = (ASTAttributeName)right;
            if (rightAstAttribute.isAsOfAttribute() || rightAstAttribute.isSourceAttribute()) continue;
            ASTAttributeName left = exp.getLeft();
            AbstractAttribute attribute = left.getAttribute();
            set.add(attribute);
        }
        return this.getUniqueAttributes(set);
    }

    public Attribute[] getAsOfAttributesForSingleCheck() {
        HashSet<AbstractAttribute> set = new HashSet<AbstractAttribute>();
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            SimpleNode right = exp.getRight();
            if (!exp.getOperator().isEqual()) {
                throw new RuntimeException("not implemented");
            }
            ASTAttributeName rightAstAttribute = (ASTAttributeName)right;
            if (!rightAstAttribute.isAsOfAttribute()) continue;
            ASTAttributeName left = exp.getLeft();
            AbstractAttribute attribute = left.getAttribute();
            set.add(attribute);
        }
        return this.getUniqueAttributes(set);
    }

    public Map getAsOfAttributesMap() {
        HashMap<AbstractAttribute, AbstractAttribute> result = new HashMap<AbstractAttribute, AbstractAttribute>();
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            SimpleNode right = exp.getRight();
            if (!exp.getOperator().isEqual()) {
                throw new RuntimeException("not implemented");
            }
            ASTAttributeName rightAstAttribute = (ASTAttributeName)right;
            if (!rightAstAttribute.isAsOfAttribute()) continue;
            ASTAttributeName left = exp.getLeft();
            AbstractAttribute attribute = left.getAttribute();
            result.put(rightAstAttribute.getAttribute(), attribute);
        }
        return result;
    }

    public Attribute[] getAttributesToSetOnRelatedObject() {
        Attribute[] result = new Attribute[this.joins.size()];
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            if (!exp.getOperator().isEqual()) {
                throw new RuntimeException("not implemented");
            }
            ASTAttributeName right = (ASTAttributeName)exp.getRight();
            result[i] = (Attribute)right.getAttribute();
        }
        return result;
    }

    public Attribute getAttributeToGetForSetOnRelatedObject(int index) {
        ASTRelationalExpression exp = this.joins.get(index);
        ASTAttributeName left = exp.getLeft();
        return (Attribute)left.getAttribute();
    }

    public Index getUniqueMatchingIndex() {
        List<Index> indices = this.right.getIndices();
        for (int i = 0; i < indices.size(); ++i) {
            Index index = indices.get(i);
            if (!index.isUnique() || !this.matchesAttributes(index.getAttributes(), this.getRightAttributesForMatching())) continue;
            return index;
        }
        return null;
    }

    public boolean isByPrimaryKey() {
        HashSet<String> rightAttributes = this.getRightAttributesForMatching();
        AbstractAttribute[] primaryKeyAttributes = this.right.getPrimaryKeyAttributes();
        return this.matchesAttributes(primaryKeyAttributes, rightAttributes);
    }

    private HashSet<String> getRightAttributesForMatching() {
        HashSet<String> rightAttributes = new HashSet<String>();
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            rightAttributes.add(((ASTAttributeName)exp.getRight()).getAttribute().getName());
        }
        if (this.rightFilters != null) {
            ByPrimaryKeyVisitor visitor = new ByPrimaryKeyVisitor();
            this.rightFilters.jjtAccept(visitor, null);
            for (int i = 0; i < visitor.getAttributes().size(); ++i) {
                rightAttributes.add(((AbstractAttribute)visitor.getAttributes().get(i)).getName());
            }
        }
        if (this.right.hasAsOfAttributes()) {
            AsOfAttribute[] rightAsOfAttributes = this.right.getAsOfAttributes();
            for (int i = 0; i < rightAsOfAttributes.length; ++i) {
                String defaultDateExpression;
                if (rightAttributes.contains(rightAsOfAttributes[i].getName()) || (defaultDateExpression = rightAsOfAttributes[i].getDefaultDateExpression()) == null || defaultDateExpression.equals("null")) continue;
                rightAttributes.add(rightAsOfAttributes[i].getName());
            }
        }
        return rightAttributes;
    }

    private boolean matchesAttributes(AbstractAttribute[] indexAttributes, HashSet<String> rightAttributes) {
        int i;
        HashSet<String> indexAttributeSet = new HashSet<String>();
        for (AbstractAttribute attr : indexAttributes) {
            indexAttributeSet.add(attr.getName());
        }
        SourceAttribute sourceAttribute = this.right.getSourceAttribute();
        if (sourceAttribute != null) {
            indexAttributeSet.add(sourceAttribute.getName());
        }
        if (this.right.hasAsOfAttributes()) {
            AsOfAttribute[] asOfAttributes = this.right.getAsOfAttributes();
            for (i = 0; i < asOfAttributes.length; ++i) {
                indexAttributeSet.add(asOfAttributes[i].getName());
            }
        }
        if (rightAttributes.size() == indexAttributeSet.size()) {
            for (int i2 = 0; i2 < indexAttributes.length; ++i2) {
                rightAttributes.remove(indexAttributes[i2].getName());
            }
            if (sourceAttribute != null) {
                rightAttributes.remove(sourceAttribute.getName());
            }
            if (this.right.hasAsOfAttributes()) {
                AsOfAttribute[] asOfAttributes = this.right.getAsOfAttributes();
                for (i = 0; i < asOfAttributes.length; ++i) {
                    rightAttributes.remove(asOfAttributes[i].getName());
                }
            }
            return rightAttributes.isEmpty();
        }
        return false;
    }

    public String getAsOfAttributesDataMatchesConditions() {
        StringBuilder result = new StringBuilder();
        AsOfAttribute[] asOfAttributes = this.right.getAsOfAttributes();
        for (int i = 0; i < asOfAttributes.length; ++i) {
            this.addAnd(result).append(asOfAttributes[i].getName() + ".dataMatches(_castedTargetData, _asOfDate" + i + ')');
        }
        return result.toString();
    }

    public boolean requiresSrcObjectForEquals() {
        if (!this.left.hasData()) {
            return true;
        }
        for (int j = 0; j < this.joins.size(); ++j) {
            ASTRelationalExpression exp = this.joins.get(j);
            if (!exp.getLeft().isAsOfAttribute()) continue;
            return true;
        }
        return false;
    }

    public boolean requiresSrcDataForEquals() {
        if (!this.left.hasData()) {
            return false;
        }
        for (int j = 0; j < this.joins.size(); ++j) {
            ASTRelationalExpression exp = this.joins.get(j);
            if (exp.getLeft().isAsOfAttribute()) continue;
            return true;
        }
        return false;
    }

    public boolean requiresSrcObjectForHashCode() {
        if (!this.left.hasData()) {
            return true;
        }
        for (int j = 0; j < this.joins.size(); ++j) {
            ASTRelationalExpression exp = this.joins.get(j);
            AbstractAttribute rightAttribute = ((ASTAttributeName)exp.getRight()).getAttribute();
            if (rightAttribute.isAsOfAttribute() || !exp.getLeft().isAsOfAttribute()) continue;
            return true;
        }
        return false;
    }

    public boolean requiresSrcDataForHashCode() {
        if (!this.left.hasData()) {
            return false;
        }
        for (int j = 0; j < this.joins.size(); ++j) {
            ASTRelationalExpression exp = this.joins.get(j);
            if (exp.getLeft().isAsOfAttribute()) continue;
            return true;
        }
        return false;
    }

    public String getEqualsConditions() {
        RightFilterEqualityMapperVisitor filters;
        String filterResult;
        StringBuilder result = new StringBuilder();
        for (int j = 0; j < this.joins.size(); ++j) {
            ASTRelationalExpression exp = this.joins.get(j);
            AbstractAttribute leftAttr = exp.getLeft().getAttribute();
            AbstractAttribute rightAttr = ((ASTAttributeName)exp.getRight()).getAttribute();
            if (rightAttr.isAsOfAttribute()) continue;
            if (leftAttr.isNullable() && rightAttr.isNullable()) {
                this.addAnd(result).append("_castedSrc" + this.getDataOrObject(leftAttr) + '.' + leftAttr.getNullGetter() + " == _castedTargetData." + rightAttr.getNullGetter() + " && (_castedSrc" + this.getDataOrObject(leftAttr) + '.' + leftAttr.getNullGetter() + " || " + this.getRelationshipAttributeEquals(leftAttr, rightAttr) + ')');
                continue;
            }
            if (leftAttr.isNullable()) {
                this.addAnd(result).append("!_castedSrc" + this.getDataOrObject(leftAttr) + '.' + leftAttr.getNullGetter());
            }
            if (rightAttr.isNullable()) {
                this.addAnd(result).append("!_castedTargetData." + rightAttr.getNullGetter());
            }
            this.addAnd(result).append(this.getRelationshipAttributeEquals(leftAttr, rightAttr));
        }
        if (this.rightFilters != null && (filterResult = (String)this.rightFilters.jjtAccept(filters = new RightFilterEqualityMapperVisitor(), null)).length() > 0) {
            this.addAnd(result).append(filterResult);
        }
        return result.toString();
    }

    private String getRelationshipAttributeEquals(AbstractAttribute leftAttr, AbstractAttribute rightAttr) {
        String toAppend = "";
        if (leftAttr.isArray()) {
            toAppend = toAppend + "Arrays.equals(_castedSrc" + this.getDataOrObject(leftAttr) + "." + leftAttr.getGetter() + "(), ";
            toAppend = toAppend + "_castedTargetData." + rightAttr.getGetter() + "())";
        } else {
            toAppend = toAppend + "_castedSrc" + this.getDataOrObject(leftAttr) + "." + leftAttr.getGetter() + "()";
            if (leftAttr.isPrimitive()) {
                toAppend = toAppend + " == ";
            } else {
                if (!leftAttr.isNullable()) {
                    toAppend = toAppend + "!= null && _castedSrc" + this.getDataOrObject(leftAttr) + "." + leftAttr.getGetter() + "()";
                }
                toAppend = toAppend + ".equals(";
            }
            toAppend = toAppend + "_castedTargetData." + rightAttr.getGetter() + "()";
            if (!leftAttr.isPrimitive()) {
                toAppend = toAppend + ")";
            }
        }
        return toAppend;
    }

    public String getHashCodeComputationForPk(boolean offHeap) {
        AbstractAttribute[] primaryKeyAttributes = this.right.getPrimaryKeyAttributes();
        return this.getHashCodeComputation(primaryKeyAttributes, offHeap);
    }

    public String getHashCodeComputation(AbstractAttribute[] uniqueAttributes, boolean offHeap) {
        HashMap<String, ASTRelationalExpression> rightToLeft = this.getRightToLeftAttributeToExpressionMap();
        String result = null;
        boolean sourceAdded = false;
        for (int i = 0; i < uniqueAttributes.length; ++i) {
            AbstractAttribute uniqueAttribute = uniqueAttributes[i];
            if (uniqueAttribute.isSourceAttribute()) {
                sourceAdded = true;
            }
            result = this.addHashCodeExpression(rightToLeft, result, uniqueAttribute, offHeap);
        }
        SourceAttribute sourceAttribute = this.right.getSourceAttribute();
        if (sourceAttribute != null && !sourceAdded) {
            result = this.addHashCodeExpression(rightToLeft, result, sourceAttribute, offHeap);
        }
        result = "return " + result + ";";
        return result;
    }

    public boolean hasDifferentOffHeapHashForPk() {
        return this.hasDifferentOffHeapHash(this.right.getPrimaryKeyAttributes());
    }

    public boolean hasDifferentOffHeapHash(AbstractAttribute[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].isStringAttribute()) continue;
            return true;
        }
        SourceAttribute sourceAttribute = this.right.getSourceAttribute();
        return sourceAttribute != null && sourceAttribute.isStringSourceAttribute();
    }

    private String getDataOrObject(AbstractAttribute attr) {
        String result = "Data";
        if (attr.isAsOfAttribute() || !attr.getOwner().hasData()) {
            result = "Object";
        }
        return result;
    }

    private String addHashCodeExpression(HashMap<String, ASTRelationalExpression> rightToLeft, String result, AbstractAttribute uniqueAttribute, boolean offHeap) {
        boolean combine = false;
        String hashMethod = "hash";
        if (uniqueAttribute.isStringAttribute() && offHeap) {
            hashMethod = "offHeapHash";
        }
        if (result != null) {
            combine = true;
            result = "HashUtil.combineHashes(" + result + ",HashUtil." + hashMethod + "(";
        } else {
            result = "HashUtil." + hashMethod + "(";
        }
        ASTRelationalExpression exp = rightToLeft.get(uniqueAttribute.getName());
        if (exp.isJoin()) {
            AbstractAttribute attribute = exp.getLeft().getAttribute();
            String getterMethod = attribute.getGetter();
            if (offHeap && attribute.isStringAttribute() && attribute.getOwner().hasOffHeap() && "Data".equals(this.getDataOrObject(attribute))) {
                getterMethod = "zGet" + StringUtility.firstLetterToUpper(attribute.getName()) + "AsInt";
            }
            result = result + "_castedSrc" + this.getDataOrObject(attribute) + ".";
            result = result + getterMethod + "()";
            if (attribute.isNullablePrimitive()) {
                result = result + ", _castedSrc" + this.getDataOrObject(attribute) + "." + attribute.getNullGetter();
            }
        } else {
            result = result + exp.getNonInLiteral(exp.getRight());
        }
        result = result + ")";
        if (combine) {
            result = result + ")";
        }
        return result;
    }

    private HashMap<String, ASTRelationalExpression> getRightToLeftAttributeToExpressionMap() {
        HashMap<String, ASTRelationalExpression> rightToLeft = new HashMap<String, ASTRelationalExpression>();
        for (int j = 0; j < this.joins.size(); ++j) {
            ASTRelationalExpression exp = this.joins.get(j);
            String rightName = ((ASTAttributeName)exp.getRight()).getAttribute().getName();
            rightToLeft.put(rightName, exp);
        }
        if (this.rightFilters != null) {
            this.rightFilters.jjtAccept(new PrimaryKeyMapperVisitor(rightToLeft), null);
        }
        return rightToLeft;
    }

    public String getCacheLookUpParameters() {
        String result = "";
        if (this.right.hasAsOfAttributes()) {
            AsOfAttribute[] asOfAttributes = this.right.getAsOfAttributes();
            for (int i = 0; i < asOfAttributes.length; ++i) {
                boolean found = false;
                result = result + ",";
                for (int j = 0; j < this.joins.size(); ++j) {
                    ASTRelationalExpression exp = this.joins.get(j);
                    String rightName = ((ASTAttributeName)exp.getRight()).getAttribute().getName();
                    if (!rightName.equals(asOfAttributes[i].getName())) continue;
                    AbstractAttribute left = exp.getLeft().getAttribute();
                    result = left.isAsOfAttribute() || left.getOwner().isReadOnly() ? result + "this." : result + "_data.";
                    result = result + left.getGetter() + "()";
                    found = true;
                }
                if (found) continue;
                ConstantFinderVisitor constantFinderVisitor = new ConstantFinderVisitor(asOfAttributes[i].getName());
                String toAppend = null;
                if (this.rightFilters != null) {
                    this.rightFilters.jjtAccept(constantFinderVisitor, null);
                    ASTRelationalExpression constant = constantFinderVisitor.getResult();
                    if (constant != null) {
                        ASTLiteral literal = (ASTLiteral)constant.getRight();
                        toAppend = literal.getValue();
                    }
                }
                if (toAppend == null && !asOfAttributes[i].getDefaultDateExpression().equals("null")) {
                    toAppend = asOfAttributes[i].getDefaultDateExpression();
                }
                if (toAppend == null) {
                    throw new RuntimeException("could not determine literal in " + this.rightFilters.getFinderString());
                }
                result = result + toAppend;
            }
            if (asOfAttributes.length == 1) {
                result = result + ", null";
            }
        } else {
            result = ", null, null";
        }
        return result;
    }

    public void addConstantSets() {
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            if (exp.isJoin()) continue;
            this.getConstantExpression(exp);
        }
        if (this.leftFilters != null) {
            this.addConstantSets(this.left.chooseForRelationshipAdd(this.right), this.leftFilters);
        }
        if (this.rightFilters != null) {
            this.addConstantSets(this.right.chooseForRelationshipAdd(this.left), this.rightFilters);
        }
    }

    private void addConstantSets(MithraObjectTypeWrapper objectTypeWrapper, SimpleNode filters) {
        ConstantSetAdderVisitor visitor = new ConstantSetAdderVisitor(objectTypeWrapper);
        filters.childrenPolymorphicAccept(visitor, null);
    }

    public boolean needsParameterOperationForPrimaryKey(String parameter) {
        List<String> parameterVariableList = Collections.singletonList(parameter);
        AbstractAttribute[] uniqueAttributes = this.right.getPrimaryKeyAttributes();
        return this.needsParameterListFromUniqueIndex(parameterVariableList, uniqueAttributes);
    }

    public boolean needsParametersOperationForPrimaryKey() {
        List<String> parameterVariableList = this.relationshipAttribute.getParameterVariableList();
        if (parameterVariableList == null || parameterVariableList.size() == 0) {
            return false;
        }
        AbstractAttribute[] uniqueAttributes = this.right.getPrimaryKeyAttributes();
        return this.needsParameterListFromUniqueIndex(parameterVariableList, uniqueAttributes);
    }

    private boolean needsParameterListFromUniqueIndex(List<String> parameterVariableList, AbstractAttribute[] uniqueAttributes) {
        SourceAttribute sourceAttribute;
        String literal;
        ASTRelationalExpression exp;
        boolean result = false;
        HashMap<String, ASTRelationalExpression> rightToLeft = this.getRightToLeftAttributeToExpressionMap();
        for (int i = 0; i < uniqueAttributes.length; ++i) {
            exp = rightToLeft.get(uniqueAttributes[i].getName());
            if (exp.isJoin() || !exp.isRightHandJavaLiteral() || !this.isParameterUsed(parameterVariableList, literal = ((ASTLiteral)exp.getRight()).getValue().trim())) continue;
            result = true;
            break;
        }
        if ((sourceAttribute = this.right.getSourceAttribute()) != null && !(exp = rightToLeft.get(sourceAttribute.getName())).isJoin() && exp.isRightHandJavaLiteral() && this.isParameterUsed(parameterVariableList, literal = ((ASTLiteral)exp.getRight()).getValue().trim())) {
            result = true;
        }
        return result;
    }

    private String findCorrespondingParameter(String literal) {
        if (literal == null) {
            return null;
        }
        return this.findCorrespondingParameter(this.relationshipAttribute.getParameterVariableList(), literal);
    }

    private String findCorrespondingParameter(List<String> parameterVariableList, String literal) {
        if (parameterVariableList == null) {
            return null;
        }
        int index = parameterVariableList.indexOf(literal);
        if (index >= 0) {
            return parameterVariableList.get(index);
        }
        StringTokenizer strTok = this.tokenizeParams(literal);
        while (strTok.hasMoreTokens()) {
            index = parameterVariableList.indexOf(strTok.nextToken());
            if (index < 0) continue;
            return parameterVariableList.get(index);
        }
        return null;
    }

    private boolean isParameterUsed(List<String> parameterVariableList, String literal) {
        if (literal == null) {
            return false;
        }
        return this.findCorrespondingParameter(parameterVariableList, literal) != null;
    }

    public boolean usesParameter(String parameterVariable) {
        List<String> literals = this.getFilterLiterals();
        if (literals.size() == 0) {
            return false;
        }
        if (literals.contains(parameterVariable)) {
            return true;
        }
        for (int i = 0; i < literals.size(); ++i) {
            String literal = literals.get(i);
            StringTokenizer strTok = this.tokenizeParams(literal);
            while (strTok.hasMoreTokens()) {
                if (!parameterVariable.equals(strTok.nextToken())) continue;
                return true;
            }
        }
        return false;
    }

    private StringTokenizer tokenizeParams(String literal) {
        return new StringTokenizer(literal, " .(),-=+*/[]:'\"&|!^%\n");
    }

    private List<String> getFilterLiterals() {
        if (this.filterLiterals == null) {
            LiteralCollectorVisitor collectorVisitor;
            this.filterLiterals = new ArrayList<String>();
            if (this.leftFilters != null) {
                collectorVisitor = new LiteralCollectorVisitor();
                this.leftFilters.jjtAccept(collectorVisitor, null);
                this.filterLiterals.addAll(collectorVisitor.getResult());
            }
            if (this.rightFilters != null) {
                collectorVisitor = new LiteralCollectorVisitor();
                this.rightFilters.jjtAccept(collectorVisitor, null);
                this.filterLiterals.addAll(collectorVisitor.getResult());
            }
        }
        return this.filterLiterals;
    }

    public boolean needsParameterOperationForUniqueIndex(String parameter) {
        List<String> parameterVariableList = Collections.singletonList(parameter);
        return this.needsParameterListFromUniqueIndex(parameterVariableList, this.getUniqueMatchingIndex().getAttributes());
    }

    public boolean needsParametersOperationForUniqueIndex() {
        List<String> parameterVariableList = this.relationshipAttribute.getParameterVariableList();
        if (parameterVariableList == null || parameterVariableList.size() == 0) {
            return false;
        }
        return this.needsParameterListFromUniqueIndex(parameterVariableList, this.getUniqueMatchingIndex().getAttributes());
    }

    public boolean needsDefaultAsOfDatesOperation() {
        if (this.right.hasAsOfAttributes()) {
            AsOfAttribute[] rightAsOfAttributes = this.right.getAsOfAttributes();
            for (int i = 0; i < rightAsOfAttributes.length; ++i) {
                String defaultDateExpression;
                if (!this.hasNoOperationForRightAttribute(rightAsOfAttributes[i]) || (defaultDateExpression = rightAsOfAttributes[i].getDefaultDateExpression()) == null || defaultDateExpression.equals("null")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMissingAsOfDatesOperationAndDefaults() {
        if (this.left.hasAsOfAttributes()) {
            AsOfAttribute[] rightAsOfAttributes = this.left.getAsOfAttributes();
            for (int i = 0; i < rightAsOfAttributes.length; ++i) {
                String defaultDateExpression;
                if (!this.hasNoOperationForLeftAttribute(rightAsOfAttributes[i]) || (defaultDateExpression = rightAsOfAttributes[i].getDefaultDateExpression()) != null && !defaultDateExpression.equals("null")) continue;
                return true;
            }
        }
        return false;
    }

    public String getDefaultAsOfDatesOperation() {
        String result = null;
        if (this.right.hasAsOfAttributes()) {
            AsOfAttribute[] rightAsOfAttributes = this.right.getAsOfAttributes();
            for (int i = 0; i < rightAsOfAttributes.length; ++i) {
                String defaultDateExpression;
                if (!this.hasNoOperationForRightAttribute(rightAsOfAttributes[i]) || (defaultDateExpression = rightAsOfAttributes[i].getDefaultDateExpression()) == null || defaultDateExpression.equals("null")) continue;
                String op = this.right.getFinderClassName() + "." + rightAsOfAttributes[i].getName() + "().eq(" + defaultDateExpression + ")";
                result = result == null ? op : result + ".and(" + op + ")";
            }
        }
        return result;
    }

    public boolean dependsOnFromAsOfAttributes() {
        if (this.left.hasAsOfAttributes()) {
            for (int i = 0; i < this.joins.size(); ++i) {
                ASTRelationalExpression exp = this.joins.get(i);
                AbstractAttribute leftAttr = exp.getLeft().getAttribute();
                if (!leftAttr.isAsOfAttribute()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean needsDirectRefExtractors() {
        HashMap<String, ASTRelationalExpression> rightToLeft = this.getRightToLeftAttributeToExpressionMap();
        for (ASTRelationalExpression exp : rightToLeft.values()) {
            AbstractAttribute attr = exp.isJoin() ? ((ASTAttributeName)exp.getRight()).getAttribute() : exp.getLeft().getAttribute();
            if (!this.needsDirectRefCheck(attr)) continue;
            return true;
        }
        return false;
    }

    private boolean needsDirectRefCheck(AbstractAttribute attr) {
        return !attr.isAsOfAttribute() && !attr.isPrimaryKey() && !attr.isSourceAttribute();
    }

    public String getFromDirectRefExtractors() {
        String result = "";
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            AbstractAttribute attr = ((ASTAttributeName)exp.getRight()).getAttribute();
            if (!this.needsDirectRefCheck(attr)) continue;
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + this.left.getFinderClassName() + "." + exp.getLeft().getAttribute().getName() + "()";
        }
        if (this.rightFilters != null) {
            ArrayList<ASTRelationalExpression> rightExpressions = new ArrayList<ASTRelationalExpression>();
            this.rightFilters.jjtAccept(new RightAttributeMapperVisitor(rightExpressions), null);
            for (int i = 0; i < rightExpressions.size(); ++i) {
                ASTRelationalExpression exp = (ASTRelationalExpression)rightExpressions.get(i);
                AbstractAttribute attr = exp.getLeft().getAttribute();
                if (!this.needsDirectRefCheck(attr)) continue;
                if (result.length() > 0) {
                    result = result + ", ";
                }
                result = result + "((OperationWithParameterExtractor)" + this.getConstantExpression(exp) + ").getParameterExtractor()";
            }
        }
        return result;
    }

    private String getConstantExpression(ASTRelationalExpression exp) {
        return exp.getConstantExpression(this.left.chooseForRelationshipAdd(this.right));
    }

    public String getToDirectRefExtractors() {
        String result = "";
        for (int i = 0; i < this.joins.size(); ++i) {
            ASTRelationalExpression exp = this.joins.get(i);
            AbstractAttribute attr = ((ASTAttributeName)exp.getRight()).getAttribute();
            if (!this.needsDirectRefCheck(attr)) continue;
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + this.right.getFinderClassName() + "." + attr.getName() + "()";
        }
        if (this.rightFilters != null) {
            ArrayList<ASTRelationalExpression> rightExpressions = new ArrayList<ASTRelationalExpression>();
            this.rightFilters.jjtAccept(new RightAttributeMapperVisitor(rightExpressions), null);
            for (int i = 0; i < rightExpressions.size(); ++i) {
                ASTRelationalExpression exp = (ASTRelationalExpression)rightExpressions.get(i);
                AbstractAttribute attr = exp.getLeft().getAttribute();
                if (!this.needsDirectRefCheck(attr)) continue;
                if (result.length() > 0) {
                    result = result + ", ";
                }
                result = result + this.right.getFinderClassName() + "." + attr.getName() + "()";
            }
        }
        return result;
    }

    public Join getReverseJoin() {
        Join result = new Join(this.right, this.left, false, this.relationshipAttribute);
        result.rightFilters = this.leftFilters;
        result.leftFilters = this.rightFilters;
        for (int i = 0; i < this.joins.size(); ++i) {
            result.joins.add(this.getReverseJoin(this.joins.get(i)));
        }
        return result;
    }

    public boolean hasRightFilters() {
        return this.rightFilters != null;
    }

    public String constructOperationFromRight(boolean hasDangleMapper) {
        if (this.isExtractorBasedMultiEquality(hasDangleMapper)) {
            return this.constructOperationFromRightForExtractorBased();
        }
        return this.constructPlainOperationFromRight();
    }

    private String constructPlainOperationFromRight() {
        String result = this.constructOperation(this.joins.get(0));
        for (int i = 1; i < this.joins.size(); ++i) {
            result = result + ".and(" + this.constructOperation(this.joins.get(i)) + ")";
        }
        if (this.leftFilters != null) {
            result = result + ".and(" + this.constructFilters(this.leftFilters) + ")";
        }
        return result;
    }

    private String constructOperationFromRightForExtractorBased() {
        return "new RelationshipMultiEqualityOperation(" + this.relationshipAttribute.getFromObject().getFinderClassName() + "." + this.relationshipAttribute.getName() + "().zGetRelationshipMultiExtractor(), this)";
    }

    private String constructOperation(ASTRelationalExpression exp) {
        AbstractAttribute leftAttr = exp.getLeft().getAttribute();
        String result = leftAttr.getOwner().getFinderClassName() + "." + leftAttr.getName() + "().eq(";
        AbstractAttribute rightAttr = ((ASTAttributeName)exp.getRight()).getAttribute();
        result = rightAttr.isAsOfAttribute() ? result + "this." : result + "_data.";
        result = result + rightAttr.getGetter() + "()";
        result = result + ")";
        return result;
    }

    public boolean isExtractorBasedMultiEquality(boolean hasDangleMapper) {
        if (hasDangleMapper || this.relationshipAttribute.hasParameters() || !this.relationshipAttribute.dependsOnlyOnFromToObjects() || this.isMissingAsOfDatesOperationAndDefaults()) {
            return false;
        }
        int expressionSize = this.joins.size();
        if (this.leftFilters != null) {
            int filters = this.countEqualityFilters(this.leftFilters);
            if (filters < 0) {
                return false;
            }
            expressionSize += filters;
        }
        return expressionSize > 1;
    }

    public String getRelationshipMultiExtractorConstructor() {
        ASTRelationalExpression exp;
        int i;
        List<ASTRelationalExpression> sortedJoins = this.getIndexOrderedJoins(this.relationshipAttribute.getRelatedObject().getPkAndAllIndices());
        String result = "RelationshipMultiExtractor.withLeftAttributes(\n";
        for (i = 0; i < sortedJoins.size(); ++i) {
            if (i > 0) {
                result = result + ",\n";
            }
            exp = sortedJoins.get(i);
            ASTAttributeName attribute = exp.getLeft();
            result = result + attribute.getAttribute().getOwner().getFinderClassName() + "." + attribute.getAttribute().getName() + "()";
        }
        result = result + ").withExtractors(\n";
        for (i = 0; i < sortedJoins.size(); ++i) {
            if (i > 0) {
                result = result + ",\n";
            }
            if ((exp = sortedJoins.get(i)).isJoin()) {
                AbstractAttribute joinAttr = ((ASTAttributeName)exp.getRight()).getAttribute();
                result = result + joinAttr.getOwner().getFinderClassName() + "." + joinAttr.getName() + "()";
                continue;
            }
            result = result + "((OperationWithParameterExtractor)";
            result = result + this.createConstantOperation(exp);
            result = result + ").getParameterExtractor()";
        }
        result = result + ")";
        return result;
    }

    private List<ASTRelationalExpression> getIndexOrderedJoins(List<Index> indices) {
        Object attribute;
        boolean found;
        ArrayList<ASTRelationalExpression> sortedJoins = new ArrayList<ASTRelationalExpression>(this.joins);
        if (this.leftFilters != null) {
            EqualityAndFilterVisitor visitor = new EqualityAndFilterVisitor();
            this.leftFilters.jjtAccept(visitor, null);
            sortedJoins.addAll(visitor.getResult());
        }
        AsOfAttribute[] asOfAttributes = this.relationshipAttribute.getRelatedObject().getAsOfAttributes();
        ArrayList<ASTRelationalExpression> sortedAsOfAttributeJoins = new ArrayList<ASTRelationalExpression>();
        if (asOfAttributes.length > 0) {
            for (AsOfAttribute asOfAttribute : asOfAttributes) {
                found = false;
                for (int i = 0; i < sortedJoins.size(); ++i) {
                    ASTRelationalExpression exp = (ASTRelationalExpression)sortedJoins.get(i);
                    attribute = exp.getLeft().getAttribute();
                    if (!((AbstractAttribute)attribute).equals(asOfAttribute)) continue;
                    sortedJoins.remove(i);
                    sortedAsOfAttributeJoins.add(exp);
                    --i;
                    found = true;
                }
                if (found) continue;
                ASTRelationalExpression exp = new ASTRelationalExpression((AbstractAttribute)asOfAttribute, new ASTLiteral(asOfAttribute.getDefaultDateExpression()), false);
                sortedAsOfAttributeJoins.add(exp);
            }
        }
        for (Index index : indices) {
            AbstractAttribute[] indexAttributes = index.getAttributes();
            if (indexAttributes.length != sortedJoins.size()) continue;
            HashSet<String> indexAttributeNames = new HashSet<String>();
            for (AbstractAttribute attr : index.getAttributes()) {
                indexAttributeNames.add(attr.getName());
            }
            found = true;
            for (ASTRelationalExpression exp : sortedJoins) {
                attribute = exp.getLeft();
                if (indexAttributeNames.contains(((ASTAttributeName)attribute).getAttribute().getName())) continue;
                found = false;
                break;
            }
            if (!found) continue;
            Collections.sort(sortedJoins, new ByAttributeOrderComparator(index.getAttributes()));
            break;
        }
        sortedJoins.addAll(sortedAsOfAttributeJoins);
        return sortedJoins;
    }

    public boolean requiresOverSpecifiedParameterCheck() {
        if (this.rightFilters != null) {
            String overSpecificationCheck = this.getOverSpecificationCheck();
            return overSpecificationCheck != null && !overSpecificationCheck.trim().isEmpty();
        }
        return false;
    }

    public String getOverSpecificationCheck() {
        RightFilterOverSpecificationVisitor filters = new RightFilterOverSpecificationVisitor();
        String result = (String)this.rightFilters.jjtAccept(filters, null);
        return filters.dependsOnParameter ? result : null;
    }

    public String getFindByUniqueLookupParameters() {
        List<ASTRelationalExpression> sortedJoins = this.getIndexOrderedJoins(this.relationshipAttribute.getRelatedObject().getPkAndUniqueIndices());
        String result = "";
        for (int i = 0; i < sortedJoins.size(); ++i) {
            ASTRelationalExpression exp;
            if (i > 0) {
                result = result + ",\n";
            }
            if ((exp = sortedJoins.get(i)).isJoin()) {
                AbstractAttribute right = ((ASTAttributeName)exp.getRight()).getAttribute();
                result = right.isAsOfAttribute() || right.getOwner().isReadOnly() ? result + "this." : result + "_data.";
                result = result + right.getGetter() + "()";
                continue;
            }
            MithraObjectTypeWrapper expressionHolder = this.left.chooseForRelationshipAdd(this.right);
            result = result + exp.getLiteralRightHand(expressionHolder);
        }
        return result;
    }

    private String createConstantOperation(ASTRelationalExpression node) {
        String result;
        MithraObjectTypeWrapper owner = node.getLeft().getOwner();
        int index = owner.getConstantOperationIndexFromPool(node);
        if (index >= 0) {
            result = owner.getFinderClassName() + ".zGetConstantOperation(" + index + ")";
        } else {
            MithraObjectTypeWrapper expressionHolder = this.left.chooseForRelationshipAdd(this.right);
            result = node.getConstantExpression(owner.chooseForRelationshipAdd(expressionHolder));
        }
        return result;
    }

    private StringBuilder addAnd(StringBuilder result) {
        if (result.length() > 0) {
            result.append(" && ");
        }
        return result;
    }

    private StringBuilder addOr(StringBuilder result) {
        if (result.length() > 0) {
            result.append(" || ");
        }
        return result;
    }

    private static class ConstantFinderVisitor
    extends MithraQLVisitorAdapter {
        private String attributeToFind;
        private ASTRelationalExpression result;

        public ConstantFinderVisitor(String attributeToFind) {
            this.attributeToFind = attributeToFind;
        }

        @Override
        public Object visit(ASTAndExpression node, Object data) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                node.jjtGetChild(i).jjtAccept(this, data);
            }
            return data;
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            if (node.getLeft().getAttribute().getName().equals(this.attributeToFind)) {
                this.result = node;
            }
            return data;
        }

        public ASTRelationalExpression getResult() {
            return this.result;
        }
    }

    private static class ByPrimaryKeyVisitor
    extends FilterIndexVisitor {
        private ByPrimaryKeyVisitor() {
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            if (!this.hasOr) {
                if (node.getOperator().isEqual() || node.getOperator().isEqualsEdgePoint()) {
                    this.attributes.add(node.getLeft().getAttribute());
                } else {
                    this.hasOr = true;
                    this.attributes.clear();
                }
            }
            return data;
        }
    }

    private static class FilterIndexVisitor
    extends MithraQLVisitorAdapter {
        protected ArrayList attributes = new ArrayList();
        protected boolean hasOr = false;

        private FilterIndexVisitor() {
        }

        @Override
        public Object visit(ASTOrExpression node, Object data) {
            this.hasOr = true;
            this.attributes.clear();
            return data;
        }

        @Override
        public Object visit(ASTAndExpression node, Object data) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                node.jjtGetChild(i).jjtAccept(this, data);
            }
            return data;
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            if (!this.hasOr) {
                if (node.getOperator().isIn() || node.getOperator().isEqual() || node.getOperator().isEqualsEdgePoint()) {
                    this.attributes.add(node.getLeft().getAttribute());
                } else {
                    this.hasOr = true;
                    this.attributes.clear();
                }
            }
            return data;
        }

        public ArrayList getAttributes() {
            return this.attributes;
        }
    }

    private static class RightAttributeMapperVisitor
    extends MithraQLVisitorAdapter {
        private List<ASTRelationalExpression> list;

        public RightAttributeMapperVisitor(List<ASTRelationalExpression> list) {
            this.list = list;
        }

        @Override
        public Object visit(ASTAndExpression node, Object data) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                node.jjtGetChild(i).jjtAccept(this, data);
            }
            return data;
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            this.list.add(node);
            return data;
        }
    }

    private class RightFilterOverSpecificationVisitor
    extends MithraQLVisitorAdapter {
        private boolean dependsOnParameter = false;

        private RightFilterOverSpecificationVisitor() {
        }

        @Override
        public Object visit(ASTAndExpression node, Object data) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                String localResult = (String)node.jjtGetChild(i).jjtAccept(this, data);
                if (localResult.length() <= 0) continue;
                Join.this.addAnd(result).append(localResult);
            }
            return result.length() == 0 ? "" : "(" + result + ")";
        }

        @Override
        public Object visit(ASTOrExpression node, Object data) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                String localResult = (String)node.jjtGetChild(i).jjtAccept(this, data);
                if (localResult.length() <= 0) continue;
                Join.this.addOr(result).append(localResult);
            }
            return result.length() == 0 ? "" : "(" + result + ")";
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            StringBuilder result = new StringBuilder();
            AbstractAttribute rightAttr = node.getLeft().getAttribute();
            if (!rightAttr.isAsOfAttribute()) {
                Operator op = node.getOperator();
                if (!op.isIsNullOrIsNotNull()) {
                    String right = op.isUnary() ? null : node.getLiteralRightHand(Join.this.left.chooseForRelationshipAdd(Join.this.right));
                    String correspondingParameter = Join.this.findCorrespondingParameter(right);
                    if (!(correspondingParameter == null || Join.this.isByPrimaryKey() && Join.this.needsParameterOperationForPrimaryKey(correspondingParameter) || Join.this.getUniqueMatchingIndex() != null && Join.this.needsParameterOperationForUniqueIndex(correspondingParameter))) {
                        this.dependsOnParameter = true;
                    }
                    result.append("((");
                    if (rightAttr.isNullable()) {
                        result.append("!_result.").append(rightAttr.getNullGetter());
                        Join.this.addAnd(result);
                    }
                    String left = "_result." + rightAttr.getGetter() + "()";
                    if (rightAttr.isPrimitive()) {
                        result.append(op.getPrimitiveExpression(left, right));
                    } else {
                        result.append(op.getNonPrimitiveExpression(left, right));
                    }
                    result.append(')');
                    if (Join.this.isParameterUsed(Join.this.relationshipAttribute.getParameterVariableList(), right) && rightAttr.isNullable() && !rightAttr.isPrimitive()) {
                        Join.this.addOr(result);
                        result.append("(_result.").append(rightAttr.getNullGetter());
                        Join.this.addAnd(result);
                        result.append(right).append(" == null");
                        result.append(')');
                    }
                    result.append(')');
                } else {
                    if (op.isIsNotNull()) {
                        result.append("!");
                    }
                    result.append("_result.").append(rightAttr.getNullGetter());
                }
            }
            return result.toString();
        }
    }

    private class RightFilterEqualityMapperVisitor
    extends MithraQLVisitorAdapter {
        private RightFilterEqualityMapperVisitor() {
        }

        @Override
        public Object visit(ASTAndExpression node, Object data) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                String localResult = (String)node.jjtGetChild(i).jjtAccept(this, data);
                if (localResult.length() <= 0) continue;
                Join.this.addAnd(result).append(localResult);
            }
            return result.length() == 0 ? "" : "(" + result + ")";
        }

        @Override
        public Object visit(ASTOrExpression node, Object data) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                String localResult = (String)node.jjtGetChild(i).jjtAccept(this, data);
                if (localResult.length() <= 0) {
                    result.setLength(0);
                    break;
                }
                Join.this.addOr(result).append(localResult);
            }
            return result.length() == 0 ? "" : "(" + result + ")";
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            StringBuilder result = new StringBuilder();
            AbstractAttribute rightAttr = node.getLeft().getAttribute();
            if (!rightAttr.isAsOfAttribute()) {
                Operator op = node.getOperator();
                if (op.isIsNullOrIsNotNull()) {
                    Join.this.addAnd(result);
                    if (op.isIsNotNull()) {
                        result.append("!");
                    }
                    result.append("_castedTargetData.").append(rightAttr.getNullGetter());
                } else {
                    String right = op.isUnary() ? null : node.getLiteralRightHand(Join.this.left.chooseForRelationshipAdd(Join.this.right));
                    String correspondingParameter = Join.this.findCorrespondingParameter(right);
                    if (correspondingParameter == null || Join.this.isByPrimaryKey() && Join.this.needsParameterOperationForPrimaryKey(correspondingParameter) || Join.this.getUniqueMatchingIndex() != null && Join.this.needsParameterOperationForUniqueIndex(correspondingParameter)) {
                        Join.this.addAnd(result);
                        result.append("((");
                        if (rightAttr.isNullable()) {
                            result.append("!_castedTargetData.").append(rightAttr.getNullGetter());
                            Join.this.addAnd(result);
                        }
                        String left = "_castedTargetData." + rightAttr.getGetter() + "()";
                        if (rightAttr.isPrimitive()) {
                            result.append(op.getPrimitiveExpression(left, right));
                        } else {
                            result.append(op.getNonPrimitiveExpression(left, right));
                        }
                        result.append(')');
                        if (Join.this.isParameterUsed(Join.this.relationshipAttribute.getParameterVariableList(), right) && rightAttr.isNullable() && !rightAttr.isPrimitive()) {
                            Join.this.addOr(result);
                            result.append("(_castedTargetData.").append(rightAttr.getNullGetter());
                            Join.this.addAnd(result);
                            result.append(right).append(" == null");
                            result.append(')');
                        }
                        result.append(')');
                    }
                }
            }
            return result.toString();
        }
    }

    private static class PrimaryKeyMapperVisitor
    extends MithraQLVisitorAdapter {
        protected ArrayList attributes = new ArrayList();
        private Map<String, ASTRelationalExpression> map;

        public PrimaryKeyMapperVisitor(Map<String, ASTRelationalExpression> map) {
            this.map = map;
        }

        @Override
        public Object visit(ASTAndExpression node, Object data) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                node.jjtGetChild(i).jjtAccept(this, data);
            }
            return data;
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            this.map.put(node.getLeft().getAttribute().getName(), node);
            return data;
        }

        public ArrayList getAttributes() {
            return this.attributes;
        }
    }

    private static class LiteralCollectorVisitor
    extends MithraQLVisitorAdapter {
        private List<String> result = new ArrayList<String>();

        private LiteralCollectorVisitor() {
        }

        @Override
        public Object visit(ASTOrExpression node, Object data) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                node.jjtGetChild(i).jjtAccept(this, data);
            }
            return data;
        }

        @Override
        public Object visit(ASTAndExpression node, Object data) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                node.jjtGetChild(i).jjtAccept(this, data);
            }
            return data;
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                node.jjtGetChild(i).jjtAccept(this, data);
            }
            return data;
        }

        @Override
        public Object visit(ASTInLiteral node, Object data) {
            this.result.add(node.getValue());
            return data;
        }

        @Override
        public Object visit(ASTLiteral node, Object data) {
            this.result.add(node.getValue());
            return data;
        }

        public List<String> getResult() {
            return this.result;
        }
    }

    private class EqualityAndFilterVisitor
    extends MithraQLVisitorAdapter {
        private List<ASTRelationalExpression> result = new ArrayList<ASTRelationalExpression>();

        private EqualityAndFilterVisitor() {
        }

        @Override
        public Object visit(ASTAndExpression node, Object data) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                node.jjtGetChild(i).jjtAccept(this, data);
            }
            return data;
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            this.result.add(node);
            return data;
        }

        public List<ASTRelationalExpression> getResult() {
            return this.result;
        }
    }

    private class EqualityFilterCountVisitor
    extends MithraQLVisitorAdapter {
        int result = 0;

        private EqualityFilterCountVisitor() {
        }

        @Override
        public Object visit(ASTOrExpression node, Object data) {
            this.result = -1;
            return data;
        }

        @Override
        public Object visit(ASTAndExpression node, Object data) {
            if (this.result >= 0) {
                for (int i = 0; i < node.jjtGetNumChildren() && this.result >= 0; ++i) {
                    node.jjtGetChild(i).jjtAccept(this, data);
                }
            }
            return data;
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            if (this.result < 0) {
                return data;
            }
            if (!node.getOperator().isEqual()) {
                this.result = -1;
                return data;
            }
            ++this.result;
            return data;
        }

        public int getResult() {
            return this.result;
        }
    }

    private class FilterVisitor
    extends MithraQLVisitorAdapter {
        String result = "";

        private FilterVisitor() {
        }

        @Override
        public Object visit(ASTOrExpression node, Object data) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                node.jjtGetChild(i).jjtAccept(this, data);
                if (i > 0) {
                    this.result = this.result + ")";
                }
                if (i >= node.jjtGetNumChildren() - 1) continue;
                this.result = this.result + ".or(";
            }
            return data;
        }

        @Override
        public Object visit(ASTAndExpression node, Object data) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                node.jjtGetChild(i).jjtAccept(this, data);
                if (i > 0) {
                    this.result = this.result + ")";
                }
                if (i >= node.jjtGetNumChildren() - 1) continue;
                this.result = this.result + ".and(";
            }
            return data;
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            this.result = this.result + Join.this.createConstantOperation(node);
            return data;
        }

        public String getResult() {
            return this.result;
        }
    }

    private static class HasAttributeVisitor
    extends MithraQLVisitorAdapter {
        private boolean found = false;
        private AbstractAttribute attr;

        public HasAttributeVisitor(AbstractAttribute attr) {
            this.attr = attr;
        }

        public boolean isFound() {
            return this.found;
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            if (node.getLeft().getAttribute().getName().equals(this.attr.getName())) {
                this.found = true;
            }
            return data;
        }
    }

    private static class ConstantPoolAdderVisitor
    extends MithraQLVisitorAdapter {
        private MithraObjectTypeWrapper wrapper;

        public ConstantPoolAdderVisitor(MithraObjectTypeWrapper wrapper) {
            this.wrapper = wrapper;
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            this.wrapper.addConstantOperationToPool(node);
            return data;
        }
    }

    private static class ConstantSetAdderVisitor
    extends MithraQLVisitorAdapter {
        private MithraObjectTypeWrapper wrapper;

        public ConstantSetAdderVisitor(MithraObjectTypeWrapper wrapper) {
            this.wrapper = wrapper;
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            if (!node.isJoin()) {
                node.getConstantExpression(this.wrapper);
            }
            return data;
        }
    }

    private static class ByAttributeOrderComparator
    implements Comparator<ASTRelationalExpression> {
        private Map<String, Integer> orderMap = new HashMap<String, Integer>();

        public ByAttributeOrderComparator(AbstractAttribute[] attributes) {
            for (int i = 0; i < attributes.length; ++i) {
                this.orderMap.put(attributes[i].getName(), i);
            }
        }

        @Override
        public int compare(ASTRelationalExpression first, ASTRelationalExpression second) {
            return this.orderMap.get(first.getLeft().getAttribute().getName()) - this.orderMap.get(second.getLeft().getAttribute().getName());
        }
    }
}

