/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.mapper;

import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.RelationshipAttribute;
import com.gs.fw.common.mithra.generator.mapper.Join;
import com.gs.fw.common.mithra.generator.mapper.QueryConverter;
import com.gs.fw.common.mithra.generator.queryparser.ASTOrExpression;
import com.gs.fw.common.mithra.generator.queryparser.ASTRelationalExpression;
import com.gs.fw.common.mithra.generator.util.StringUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JoinNode {
    private MithraObjectTypeWrapper left;
    private Join parentJoin;
    private List<JoinNode> furtherJoins = new ArrayList<JoinNode>(2);
    private boolean isJoinedToThis;
    private boolean isEndNode;

    public JoinNode(MithraObjectTypeWrapper left, boolean joinedToThis) {
        this.left = left;
        this.isJoinedToThis = joinedToThis;
    }

    public JoinNode(MithraObjectTypeWrapper left, boolean joinedToThis, Join parentJoin) {
        this.left = left;
        this.isJoinedToThis = joinedToThis;
        this.parentJoin = parentJoin;
    }

    public boolean isJoinedToThis() {
        return this.isJoinedToThis;
    }

    public JoinNode addRight(MithraObjectTypeWrapper right, RelationshipAttribute relationshipAttribute) {
        JoinNode result = new JoinNode(right, false, new Join(this.left, right, this.isJoinedToThis, relationshipAttribute));
        this.furtherJoins.add(result);
        return result;
    }

    public List<JoinNode> getFurtherJoins() {
        return this.furtherJoins;
    }

    public MithraObjectTypeWrapper getLeft() {
        return this.left;
    }

    public void addJoin(JoinNode current) {
        this.furtherJoins.add(current);
    }

    public Join getParentJoin() {
        return this.parentJoin;
    }

    public void reorder(MithraObjectTypeWrapper last) {
        JoinNode child;
        int i;
        this.determineEndNode(last);
        for (i = 0; i < this.furtherJoins.size(); ++i) {
            child = this.furtherJoins.get(i);
            child.reorder(last);
        }
        if (this.furtherJoins.size() < 2) {
            return;
        }
        for (i = 0; i < this.furtherJoins.size(); ++i) {
            child = this.furtherJoins.get(i);
            if (!child.terminatesIn(last)) continue;
            JoinNode first = this.furtherJoins.get(0);
            this.furtherJoins.set(0, child);
            this.furtherJoins.set(i, first);
            return;
        }
    }

    private void determineEndNode(MithraObjectTypeWrapper last) {
        if (this.isJoinedToThis) {
            return;
        }
        if (this.left.getClassName().equals(last.getClassName())) {
            this.isEndNode = true;
        }
        if (this.furtherJoins.size() == 0) {
            this.isEndNode = true;
        }
    }

    private boolean terminatesIn(MithraObjectTypeWrapper last) {
        if (this.left.getClassName().equals(last.getClassName())) {
            return true;
        }
        for (int i = 0; i < this.furtherJoins.size(); ++i) {
            JoinNode child = this.furtherJoins.get(i);
            if (!child.terminatesIn(last)) continue;
            return true;
        }
        return false;
    }

    public void addIndices() {
        if (this.parentJoin != null) {
            this.parentJoin.addIndices();
        }
        for (int i = 0; i < this.furtherJoins.size(); ++i) {
            this.furtherJoins.get(i).addIndices();
        }
    }

    public void addConstantSets() {
        if (this.parentJoin != null) {
            this.parentJoin.addConstantSets();
        }
        for (int i = 0; i < this.furtherJoins.size(); ++i) {
            this.furtherJoins.get(i).addConstantSets();
        }
    }

    public void addJoinsToConstantPool() {
        if (this.parentJoin != null) {
            this.parentJoin.addJoinsToConstantPool();
        }
        for (int i = 0; i < this.furtherJoins.size(); ++i) {
            this.furtherJoins.get(i).addJoinsToConstantPool();
        }
    }

    public void addOperationsToConstantPool() {
        if (this.parentJoin != null) {
            this.parentJoin.addOperationsToConstantPool();
        }
        for (int i = 0; i < this.furtherJoins.size(); ++i) {
            this.furtherJoins.get(i).addOperationsToConstantPool();
        }
    }

    public void autoAddSourceAndAsOfAttributeJoins() {
        if (this.parentJoin != null) {
            this.parentJoin.autoAddSourceAndAsOfAttributeJoins();
        }
        for (int i = 0; i < this.furtherJoins.size(); ++i) {
            this.furtherJoins.get(i).autoAddSourceAndAsOfAttributeJoins();
        }
    }

    public boolean addJoinExpression(ASTRelationalExpression node) {
        if (this.parentJoin != null && this.parentJoin.addJoin(node)) {
            return true;
        }
        for (int i = 0; i < this.furtherJoins.size(); ++i) {
            if (!this.furtherJoins.get(i).addJoinExpression(node)) continue;
            return true;
        }
        return false;
    }

    public boolean addConstraintExpression(ASTRelationalExpression node) {
        if (this.parentJoin != null && this.parentJoin.addConstraint(node)) {
            return true;
        }
        for (int i = 0; i < this.furtherJoins.size(); ++i) {
            if (!this.furtherJoins.get(i).addConstraintExpression(node)) continue;
            return true;
        }
        return false;
    }

    public boolean addOrConstraintExpression(MithraObjectTypeWrapper constrainedClass, ASTOrExpression node, boolean belongsToThis) {
        if (this.parentJoin != null && this.parentJoin.addOrConstraint(constrainedClass, node, belongsToThis)) {
            return true;
        }
        for (int i = 0; i < this.furtherJoins.size(); ++i) {
            if (!this.furtherJoins.get(i).addOrConstraintExpression(constrainedClass, node, belongsToThis)) continue;
            return true;
        }
        return false;
    }

    private String buildMappedOperationForBranch(int start, String variable) {
        String result = "";
        for (int i = start; i < this.furtherJoins.size(); ++i) {
            if (i > start) {
                result = result + ".and(";
            }
            result = result + "new MappedOperation(" + variable + "b" + i + "Mapper, ";
            result = result + "new All(" + variable + "b" + i + "Mapper.getAnyRightAttribute()))";
            if (i <= start) continue;
            result = result + ")";
        }
        return result;
    }

    public String constructReverseMapperCommon(String variableName, boolean pure, String name) {
        String variable = StringUtility.firstLetterToLower(variableName);
        StringBuilder builder = new StringBuilder();
        this.constructReverseMapper(variable, pure, builder);
        if (name != null) {
            builder.append(variable).append("Mapper.setName(\"").append(name).append("\");\n");
            return builder.append("return ").append(variable).append("Mapper;").toString();
        }
        String assignment = "Mapper " + variable + "Mapper =";
        int start = builder.lastIndexOf(assignment);
        builder.replace(start, start + assignment.length(), "return");
        return builder.toString();
    }

    private void constructReverseMapper(String variable, boolean pure, StringBuilder builder) {
        if (this.isEndNode) {
            if (this.furtherJoins.size() == 0) {
                builder.append(pure ? this.parentJoin.constructPureMapper(variable + "Mapper") : this.parentJoin.constructMapper(variable + "Mapper")).append('\n');
            } else {
                builder.append(pure ? this.parentJoin.constructPureMapper(variable + "pMapper") : this.parentJoin.constructMapper(variable + "pMapper")).append('\n');
                for (int i = 0; i < this.furtherJoins.size(); ++i) {
                    this.furtherJoins.get(i).constructReverseMapper(variable + 'b' + i, pure, builder);
                }
                builder.append("Mapper ").append(variable).append("Mapper = ");
                builder.append("new FilteredMapper(").append(variable).append("pMapper, null, ");
                builder.append(this.buildMappedOperationForBranch(0, variable)).append(");\n");
            }
        } else if (this.parentJoin == null) {
            if (this.furtherJoins.size() == 1) {
                this.furtherJoins.get(0).constructReverseMapper(variable, pure, builder);
            } else {
                for (int i = 0; i < this.furtherJoins.size(); ++i) {
                    this.furtherJoins.get(i).constructReverseMapper(variable + 'b' + i, pure, builder);
                }
                builder.append("Mapper ").append(variable).append("Mapper = ");
                builder.append("new FilteredMapper(").append(variable).append("b0Mapper, ");
                builder.append(this.buildMappedOperationForBranch(1, variable)).append(", null);\n");
            }
        } else {
            builder.append(pure ? this.parentJoin.constructPureMapper(variable + "c0Mapper") : this.parentJoin.constructMapper(variable + "c0Mapper")).append('\n');
            if (this.furtherJoins.size() == 1) {
                this.furtherJoins.get(0).constructReverseMapper(variable + "c1", pure, builder);
            } else {
                for (int i = 0; i < this.furtherJoins.size(); ++i) {
                    this.furtherJoins.get(i).constructReverseMapper(variable + 'b' + i, pure, builder);
                }
                builder.append("Mapper ").append(variable).append("c1Mapper = ");
                builder.append("new FilteredMapper(").append(variable).append("b0Mapper, ");
                builder.append(this.buildMappedOperationForBranch(1, variable)).append(", null);\n");
            }
            builder.append("Mapper ").append(variable).append("Mapper = ").append("new ChainedMapper(");
            builder.append(variable).append("c0Mapper").append(',').append(variable).append("c1Mapper");
            builder.append(");\n");
        }
    }

    public JoinNode invert() {
        ArrayList<JoinNode> toInvert = new ArrayList<JoinNode>();
        JoinNode cur = this;
        while (!cur.isEndNode) {
            toInvert.add(cur);
            cur = cur.getFurtherJoins().get(0);
        }
        JoinNode inverted = new JoinNode(cur.left, true);
        inverted.furtherJoins.addAll(cur.furtherJoins);
        JoinNode curInverted = inverted;
        for (int i = toInvert.size() - 1; i >= 0; --i) {
            JoinNode nextToInvert = (JoinNode)toInvert.get(i);
            JoinNode nextInverted = new JoinNode(nextToInvert.left, false);
            if (nextToInvert.furtherJoins.size() > 1) {
                nextInverted.furtherJoins.addAll(nextToInvert.furtherJoins.subList(1, nextToInvert.furtherJoins.size()));
            }
            nextInverted.parentJoin = cur.parentJoin.getReverseJoin();
            curInverted.furtherJoins.add(0, nextInverted);
            curInverted = nextInverted;
            cur = nextToInvert;
        }
        curInverted.isEndNode = true;
        return inverted;
    }

    public List getMainJoins() {
        ArrayList<Join> result = new ArrayList<Join>();
        JoinNode node = this.furtherJoins.get(0);
        while (!node.isEndNode) {
            result.add(node.parentJoin);
            node = node.furtherJoins.get(0);
        }
        result.add(node.parentJoin);
        result.remove(0);
        return result;
    }

    public QueryConverter createQueryConverter(RelationshipAttribute relationshipAttribute) {
        List<JoinNode> originalFurtherJoins;
        JoinNode result = new JoinNode(this.left, true);
        JoinNode original = this;
        JoinNode converted = result;
        while (!original.getFurtherJoins().get((int)0).isEndNode) {
            originalFurtherJoins = original.getFurtherJoins();
            JoinNode nextOriginal = originalFurtherJoins.get(0);
            JoinNode nextConverted = new JoinNode(nextOriginal.left, false, nextOriginal.parentJoin);
            converted.furtherJoins.add(nextConverted);
            if (originalFurtherJoins.size() > 1) {
                converted.furtherJoins.addAll(originalFurtherJoins.subList(1, originalFurtherJoins.size()));
            }
            converted = nextConverted;
            original = nextOriginal;
        }
        converted.isEndNode = true;
        originalFurtherJoins = original.getFurtherJoins();
        List<JoinNode> danglingNodeAtEnd = Collections.emptyList();
        if (originalFurtherJoins.size() > 1) {
            danglingNodeAtEnd = originalFurtherJoins.subList(1, originalFurtherJoins.size());
        }
        return new QueryConverter(relationshipAttribute, originalFurtherJoins.get(0), result, danglingNodeAtEnd);
    }

    public boolean isEndNode() {
        return this.isEndNode;
    }

    public String getUsedParameterVariables(RelationshipAttribute attr) {
        int count = attr.getParameterCount();
        String result = "";
        block0: for (int i = 0; i < count; ++i) {
            String param = attr.getParameterVariableAt(i);
            if (this.parentJoin != null && this.parentJoin.usesParameter(param)) {
                if (result.length() > 0) {
                    result = result + ", ";
                }
                result = result + param;
                break;
            }
            for (int c = 0; c < this.furtherJoins.size(); ++c) {
                if (!this.furtherJoins.get(c).usesParameter(param)) continue;
                if (result.length() > 0) {
                    result = result + ", ";
                }
                result = result + param;
                continue block0;
            }
        }
        return result;
    }

    public String getUsedParameters(RelationshipAttribute attr) {
        int count = attr.getParameterCount();
        String result = "";
        block0: for (int i = 0; i < count; ++i) {
            String param = attr.getParameterVariableAt(i);
            if (this.parentJoin != null && this.parentJoin.usesParameter(param)) {
                if (result.length() > 0) {
                    result = result + ", ";
                }
                result = result + attr.getParameterTypeAt(i) + " " + param;
                break;
            }
            for (int c = 0; c < this.furtherJoins.size(); ++c) {
                if (!this.furtherJoins.get(c).usesParameter(param)) continue;
                if (result.length() > 0) {
                    result = result + ", ";
                }
                result = result + attr.getParameterTypeAt(i) + " " + param;
                continue block0;
            }
        }
        return result;
    }

    private boolean usesParameter(String param) {
        if (this.parentJoin != null && this.parentJoin.usesParameter(param)) {
            return true;
        }
        for (int c = 0; c < this.furtherJoins.size(); ++c) {
            if (!this.furtherJoins.get(c).usesParameter(param)) continue;
            return true;
        }
        return false;
    }
}

