/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.metamodel;

import com.gs.fw.common.mithra.generator.metamodel.Identity;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorMarshaller;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorUnmarshaller;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public abstract class IdentityAbstract
implements Serializable {
    private static final Map<String, String> validValues = new HashMap<String, String>();
    private String value;
    private Object parent;

    public Identity with(String attributeValue, Object parent) {
        this.value = attributeValue;
        this.parent = parent;
        return (Identity)this;
    }

    public Object parent() {
        return this.parent;
    }

    public String value() {
        return this.value;
    }

    public void _setParent(Object parent) {
        this.parent = parent;
    }

    public boolean isTrue() {
        return "true" == this.value;
    }

    public void parse(String attributeName, String attributeValue, MithraGeneratorUnmarshaller unmarshaller) throws XMLStreamException {
        attributeValue = unmarshaller.toToken(attributeName, attributeValue);
        this.value = validValues.get(attributeValue);
        if (this.value == null) {
            unmarshaller.unknownAttribute(attributeName, attributeValue);
            this.value = attributeValue;
        }
    }

    public void parse(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        String elementValue = unmarshaller.getElementValue(typeName);
        this.value = validValues.get(elementValue);
        if (this.value == null) {
            unmarshaller.unknownAttribute(typeName, elementValue);
            this.value = elementValue;
        }
    }

    public void toXmlAsAttribute(MithraGeneratorMarshaller marshaller, String attributeName) throws IOException {
        marshaller.writeAttribute(attributeName, this.value);
    }

    public void toXmlAsElement(MithraGeneratorMarshaller marshaller, String elementName) throws IOException {
        marshaller.writeSimpleTag(elementName, this.value);
    }

    public void toXml(MithraGeneratorMarshaller marshaller, String elementName) throws IOException {
        marshaller.writeSimpleTag(elementName, this.value);
    }

    static {
        validValues.put("true", "true");
    }
}

