/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.metamodel;

import com.gs.fw.common.mithra.generator.metamodel.Mithra;
import com.gs.fw.common.mithra.generator.metamodel.MithraEmbeddedValueObject;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorParserException;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorUnmarshaller;
import com.gs.fw.common.mithra.generator.metamodel.MithraInterface;
import com.gs.fw.common.mithra.generator.metamodel.MithraObject;
import com.gs.fw.common.mithra.generator.metamodel.MithraPureObject;
import com.gs.fw.common.mithra.generator.metamodel.MithraTempObject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class MithraGeneratorUnmarshallerAbstract {
    private static final Map<Integer, String> decode = new HashMap<Integer, String>();
    private static ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private static ThreadLocal<SimpleDateFormat> dateTimeFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
    };
    private static ThreadLocal<SimpleDateFormat> dateTimeFormatWithZone = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };
    private String diagnosticMessage;
    private boolean validateAttributes = true;
    private XMLStreamReader xmlStreamReader;

    public static List emptyList() {
        return Collections.EMPTY_LIST;
    }

    public XMLStreamReader getXmlStreamReader() {
        return this.xmlStreamReader;
    }

    public void setValidateAttributes(boolean validateAttributes) {
        this.validateAttributes = validateAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(String filename) throws IOException {
        try (FileInputStream in = new FileInputStream(filename);){
            Object object = this.parse(in, "in file " + filename);
            return object;
        }
    }

    public Object parse(InputStream in, String diagnosticMessage) throws IOException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try {
            this.xmlStreamReader = inputFactory.createXMLStreamReader(in);
            this.diagnosticMessage = diagnosticMessage;
            return this.parse();
        }
        catch (XMLStreamException e) {
            throw new MithraGeneratorParserException(diagnosticMessage + " error in input stream", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse() throws XMLStreamException {
        try {
            this.getNextByType(1);
            String elementName = this.xmlStreamReader.getLocalName();
            if (elementName.equals("Mithra")) {
                Mithra result = new Mithra();
                result.parse((MithraGeneratorUnmarshaller)this, "Mithra");
                Mithra mithra = result;
                return mithra;
            }
            if (elementName.equals("MithraObject")) {
                MithraObject result = new MithraObject();
                result.parse((MithraGeneratorUnmarshaller)this, "MithraObject");
                MithraObject mithraObject = result;
                return mithraObject;
            }
            if (elementName.equals("MithraPureObject")) {
                MithraPureObject result = new MithraPureObject();
                result.parse((MithraGeneratorUnmarshaller)this, "MithraPureObject");
                MithraPureObject mithraPureObject = result;
                return mithraPureObject;
            }
            if (elementName.equals("MithraTempObject")) {
                MithraTempObject result = new MithraTempObject();
                result.parse((MithraGeneratorUnmarshaller)this, "MithraTempObject");
                MithraTempObject mithraTempObject = result;
                return mithraTempObject;
            }
            if (elementName.equals("MithraInterface")) {
                MithraInterface result = new MithraInterface();
                result.parse((MithraGeneratorUnmarshaller)this, "MithraInterface");
                MithraInterface mithraInterface = result;
                return mithraInterface;
            }
            if (elementName.equals("MithraEmbeddedValueObject")) {
                MithraEmbeddedValueObject result = new MithraEmbeddedValueObject();
                result.parse((MithraGeneratorUnmarshaller)this, "MithraEmbeddedValueObject");
                MithraEmbeddedValueObject mithraEmbeddedValueObject = result;
                return mithraEmbeddedValueObject;
            }
            this.throwException("Unexpected top level element: " + elementName);
            Object var2_8 = null;
            return var2_8;
        }
        finally {
            this.cleanThreadLocals();
        }
    }

    private void cleanThreadLocals() {
        dateFormat.remove();
        dateTimeFormat.remove();
        dateTimeFormatWithZone.remove();
    }

    public void unknownAttribute(String attributeName, String attributeValue) {
        if (this.validateAttributes) {
            this.throwException("unexpected value '" + attributeValue + "' in '" + attributeName + "'");
        } else {
            Location location = this.xmlStreamReader.getLocation();
            this.warn("unexpected value '" + attributeValue + "' in '" + attributeName + "' at location: " + location.toString() + (this.diagnosticMessage == null ? "" : " " + this.diagnosticMessage));
        }
    }

    protected void warn(String msg) {
        System.out.println("WARN: " + msg);
    }

    public List newList() {
        return new ArrayList();
    }

    public void throwException(String msg) {
        throw new MithraGeneratorParserException(msg, this.xmlStreamReader == null ? null : this.xmlStreamReader.getLocation(), this.diagnosticMessage);
    }

    public void getNextByType(int type) throws XMLStreamException {
        int event = this.xmlStreamReader.next();
        while (event == 5 || event == 6 || event == 3 || event == 4 && this.xmlStreamReader.getText().trim().length() == 0 && this.xmlStreamReader.hasNext()) {
            event = this.xmlStreamReader.next();
        }
        if (event != type) {
            this.throwException("Did not get xml event of type " + decode.get(type) + " but rather " + decode.get(event));
        }
    }

    public int getNextStartOrEnd() throws XMLStreamException {
        int event = this.xmlStreamReader.next();
        while (event == 5 || event == 6 || event == 4 && this.xmlStreamReader.getText().trim().length() == 0 && this.xmlStreamReader.hasNext()) {
            event = this.xmlStreamReader.next();
        }
        if (event != 1 && event != 2) {
            this.throwException("Did not get xml event of type start or end but rather " + decode.get(event));
        }
        return event;
    }

    public void skipToEndOfElement(String elementName) throws XMLStreamException {
        while (this.xmlStreamReader.hasNext()) {
            int next = this.xmlStreamReader.next();
            if (next != 2 || !this.xmlStreamReader.getLocalName().equals(elementName)) continue;
            return;
        }
    }

    public String parsePlainString(String name) throws XMLStreamException {
        int event = this.xmlStreamReader.next();
        event = this.skipCommentsAndSpace(event);
        String tokenString = "";
        while (event == 4) {
            tokenString = tokenString + this.xmlStreamReader.getText();
            if (!this.xmlStreamReader.hasNext()) break;
            event = this.xmlStreamReader.next();
            event = this.skipCommentsAndSpace(event);
        }
        if (event == 2 && this.xmlStreamReader.getLocalName().equals(name)) {
            return tokenString;
        }
        this.throwException("expecting end of " + name);
        return null;
    }

    public String parseTokenString(String name) throws XMLStreamException {
        int event = this.xmlStreamReader.next();
        event = this.skipCommentsAndSpace(event);
        String tokenString = "";
        while (event == 4) {
            tokenString = tokenString + this.xmlStreamReader.getText();
            if (!this.xmlStreamReader.hasNext()) break;
            event = this.xmlStreamReader.next();
            event = this.skipCommentsAndSpace(event);
        }
        if (event == 2 && this.xmlStreamReader.getLocalName().equals(name)) {
            return this.toToken(name, tokenString);
        }
        this.throwException("expecting end of " + name);
        return null;
    }

    private int skipCommentsAndSpace(int event) throws XMLStreamException {
        while ((event == 5 || event == 6) && this.xmlStreamReader.hasNext()) {
            event = this.xmlStreamReader.next();
        }
        return event;
    }

    public String toPlainString(String attributeName, String attributeValue) {
        return attributeValue;
    }

    public String toToken(String name, String value) {
        if (value.length() == 0) {
            return "";
        }
        if (this.hasTokenWhiteSpace(value)) {
            int start;
            for (start = 0; start < value.length() && this.isWhiteSpace(value.charAt(start)); ++start) {
            }
            if (start == value.length()) {
                return "";
            }
            int end = value.length();
            while (this.isWhiteSpace(value.charAt(end - 1))) {
                --end;
            }
            StringBuilder builder = new StringBuilder(end - start + 1);
            boolean lastWasWhite = false;
            for (int i = start; i < end; ++i) {
                char c = value.charAt(i);
                if (this.isWhiteSpace(c)) {
                    if (!lastWasWhite) {
                        builder.append(' ');
                    }
                    lastWasWhite = true;
                    continue;
                }
                lastWasWhite = false;
                builder.append(c);
            }
            value = builder.toString();
        }
        return value;
    }

    private boolean hasTokenWhiteSpace(String attributeValue) {
        char c = attributeValue.charAt(0);
        if (this.isWhiteSpace(c)) {
            return true;
        }
        c = attributeValue.charAt(attributeValue.length() - 1);
        if (this.isWhiteSpace(c)) {
            return true;
        }
        boolean lastWasWhite = false;
        for (int i = 0; i < attributeValue.length(); ++i) {
            c = attributeValue.charAt(i);
            if (this.isWhiteSpace(c)) {
                if (lastWasWhite) {
                    return true;
                }
                lastWasWhite = true;
                continue;
            }
            lastWasWhite = false;
        }
        return false;
    }

    private boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public String toNormalizedString(String attributeName, String attributeValue) {
        throw new RuntimeException("not implemented");
    }

    public int parseInt(String attributeName, String attributeValue) {
        try {
            return Integer.parseInt(attributeValue);
        }
        catch (NumberFormatException e) {
            this.throwException("Could not parse " + attributeName + " for value " + attributeValue);
            return 0;
        }
    }

    public short parseShort(String attributeName, String attributeValue) {
        try {
            return Short.parseShort(attributeValue);
        }
        catch (NumberFormatException e) {
            this.throwException("Could not parse " + attributeName + " for value " + attributeValue);
            return 0;
        }
    }

    public Date parseDate(String elementName) throws XMLStreamException {
        return this.parseDate(elementName, this.getElementValue(elementName));
    }

    public Date parseDate(String attributeName, String attributeValue) {
        try {
            if (attributeValue.length() < 10) {
                this.throwException("Could not parse " + attributeName + " for value " + attributeValue);
            }
            return dateFormat.get().parse(attributeValue.substring(0, 10));
        }
        catch (ParseException e) {
            this.throwException("Could not parse " + attributeName + " for value " + attributeValue);
            return null;
        }
    }

    public Date parseDateTime(String elementName) throws XMLStreamException {
        return this.parseDateTime(elementName, this.getElementValue(elementName));
    }

    public Date parseDateTime(String attributeName, String attributeValue) {
        try {
            if (attributeValue.length() < 19) {
                this.throwException("Could not parse " + attributeName + " for value " + attributeValue);
            }
            if (attributeValue.length() == 19) {
                return dateTimeFormat.get().parse(attributeValue + ".000");
            }
            if (attributeValue.charAt(19) == '.') {
                int index;
                for (index = 20; index < attributeValue.length() && Character.isDigit(attributeValue.charAt(index)); ++index) {
                }
                if (index == attributeValue.length()) {
                    return dateTimeFormat.get().parse(attributeValue.substring(0, Math.min(23, attributeValue.length())));
                }
                return dateTimeFormatWithZone.get().parse(attributeValue.substring(0, Math.min(23, index)) + this.normalizeTimeZone(attributeName, attributeValue, attributeValue.substring(index)));
            }
            return dateTimeFormatWithZone.get().parse(attributeValue.substring(0, 19) + this.normalizeTimeZone(attributeName, attributeValue, attributeValue.substring(19)));
        }
        catch (ParseException e) {
            this.throwException("Could not parse " + attributeName + " for value " + attributeValue);
            return null;
        }
    }

    private String normalizeTimeZone(String attributeName, String attributeValue, String zone) {
        if (zone.equals("Z")) {
            return "+0000";
        }
        if (zone.length() != 6) {
            this.throwException("Could not parse time zone " + zone + " in attribute " + attributeName + " with full value " + attributeValue);
        }
        return zone.substring(0, 3) + zone.substring(4);
    }

    public long parseLong(String attributeName, String attributeValue) {
        try {
            return Long.parseLong(attributeValue);
        }
        catch (NumberFormatException e) {
            this.throwException("Could not parse " + attributeName + " for value " + attributeValue);
            return 0L;
        }
    }

    public boolean parseBoolean(String attributeName, String attributeValue) {
        try {
            return Boolean.parseBoolean(attributeValue);
        }
        catch (NumberFormatException e) {
            this.throwException("Could not parse " + attributeName + " for value " + attributeValue);
            return false;
        }
    }

    private boolean isInvalidDecimalFormat(String value) {
        for (int end = value.length(); end != 0; --end) {
            char c = value.charAt(end - 1);
            if (c != 'e' && c != 'E' && c != 'x' && c != 'X' && c != 'N') continue;
            return true;
        }
        return false;
    }

    public double parseDecimal(String attributeName, String attributeValue) {
        if (this.isInvalidDecimalFormat(attributeValue)) {
            this.throwException("Could not parse " + attributeName + " for value " + attributeValue);
        }
        try {
            return Double.parseDouble(attributeValue);
        }
        catch (NumberFormatException e) {
            this.throwException("Could not parse " + attributeName + " for value " + attributeValue);
            return 0.0;
        }
    }

    public double parseDouble(String elementName) throws XMLStreamException {
        return this.parseDouble(elementName, this.getElementValue(elementName));
    }

    public double parseDouble(String attributeName, String attributeValue) {
        try {
            return Double.parseDouble(attributeValue);
        }
        catch (NumberFormatException e) {
            this.throwException("Could not parse " + attributeName + " for value " + attributeValue);
            return 0.0;
        }
    }

    public boolean parseBoolean(String elementName) throws XMLStreamException {
        return this.parseBoolean(elementName, this.getElementValue(elementName));
    }

    public int parsePositiveInt(String attributeName, String attributeValue) {
        int value = this.parseInt(attributeName, attributeValue);
        if (value < 1) {
            this.throwException("Unexpected value : " + attributeValue + " for " + attributeName + ". Expected type is positiveInteger");
        }
        return value;
    }

    public int parseNonNegativeInt(String attributeName, String attributeValue) {
        int value = this.parseInt(attributeName, attributeValue);
        if (value < 0) {
            this.throwException("Unexpected value : " + attributeValue + " for " + attributeName + ". Expected type is nonNegativeInteger");
        }
        return value;
    }

    public int parseNonPositiveInt(String attributeName, String attributeValue) {
        int value = this.parseInt(attributeName, attributeValue);
        if (value > 0) {
            this.throwException("Unexpected value : " + attributeValue + " for " + attributeName + ". Expected type is nonPositiveInteger");
        }
        return value;
    }

    public int parseNegativeInt(String attributeName, String attributeValue) {
        int value = this.parseInt(attributeName, attributeValue);
        if (value > -1) {
            this.throwException("Unexpected value : " + attributeValue + " for " + attributeName + ". Expected type is negativeInteger");
        }
        return value;
    }

    public int parseInt(String elementName) throws XMLStreamException {
        return this.parseInt(elementName, this.getElementValue(elementName));
    }

    public long parseLong(String elementName) throws XMLStreamException {
        return this.parseLong(elementName, this.getElementValue(elementName));
    }

    public String getElementValue(String elementName) throws XMLStreamException {
        this.checkNoAttributes(elementName);
        int event = this.xmlStreamReader.next();
        event = this.skipCommentsAndSpace(event);
        String tokenString = null;
        while (event == 4) {
            String string = tokenString = tokenString == null ? this.xmlStreamReader.getText() : tokenString + this.xmlStreamReader.getText();
            if (!this.xmlStreamReader.hasNext()) break;
            event = this.xmlStreamReader.next();
            event = this.skipCommentsAndSpace(event);
        }
        if (event == 2 && this.xmlStreamReader.getLocalName().equals(elementName)) {
            return tokenString;
        }
        this.throwException("expecting end of " + elementName);
        return null;
    }

    public double parseDecimal(String elementName) throws XMLStreamException {
        return this.parseDecimal(elementName, this.getElementValue(elementName));
    }

    public short parseShort(String elementName) throws XMLStreamException {
        return this.parseShort(elementName, this.getElementValue(elementName));
    }

    private void checkNoAttributes(String elementName) {
        if (this.xmlStreamReader.getAttributeCount() > 0 && this.validateAttributes) {
            this.throwException("Element " + elementName + " should not have any attributes");
        }
    }

    public boolean isAtEnd(int eventType, String elementName) {
        return eventType == 2 && this.xmlStreamReader.getLocalName().equals(elementName);
    }

    public void expectEnd(int eventType, String elementName) {
        if (!this.isAtEnd(eventType, elementName)) {
            this.throwException("expecting end of element <" + elementName + ">");
        }
    }

    public int getFractionDigits(String value) {
        int end;
        int scale = 0;
        for (end = value.length(); end != 0 && value.charAt(end - 1) != '.'; --end) {
            ++scale;
        }
        if (end == 0) {
            return 0;
        }
        return scale;
    }

    public int getTotalDigits(String value) {
        int scale = 0;
        for (int end = value.length(); end != 0; --end) {
            if (value.charAt(end - 1) == '.') continue;
            ++scale;
        }
        return scale;
    }

    static {
        decode.put(10, "ATTRIBUTE");
        decode.put(12, "CDATA");
        decode.put(4, "CHARACTERS");
        decode.put(5, "COMMENT");
        decode.put(11, "DTD");
        decode.put(8, "END_DOCUMENT");
        decode.put(2, "END_ELEMENT");
        decode.put(15, "ENTITY_DECLARATION");
        decode.put(9, "ENTITY_REFERENCE");
        decode.put(13, "NAMESPACE");
        decode.put(14, "NOTATION_DECLARATION");
        decode.put(3, "PROCESSING_INSTRUCTION");
        decode.put(6, "SPACE");
        decode.put(7, "START_DOCUMENT");
        decode.put(1, "START_ELEMENT");
    }
}

