/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.metamodel;

import com.gs.fw.common.mithra.generator.metamodel.AsOfAttributeType;
import com.gs.fw.common.mithra.generator.metamodel.AttributeType;
import com.gs.fw.common.mithra.generator.metamodel.EmbeddedValueType;
import com.gs.fw.common.mithra.generator.metamodel.IndexType;
import com.gs.fw.common.mithra.generator.metamodel.MithraCommonObjectType;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorMarshaller;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorUnmarshaller;
import com.gs.fw.common.mithra.generator.metamodel.RelationshipType;
import com.gs.fw.common.mithra.generator.metamodel.SourceAttributeType;
import com.gs.fw.common.mithra.generator.metamodel.TransactionalMethodSignatureType;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class MithraObjectTypeAbstract
extends MithraCommonObjectType {
    private static Map<String, Integer> elementNameStates = new HashMap<String, Integer>();
    private String defaultTable;
    private List<String> mithraInterfaces = MithraGeneratorUnmarshaller.emptyList();
    private SourceAttributeType sourceAttribute;
    private List<AsOfAttributeType> asOfAttributes = MithraGeneratorUnmarshaller.emptyList();
    private List<AttributeType> attributes = MithraGeneratorUnmarshaller.emptyList();
    private List<EmbeddedValueType> embeddedValues = MithraGeneratorUnmarshaller.emptyList();
    private List<TransactionalMethodSignatureType> transactionalMethodSignatures = MithraGeneratorUnmarshaller.emptyList();
    private List<RelationshipType> relationships = MithraGeneratorUnmarshaller.emptyList();
    private List<IndexType> indexes = MithraGeneratorUnmarshaller.emptyList();
    private Object _parent;

    @Override
    public Object parent() {
        return this._parent;
    }

    @Override
    public void _setParent(Object parent) {
        this._parent = parent;
    }

    @Override
    public void parse(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        this.parseAttributes(unmarshaller);
        this.parseElements(unmarshaller, typeName);
    }

    @Override
    protected void initListElements(MithraGeneratorUnmarshaller unmarshaller) {
        super.initListElements(unmarshaller);
        this.mithraInterfaces = unmarshaller.newList();
        this.asOfAttributes = unmarshaller.newList();
        this.attributes = unmarshaller.newList();
        this.embeddedValues = unmarshaller.newList();
        this.transactionalMethodSignatures = unmarshaller.newList();
        this.relationships = unmarshaller.newList();
        this.indexes = unmarshaller.newList();
    }

    @Override
    protected void parseElements(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        this.initListElements(unmarshaller);
        int eventType = unmarshaller.getNextStartOrEnd();
        if (!unmarshaller.isAtEnd(eventType, typeName)) {
            XMLStreamReader xmlStreamReader = unmarshaller.getXmlStreamReader();
            int currentElementState = Integer.MAX_VALUE;
            int state = 0;
            while (eventType == 1) {
                String elementName = xmlStreamReader.getLocalName();
                currentElementState = this.getState(elementName);
                if (state <= currentElementState) {
                    if (state < 0) {
                        unmarshaller.throwException("unexpected element in MithraObjectType: " + elementName);
                    }
                } else {
                    unmarshaller.throwException("element out of order " + elementName + " in type MithraObjectType");
                }
                this.parseElement(unmarshaller, state, elementName);
                state = currentElementState;
                eventType = unmarshaller.getNextStartOrEnd();
            }
            if (state < 2) {
                unmarshaller.throwException("expecting at least one element of type ClassName in MithraObjectType");
            }
            unmarshaller.expectEnd(eventType, typeName);
            this.checkListMinOccurs(unmarshaller);
        }
    }

    @Override
    protected void checkListMinOccurs(MithraGeneratorUnmarshaller unmarshaller) {
    }

    @Override
    protected int getState(String elementName) throws XMLStreamException {
        Integer state = elementNameStates.get(elementName);
        if (state != null) {
            return state;
        }
        int superState = super.getState(elementName);
        if (superState > 0) {
            return superState;
        }
        return -1;
    }

    @Override
    protected void parseElement(MithraGeneratorUnmarshaller unmarshaller, int state, String elementName) throws XMLStreamException {
        if (state < 7) {
            super.parseElement(unmarshaller, state, elementName);
        }
        if (elementName.equals("DefaultTable")) {
            if (!this.isDefaultTableSet()) {
                this.setDefaultTable(unmarshaller.parseTokenString("DefaultTable"));
            } else {
                unmarshaller.throwException("too many occurrences of element DefaultTable in type MithraObjectType. Max occurrences is 1");
            }
        }
        if (elementName.equals("MithraInterface")) {
            this.getMithraInterfaces().add(unmarshaller.parseTokenString("MithraInterface"));
        }
        if (elementName.equals("SourceAttribute")) {
            if (!this.isSourceAttributeSet()) {
                SourceAttributeType _sourceAttribute = new SourceAttributeType();
                _sourceAttribute.parse(unmarshaller, "SourceAttribute");
                _sourceAttribute._setParent(this);
                this.setSourceAttribute(_sourceAttribute);
            } else {
                unmarshaller.throwException("too many occurrences of element SourceAttribute in type MithraObjectType. Max occurrences is 1");
            }
        }
        if (elementName.equals("AsOfAttribute")) {
            if (this.asOfAttributes.size() < 2) {
                AsOfAttributeType _asOfAttribute = new AsOfAttributeType();
                _asOfAttribute.parse(unmarshaller, "AsOfAttribute");
                _asOfAttribute._setParent(this);
                this.getAsOfAttributes().add(_asOfAttribute);
            } else {
                unmarshaller.throwException("too many occurrences of element AsOfAttribute in type MithraObjectType. Max occurrences is 2");
            }
        }
        if (elementName.equals("Attribute")) {
            AttributeType _attribute = new AttributeType();
            _attribute.parse(unmarshaller, "Attribute");
            _attribute._setParent(this);
            this.getAttributes().add(_attribute);
        }
        if (elementName.equals("EmbeddedValue")) {
            EmbeddedValueType _embeddedValue = new EmbeddedValueType();
            _embeddedValue.parse(unmarshaller, "EmbeddedValue");
            _embeddedValue._setParent(this);
            this.getEmbeddedValues().add(_embeddedValue);
        }
        if (elementName.equals("TransactionalMethodSignature")) {
            TransactionalMethodSignatureType _transactionalMethodSignature = new TransactionalMethodSignatureType();
            _transactionalMethodSignature.parse(unmarshaller, "TransactionalMethodSignature");
            _transactionalMethodSignature._setParent(this);
            this.getTransactionalMethodSignatures().add(_transactionalMethodSignature);
        }
        if (elementName.equals("Relationship")) {
            RelationshipType _relationship = new RelationshipType();
            _relationship.parse(unmarshaller, "Relationship");
            _relationship._setParent(this);
            this.getRelationships().add(_relationship);
        }
        if (elementName.equals("Index")) {
            IndexType _index = new IndexType();
            _index.parse(unmarshaller, "Index");
            _index._setParent(this);
            this.getIndexes().add(_index);
        }
    }

    @Override
    public String getDefaultTable() {
        return this.defaultTable;
    }

    public void setDefaultTable(String defaultTable) {
        this.defaultTable = defaultTable;
    }

    public boolean isDefaultTableSet() {
        return this.defaultTable != null;
    }

    @Override
    public List<String> getMithraInterfaces() {
        return this.mithraInterfaces;
    }

    public void setMithraInterfaces(List<String> mithraInterfaces) {
        this.mithraInterfaces = mithraInterfaces;
    }

    public boolean isMithraInterfacesSet() {
        return this.mithraInterfaces != null && this.mithraInterfaces.size() > 0;
    }

    @Override
    public SourceAttributeType getSourceAttribute() {
        return this.sourceAttribute;
    }

    public void setSourceAttribute(SourceAttributeType sourceAttribute) {
        this.sourceAttribute = sourceAttribute;
    }

    public boolean isSourceAttributeSet() {
        return this.sourceAttribute != null;
    }

    public List<AsOfAttributeType> getAsOfAttributes() {
        return this.asOfAttributes;
    }

    public void setAsOfAttributes(List<AsOfAttributeType> asOfAttributes) {
        this.asOfAttributes = asOfAttributes;
    }

    public boolean isAsOfAttributesSet() {
        return this.asOfAttributes != null && this.asOfAttributes.size() > 0;
    }

    @Override
    public List<AttributeType> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<AttributeType> attributes) {
        this.attributes = attributes;
    }

    public boolean isAttributesSet() {
        return this.attributes != null && this.attributes.size() > 0;
    }

    @Override
    public List<EmbeddedValueType> getEmbeddedValues() {
        return this.embeddedValues;
    }

    public void setEmbeddedValues(List<EmbeddedValueType> embeddedValues) {
        this.embeddedValues = embeddedValues;
    }

    public boolean isEmbeddedValuesSet() {
        return this.embeddedValues != null && this.embeddedValues.size() > 0;
    }

    public List<TransactionalMethodSignatureType> getTransactionalMethodSignatures() {
        return this.transactionalMethodSignatures;
    }

    public void setTransactionalMethodSignatures(List<TransactionalMethodSignatureType> transactionalMethodSignatures) {
        this.transactionalMethodSignatures = transactionalMethodSignatures;
    }

    public boolean isTransactionalMethodSignaturesSet() {
        return this.transactionalMethodSignatures != null && this.transactionalMethodSignatures.size() > 0;
    }

    public List<RelationshipType> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<RelationshipType> relationships) {
        this.relationships = relationships;
    }

    public boolean isRelationshipsSet() {
        return this.relationships != null && this.relationships.size() > 0;
    }

    public List<IndexType> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<IndexType> indexes) {
        this.indexes = indexes;
    }

    public boolean isIndexesSet() {
        return this.indexes != null && this.indexes.size() > 0;
    }

    @Override
    protected void marshallAttributes(MithraGeneratorMarshaller marshaller) throws IOException {
        super.marshallAttributes(marshaller);
    }

    @Override
    protected void marshallContent(MithraGeneratorMarshaller marshaller) throws IOException {
    }

    @Override
    protected void marshallElements(MithraGeneratorMarshaller marshaller) throws IOException {
        super.marshallElements(marshaller);
        if (this.isDefaultTableSet()) {
            marshaller.writeSimpleTag("DefaultTable", this.defaultTable);
        }
        if (this.isMithraInterfacesSet()) {
            for (String mithraInterface : this.mithraInterfaces) {
                marshaller.writeSimpleTag("MithraInterface", mithraInterface);
            }
        }
        if (this.isSourceAttributeSet()) {
            this.sourceAttribute.toXml(marshaller, "SourceAttribute");
        }
        if (this.isAsOfAttributesSet()) {
            for (AsOfAttributeType asOfAttribute : this.asOfAttributes) {
                asOfAttribute.toXml(marshaller, "AsOfAttribute");
            }
        }
        if (this.isAttributesSet()) {
            for (AttributeType attribute : this.attributes) {
                attribute.toXml(marshaller, "Attribute");
            }
        }
        if (this.isEmbeddedValuesSet()) {
            for (EmbeddedValueType embeddedValue : this.embeddedValues) {
                embeddedValue.toXml(marshaller, "EmbeddedValue");
            }
        }
        if (this.isTransactionalMethodSignaturesSet()) {
            for (TransactionalMethodSignatureType transactionalMethodSignature : this.transactionalMethodSignatures) {
                transactionalMethodSignature.toXml(marshaller, "TransactionalMethodSignature");
            }
        }
        if (this.isRelationshipsSet()) {
            for (RelationshipType relationship : this.relationships) {
                relationship.toXml(marshaller, "Relationship");
            }
        }
        if (this.isIndexesSet()) {
            for (IndexType index : this.indexes) {
                index.toXml(marshaller, "Index");
            }
        }
    }

    @Override
    public void toXml(MithraGeneratorMarshaller marshaller, String tagName) throws IOException {
        marshaller.writeStartTag(tagName);
        this.marshallAttributes(marshaller);
        this.marshallContent(marshaller);
        this.marshallElements(marshaller);
        marshaller.writeEndTag(tagName);
    }

    static {
        elementNameStates.put("DefaultTable", 7);
        elementNameStates.put("MithraInterface", 8);
        elementNameStates.put("SourceAttribute", 9);
        elementNameStates.put("AsOfAttribute", 10);
        elementNameStates.put("Attribute", 11);
        elementNameStates.put("EmbeddedValue", 12);
        elementNameStates.put("TransactionalMethodSignature", 13);
        elementNameStates.put("Relationship", 14);
        elementNameStates.put("Index", 15);
    }
}

