/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.JavaType;

public class ByteArrayJavaType
extends JavaType {
    @Override
    public String getResultSetName() {
        return "Bytes";
    }

    @Override
    public String getExtractionMethodName() {
        return "byteArrayValueOf";
    }

    @Override
    public String getValueSetterMethodName() {
        return "setByteArrayValue";
    }

    @Override
    public String getTypeName() {
        return "INT";
    }

    @Override
    public String getJavaTypeString() {
        return "byte[]";
    }

    @Override
    public String getJavaTypeStringPrimary() {
        return "ByteArray";
    }

    @Override
    public String convertToObject(String name) {
        return name;
    }

    @Override
    public String convertToPrimitive(String name) {
        throw new RuntimeException("byte[] is not primitive");
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public int getSqlType() {
        return -3;
    }

    @Override
    public String getSqlTypeAsString() {
        return "java.sql.Types.VARBINARY";
    }

    @Override
    public String getSqlDataType() {
        throw new RuntimeException("not applicable");
    }

    @Override
    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForVarBinary();
    }

    @Override
    public String getDefaultInitialValue() {
        return "null";
    }

    @Override
    public boolean isComparableTo(ASTLiteral node) {
        return false;
    }

    @Override
    public boolean isComparableTo(JavaType other) {
        return other instanceof ByteArrayJavaType;
    }

    @Override
    public String getJavaTypeClass() {
        return "byte[].class";
    }

    @Override
    public String getObjectComparisonString(String obj1, String obj2) {
        return "Arrays.equals(" + obj1 + ',' + obj2 + ')';
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int getOffHeapSize() {
        throw new RuntimeException("not implemented");
    }
}

