/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class ByteJavaType
extends PrimitiveWrapperJavaType {
    @Override
    public String getTypeName() {
        return "BYTE";
    }

    @Override
    public String getJavaTypeString() {
        return "byte";
    }

    @Override
    public String getJavaTypeStringPrimary() {
        return "Byte";
    }

    @Override
    public String convertToObject(String name) {
        return "new Byte(" + name + ")";
    }

    @Override
    public String convertToPrimitive(String name) {
        return name + ".byteValue()";
    }

    @Override
    public int getSqlType() {
        return -6;
    }

    @Override
    public String getSqlTypeAsString() {
        return "java.sql.Types.TINYINT";
    }

    @Override
    public String getSqlDataType() {
        return "tinyint";
    }

    @Override
    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForByte();
    }

    @Override
    public String getDefaultInitialValue() {
        return "0";
    }

    @Override
    public boolean isComparableTo(ASTLiteral node) {
        if (node.isInteger()) {
            int intValue = new Integer(node.getValue());
            return intValue >= -128 && intValue <= 127;
        }
        return false;
    }

    @Override
    public String getJavaTypeClass() {
        return "Byte.TYPE";
    }

    @Override
    public String parseLiteralAndCast(String value) {
        return "(byte)" + value;
    }

    @Override
    public int getOffHeapSize() {
        return 1;
    }
}

