/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.JavaType;
import com.gs.fw.common.mithra.generator.type.TimestampJavaType;

public class DateJavaType
extends JavaType {
    @Override
    public String getTypeName() {
        return "DATE";
    }

    @Override
    public String getJavaTypeString() {
        return "Date";
    }

    @Override
    public String getJavaTypeStringPrimary() {
        return "Date";
    }

    @Override
    public String getPrintableForm(String getter) {
        return "PrintablePreparedStatement.dateFormat.print(" + getter + ".getTime())";
    }

    @Override
    public String getIoType() {
        return "Object";
    }

    @Override
    public String getIoCast() {
        return "(Date)";
    }

    @Override
    public String convertToObject(String name) {
        return name;
    }

    @Override
    public String convertToPrimitive(String name) {
        return name;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public int getSqlType() {
        return 91;
    }

    @Override
    public String getSqlTypeAsString() {
        return "java.sql.Types.DATE";
    }

    @Override
    public String getSqlDataType() {
        return "date";
    }

    @Override
    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForDateTime();
    }

    @Override
    public String getDefaultInitialValue() {
        return "null";
    }

    @Override
    public boolean isComparableTo(ASTLiteral node) {
        return node.isString();
    }

    @Override
    public boolean isComparableTo(JavaType other) {
        return other instanceof DateJavaType || other instanceof TimestampJavaType;
    }

    @Override
    public String getJavaTypeClass() {
        return "Date.class";
    }

    @Override
    public String getObjectComparisonString(String obj1, String obj2) {
        return obj1 + ".equals(" + obj2 + ")";
    }

    @Override
    public int getOffHeapSize() {
        return 8;
    }
}

