/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class IntJavaType
extends PrimitiveWrapperJavaType {
    @Override
    public String getTypeName() {
        return "INT";
    }

    @Override
    public String getJavaTypeString() {
        return "int";
    }

    @Override
    public String getJavaTypeStringPrimary() {
        return "Integer";
    }

    @Override
    public String convertToObject(String name) {
        return "Integer.valueOf(" + name + ")";
    }

    @Override
    public String convertToPrimitive(String name) {
        return name + ".intValue()";
    }

    @Override
    public boolean isIntOrLong() {
        return true;
    }

    @Override
    public int getSqlType() {
        return 4;
    }

    @Override
    public String getSqlTypeAsString() {
        return "java.sql.Types.INTEGER";
    }

    @Override
    public String getSqlDataType() {
        return "integer";
    }

    @Override
    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForInt();
    }

    @Override
    public String getDefaultInitialValue() {
        return "0";
    }

    @Override
    public boolean isComparableTo(ASTLiteral node) {
        return node.isInteger();
    }

    @Override
    public String getJavaTypeClass() {
        return "Integer.TYPE";
    }

    @Override
    public String getArgumentForInOperation(String values, MithraObjectTypeWrapper fromObject) {
        return fromObject.getConstantIntSet(values);
    }

    @Override
    public String getConnectionManagerClassName() {
        return "com.gs.fw.common.mithra.connectionmanager.IntSourceConnectionManager";
    }

    @Override
    public boolean mayBeIdentity() {
        return true;
    }

    @Override
    public int getOffHeapSize() {
        return 4;
    }
}

