/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.BeanState;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class LongJavaType
extends PrimitiveWrapperJavaType {
    @Override
    public String getTypeName() {
        return "LONG";
    }

    @Override
    public String getJavaTypeString() {
        return "long";
    }

    @Override
    public String getJavaTypeStringPrimary() {
        return "Long";
    }

    @Override
    public String convertToObject(String name) {
        return "new Long(" + name + ")";
    }

    @Override
    public String convertToPrimitive(String name) {
        return name + ".longValue()";
    }

    @Override
    public boolean isIntOrLong() {
        return true;
    }

    @Override
    public int getSqlType() {
        return -5;
    }

    @Override
    public String getSqlTypeAsString() {
        return "java.sql.Types.BIGINT";
    }

    @Override
    public String getSqlDataType() {
        return "bigint";
    }

    @Override
    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForLong();
    }

    @Override
    public String getDefaultInitialValue() {
        return "0";
    }

    @Override
    public boolean isComparableTo(ASTLiteral node) {
        return node.isInteger();
    }

    @Override
    public String getJavaTypeClass() {
        return "Long.TYPE";
    }

    @Override
    public boolean mayBeIdentity() {
        return true;
    }

    @Override
    public String getBeanGetter(int intCount, int longCount, int objectCount) {
        return "getL" + longCount + "AsLong";
    }

    @Override
    public boolean isBeanIntType() {
        return false;
    }

    @Override
    public boolean isBeanLongType() {
        return true;
    }

    @Override
    public String getBeanSetter(BeanState beanState) {
        return "setL" + beanState.getLongCount() + "AsLong";
    }

    @Override
    public int getOffHeapSize() {
        return 8;
    }
}

