/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.util;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoShutdownThreadExecutor
implements Executor {
    private static AtomicInteger globalPoolCounter = new AtomicInteger();
    private int timeoutInMilliseconds = 60000;
    private final int maxThreads;
    private int poolNumber;
    private final String name;
    private AtomicLong combinedState = new AtomicLong();
    private AtomicInteger threadId = new AtomicInteger();
    private volatile boolean isAborted;
    private final Object endSignal = new Object();
    private LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();
    private ExceptionHandler exceptionHandler;
    private ThreadGroup threadGroup;

    public AutoShutdownThreadExecutor(int maxThreads, String name) {
        this.maxThreads = maxThreads;
        this.name = name;
        this.threadGroup = new ThreadGroup(name);
        this.poolNumber = globalPoolCounter.incrementAndGet();
    }

    @Override
    public void execute(Runnable runnable) {
        this.submit(runnable);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new DefaultExceptionHandler();
        }
        return this.exceptionHandler;
    }

    public void setTimeoutInMilliseconds(int timeoutInMilliseconds) {
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public void shutdown() {
        long newValue;
        long cur;
        while (!this.combinedState.compareAndSet(cur = this.combinedState.get(), newValue = cur | Long.MIN_VALUE)) {
        }
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public void shutdownNow() {
        this.shutdown();
        this.isAborted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAndWaitUntilDone() {
        this.shutdown();
        while (true) {
            Object object = this.endSignal;
            synchronized (object) {
                try {
                    if ((this.combinedState.get() & Long.MAX_VALUE) == 0L) {
                        break;
                    }
                    this.endSignal.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void submit(Runnable task) {
        this.queue.add(task);
        while (true) {
            long cur;
            int shutdown;
            if ((shutdown = (int)((cur = this.combinedState.get()) >> 63) & 1) != 0) {
                throw new RejectedExecutionException("ThreadExecutor is already shutdown");
            }
            int currentThreads = (int)(cur >> 32) & Integer.MAX_VALUE;
            int sizeMinusIdle = (int)(cur & 0xFFFFFFFFL);
            if (currentThreads < this.maxThreads && sizeMinusIdle >= 0) {
                long next;
                if (!this.combinedState.compareAndSet(cur, next = this.combineStates(++currentThreads, sizeMinusIdle, shutdown))) continue;
                ThreadGroup localThreadGroup = this.threadGroup;
                if (localThreadGroup.isDestroyed()) {
                    AutoShutdownThreadExecutor autoShutdownThreadExecutor = this;
                    synchronized (autoShutdownThreadExecutor) {
                        if (this.threadGroup.isDestroyed()) {
                            this.threadGroup = localThreadGroup = new ThreadGroup(this.name);
                        }
                    }
                }
                new ExecutorThread(this.name + "-" + this.poolNumber + "-" + this.threadId.incrementAndGet()).start();
                return;
            }
            if (this.trySettingState(cur, currentThreads, ++sizeMinusIdle, shutdown)) return;
        }
    }

    private boolean trySettingState(long cur, int currentThreads, int sizeMinusIdle, int shutdown) {
        long next = this.combineStates(currentThreads, sizeMinusIdle, shutdown);
        return this.combinedState.compareAndSet(cur, next);
    }

    private long combineStates(int currentThreads, int sizeMinusIdle, int shutdown) {
        return (long)currentThreads << 32 | (long)sizeMinusIdle & 0xFFFFFFFFL | (long)shutdown << 63;
    }

    protected void cleanUpAfterTask() {
    }

    private static class DefaultExceptionHandler
    implements ExceptionHandler {
        private static Logger logger = LoggerFactory.getLogger((String)AutoShutdownThreadExecutor.class.getName());

        private DefaultExceptionHandler() {
        }

        @Override
        public void handleException(AutoShutdownThreadExecutor executor, Runnable target, Throwable exception) {
            executor.shutdownNow();
            logger.error("Error in runnable target. Shutting down queue", exception);
        }
    }

    public static interface ExceptionHandler {
        public void handleException(AutoShutdownThreadExecutor var1, Runnable var2, Throwable var3);
    }

    private class ExecutorThread
    extends Thread {
        private ExecutorThread(String name) {
            super(AutoShutdownThreadExecutor.this.threadGroup, name);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                Runnable target = null;
                try {
                    target = (Runnable)AutoShutdownThreadExecutor.this.queue.poll(AutoShutdownThreadExecutor.this.timeoutInMilliseconds, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (target != null) {
                    if (!AutoShutdownThreadExecutor.this.isAborted) {
                        try {
                            target.run();
                        }
                        catch (Throwable t) {
                            AutoShutdownThreadExecutor.this.getExceptionHandler().handleException(AutoShutdownThreadExecutor.this, target, t);
                        }
                    }
                    AutoShutdownThreadExecutor.this.cleanUpAfterTask();
                    if (!this.terminateThread(true, true)) continue;
                    return;
                }
                if (this.terminateThread(false, false)) break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean terminateThread(boolean careAboutShutdown, boolean reduceQueueSize) {
            while (true) {
                long cur = AutoShutdownThreadExecutor.this.combinedState.get();
                int shutdown = (int)(cur >> 63) & 1;
                int currentThreads = (int)(cur >> 32) & Integer.MAX_VALUE;
                int sizeMinusIdle = (int)(cur & 0xFFFFFFFFL);
                if (reduceQueueSize) {
                    --sizeMinusIdle;
                }
                if (!careAboutShutdown | shutdown != 0 && sizeMinusIdle < 0) {
                    long next = AutoShutdownThreadExecutor.this.combineStates(--currentThreads, ++sizeMinusIdle, shutdown);
                    if (!AutoShutdownThreadExecutor.this.combinedState.compareAndSet(cur, next)) continue;
                    Object object = AutoShutdownThreadExecutor.this.endSignal;
                    synchronized (object) {
                        AutoShutdownThreadExecutor.this.endSignal.notify();
                    }
                    return true;
                }
                if (AutoShutdownThreadExecutor.this.trySettingState(cur, currentThreads, sizeMinusIdle, shutdown)) break;
            }
            return false;
        }
    }
}

