/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.http.client;

import com.gooddata.http.client.GoodDataAuthException;
import com.gooddata.http.client.GoodDataLogoutException;
import com.gooddata.http.client.SSTRetrievalStrategy;
import com.gooddata.http.client.TokenUtils;
import java.io.IOException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class LoginSSTRetrievalStrategy
implements SSTRetrievalStrategy {
    public static final String LOGIN_URL = "/gdc/account/login";
    private static final int VERIFICATION_LEVEL = 2;
    private final Log log = LogFactory.getLog(this.getClass());
    private final String login;
    private final String password;
    private final HttpHost httpHost;

    @Deprecated
    public LoginSSTRetrievalStrategy(HttpClient httpClient, HttpHost httpHost, String login, String password) {
        Validate.notNull((Object)httpHost, (String)"HTTP host cannot be null");
        Validate.notNull((Object)login, (String)"Login cannot be null");
        Validate.notNull((Object)password, (String)"Password cannot be null");
        this.login = login;
        this.password = password;
        this.httpHost = httpHost;
    }

    public LoginSSTRetrievalStrategy(String login, String password) {
        Validate.notNull((Object)login, (String)"Login cannot be null");
        Validate.notNull((Object)password, (String)"Password cannot be null");
        this.login = login;
        this.password = password;
        this.httpHost = null;
    }

    HttpHost getHttpHost() {
        return this.httpHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String obtainSst(HttpClient httpClient, HttpHost httpHost) throws IOException {
        Validate.notNull((Object)httpClient, (String)"client can't be null");
        Validate.notNull((Object)httpHost, (String)"host can't be null");
        this.log.debug((Object)"Obtaining SST");
        HttpPost postLogin = new HttpPost(LOGIN_URL);
        try {
            StringEntity requestEntity = new StringEntity(this.createLoginJson(), ContentType.APPLICATION_JSON);
            postLogin.setEntity((HttpEntity)requestEntity);
            postLogin.setHeader("Accept", "application/yaml");
            HttpResponse response = httpClient.execute(httpHost, (HttpRequest)postLogin);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new GoodDataAuthException("Unable to login: " + status);
            }
            String string = TokenUtils.extractToken(response);
            return string;
        }
        finally {
            postLogin.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout(HttpClient httpClient, HttpHost httpHost, String url, String sst, String tt) throws IOException, GoodDataLogoutException {
        Validate.notNull((Object)httpClient, (String)"client can't be null");
        Validate.notNull((Object)httpHost, (String)"host can't be null");
        Validate.notEmpty((String)url, (String)"url can't be empty");
        Validate.notEmpty((String)sst, (String)"SST can't be empty");
        Validate.notEmpty((String)tt, (String)"TT can't be empty");
        this.log.debug((Object)"performing logout");
        HttpDelete request = new HttpDelete(url);
        try {
            request.setHeader("X-GDC-AuthSST", sst);
            request.setHeader("X-GDC-AuthTT", tt);
            HttpResponse response = httpClient.execute(httpHost, (HttpRequest)request);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 204) {
                throw new GoodDataLogoutException("Logout unsuccessful using http", statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
        }
        finally {
            request.reset();
        }
    }

    private String createLoginJson() {
        return "{\"postUserLogin\":{\"login\":\"" + StringEscapeUtils.escapeJavaScript((String)this.login) + "\",\"password\":\"" + StringEscapeUtils.escapeJavaScript((String)this.password) + "\",\"remember\":0" + ",\"verify_level\":" + 2 + "}}";
    }
}

