/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.http.client;

import com.gooddata.http.client.GoodDataAuthException;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

class TokenUtils {
    private static final Pattern pattern = Pattern.compile("token: (.+)");

    private TokenUtils() {
    }

    static String extractToken(HttpResponse response) throws IOException {
        String responseBody = response == null || response.getEntity() == null ? "" : EntityUtils.toString((HttpEntity)response.getEntity());
        Matcher matcher = pattern.matcher(responseBody);
        if (!matcher.find()) {
            throw new GoodDataAuthException("Unable to login. Malformed response body: " + responseBody);
        }
        String token = matcher.group(1);
        if (token == null) {
            throw new GoodDataAuthException("Unable to login. Malformed response body: " + responseBody);
        }
        return token;
    }
}

