/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.http.client;

import com.gooddata.http.client.GoodDataAuthException;
import com.gooddata.http.client.GoodDataLogoutException;
import com.gooddata.http.client.LoginSSTRetrievalStrategy;
import com.gooddata.http.client.SSTRetrievalStrategy;
import com.gooddata.http.client.TokenUtils;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoodDataHttpClient
implements HttpClient {
    private static final String TOKEN_URL = "/gdc/account/token";
    public static final String COOKIE_GDC_AUTH_TT = "cookie=GDCAuthTT";
    public static final String COOKIE_GDC_AUTH_SST = "cookie=GDCAuthSST";
    static final String TT_HEADER = "X-GDC-AuthTT";
    static final String SST_HEADER = "X-GDC-AuthSST";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HttpClient httpClient;
    private final SSTRetrievalStrategy sstStrategy;
    private final HttpHost authHost;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock authLock = new ReentrantLock();
    private String sst;
    private String tt;

    @Deprecated
    public GoodDataHttpClient(HttpClient httpClient, SSTRetrievalStrategy sstStrategy) {
        Validate.notNull((Object)httpClient);
        this.httpClient = httpClient;
        if (!(sstStrategy instanceof LoginSSTRetrievalStrategy)) {
            throw new IllegalArgumentException("This constructor is deprecated and works with LoginSSTRetrievalStrategy argument only!");
        }
        this.sstStrategy = sstStrategy;
        this.authHost = ((LoginSSTRetrievalStrategy)sstStrategy).getHttpHost();
        Validate.notNull((Object)this.authHost, (String)"HTTP host cannot be null", (Object[])new Object[0]);
    }

    @Deprecated
    public GoodDataHttpClient(SSTRetrievalStrategy sstStrategy) {
        this((HttpClient)HttpClientBuilder.create().build(), sstStrategy);
    }

    public GoodDataHttpClient(HttpClient httpClient, HttpHost authHost, SSTRetrievalStrategy sstStrategy) {
        Validate.notNull((Object)httpClient);
        Validate.notNull((Object)authHost, (String)"HTTP host cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)sstStrategy);
        this.httpClient = httpClient;
        this.authHost = authHost;
        this.sstStrategy = sstStrategy;
    }

    public GoodDataHttpClient(HttpHost authHost, SSTRetrievalStrategy sstStrategy) {
        this((HttpClient)HttpClientBuilder.create().build(), authHost, sstStrategy);
    }

    private GoodDataChallengeType identifyGoodDataChallenge(HttpResponse response) {
        Header[] headers;
        if (response.getStatusLine().getStatusCode() == 401 && (headers = response.getHeaders("WWW-Authenticate")) != null) {
            for (Header header : headers) {
                String challenge = header.getValue();
                if (challenge.contains(COOKIE_GDC_AUTH_SST)) {
                    return GoodDataChallengeType.SST;
                }
                if (!challenge.contains(COOKIE_GDC_AUTH_TT)) continue;
                return GoodDataChallengeType.TT;
            }
        }
        return GoodDataChallengeType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse handleResponse(HttpHost httpHost, HttpRequest request, HttpResponse originalResponse, HttpContext context) throws IOException {
        block14: {
            GoodDataChallengeType challenge = this.identifyGoodDataChallenge(originalResponse);
            if (challenge == GoodDataChallengeType.UNKNOWN) {
                return originalResponse;
            }
            EntityUtils.consume((HttpEntity)originalResponse.getEntity());
            try {
                if (this.authLock.tryLock()) {
                    Lock writeLock = this.rwLock.writeLock();
                    writeLock.lock();
                    boolean doSST = true;
                    try {
                        if (challenge == GoodDataChallengeType.TT && this.sst != null && this.refreshTt()) {
                            doSST = false;
                        }
                        if (doSST) {
                            this.sst = this.sstStrategy.obtainSst(this.httpClient, this.authHost);
                            if (!this.refreshTt()) {
                                throw new GoodDataAuthException("Unable to obtain TT after successfully obtained SST");
                            }
                        }
                        break block14;
                    }
                    catch (GoodDataAuthException e) {
                        BasicHttpResponse basicHttpResponse = new BasicHttpResponse((StatusLine)new BasicStatusLine(originalResponse.getProtocolVersion(), 401, e.getMessage()));
                        this.authLock.unlock();
                        return basicHttpResponse;
                    }
                    finally {
                        writeLock.unlock();
                    }
                }
                this.authLock.lock();
            }
            finally {
                this.authLock.unlock();
            }
        }
        return this.execute(httpHost, request, context);
    }

    private boolean refreshTt() throws IOException {
        this.log.debug("Obtaining TT");
        HttpGet request = new HttpGet(TOKEN_URL);
        try {
            request.setHeader(SST_HEADER, this.sst);
            HttpResponse response = this.httpClient.execute(this.authHost, (HttpRequest)request, (HttpContext)null);
            int status = response.getStatusLine().getStatusCode();
            switch (status) {
                case 200: {
                    this.tt = TokenUtils.extractTT(response);
                    boolean bl = true;
                    return bl;
                }
                case 401: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw new GoodDataAuthException("Unable to obtain TT, HTTP status: " + status);
        }
        finally {
            request.reset();
        }
    }

    public HttpParams getParams() {
        return this.httpClient.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.httpClient.getConnectionManager();
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException {
        return this.execute(target, request, (HttpContext)null);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(target, request, responseHandler, null);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        HttpResponse resp = this.execute(target, request, context);
        return (T)responseHandler.handleResponse(resp);
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        return this.execute(request, (HttpContext)null);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        URI uri = request.getURI();
        HttpHost httpHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        return this.execute(httpHost, (HttpRequest)request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(request, responseHandler, null);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        HttpResponse resp = this.execute(request, context);
        return (T)responseHandler.handleResponse(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        HttpResponse resp;
        block9: {
            Validate.notNull((Object)request, (String)"Request can't be null", (Object[])new Object[0]);
            boolean logoutRequest = this.isLogoutRequest(target, request);
            Lock lock = logoutRequest ? this.rwLock.writeLock() : this.rwLock.readLock();
            lock.lock();
            try {
                if (this.tt != null) {
                    request.setHeader(TT_HEADER, this.tt);
                    if (logoutRequest) {
                        try {
                            this.sstStrategy.logout(this.httpClient, target, request.getRequestLine().getUri(), this.sst, this.tt);
                            this.tt = null;
                            this.sst = null;
                            BasicHttpResponse basicHttpResponse = new BasicHttpResponse((StatusLine)new BasicStatusLine(request.getProtocolVersion(), 204, "Logout successful"));
                            return basicHttpResponse;
                        }
                        catch (GoodDataLogoutException e) {
                            BasicHttpResponse basicHttpResponse = new BasicHttpResponse((StatusLine)new BasicStatusLine(request.getProtocolVersion(), e.getStatusCode(), e.getStatusText()));
                            lock.unlock();
                            return basicHttpResponse;
                        }
                    }
                }
                resp = this.httpClient.execute(target, request, context);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        return this.handleResponse(target, request, resp, context);
    }

    private boolean isLogoutRequest(HttpHost target, HttpRequest request) {
        return this.authHost.equals((Object)target) && "DELETE".equals(request.getRequestLine().getMethod()) && URI.create(request.getRequestLine().getUri()).getPath().startsWith("/gdc/account/login");
    }

    private static enum GoodDataChallengeType {
        SST,
        TT,
        UNKNOWN;

    }
}

