/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.http.client;

import com.gooddata.http.client.GoodDataAuthException;
import com.gooddata.http.client.GoodDataLogoutException;
import com.gooddata.http.client.JsonUtils;
import com.gooddata.http.client.SSTRetrievalStrategy;
import com.gooddata.http.client.TokenUtils;
import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginSSTRetrievalStrategy
implements SSTRetrievalStrategy {
    private static final String X_GDC_REQUEST_HEADER_NAME = "X-GDC-REQUEST";
    public static final String LOGIN_URL = "/gdc/account/login";
    private static final int VERIFICATION_LEVEL = 2;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final String login;
    private final String password;
    private final HttpHost httpHost;

    @Deprecated
    public LoginSSTRetrievalStrategy(HttpClient httpClient, HttpHost httpHost, String login, String password) {
        Validate.notNull((Object)httpHost, (String)"HTTP host cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)login, (String)"Login cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)password, (String)"Password cannot be null", (Object[])new Object[0]);
        this.login = login;
        this.password = password;
        this.httpHost = httpHost;
    }

    public LoginSSTRetrievalStrategy(String login, String password) {
        Validate.notNull((Object)login, (String)"Login cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)password, (String)"Password cannot be null", (Object[])new Object[0]);
        this.login = login;
        this.password = password;
        this.httpHost = null;
    }

    HttpHost getHttpHost() {
        return this.httpHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String obtainSst(HttpClient httpClient, HttpHost httpHost) throws IOException {
        Validate.notNull((Object)httpClient, (String)"client can't be null", (Object[])new Object[0]);
        Validate.notNull((Object)httpHost, (String)"host can't be null", (Object[])new Object[0]);
        this.log.debug("Obtaining SST");
        HttpPost postLogin = new HttpPost(LOGIN_URL);
        try {
            String loginJson = JsonUtils.createLoginJson(this.login, this.password, 2);
            postLogin.setEntity((HttpEntity)new StringEntity(loginJson, ContentType.APPLICATION_JSON));
            HttpResponse response = httpClient.execute(httpHost, (HttpRequest)postLogin);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                String message = this.getMessage(response);
                this.log.info(message);
                throw new GoodDataAuthException(message);
            }
            String string = TokenUtils.extractSST(response);
            return string;
        }
        finally {
            postLogin.reset();
        }
    }

    private String getMessage(HttpResponse response) throws IOException {
        Header requestIdHeader = response.getFirstHeader(X_GDC_REQUEST_HEADER_NAME);
        String requestId = requestIdHeader != null ? requestIdHeader.getValue() : null;
        HttpEntity responseEntity = response.getEntity();
        String reason = responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity) : null;
        return String.format("Unable to login reason='%s'. Request tracking details httpStatus=%s requestId=%s", reason, response.getStatusLine().getStatusCode(), requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout(HttpClient httpClient, HttpHost httpHost, String url, String sst, String tt) throws IOException, GoodDataLogoutException {
        Validate.notNull((Object)httpClient, (String)"client can't be null", (Object[])new Object[0]);
        Validate.notNull((Object)httpHost, (String)"host can't be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)url, (String)"url can't be empty", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)sst, (String)"SST can't be empty", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)tt, (String)"TT can't be empty", (Object[])new Object[0]);
        this.log.debug("performing logout");
        HttpDelete request = new HttpDelete(url);
        try {
            request.setHeader("X-GDC-AuthSST", sst);
            request.setHeader("X-GDC-AuthTT", tt);
            HttpResponse response = httpClient.execute(httpHost, (HttpRequest)request);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 204) {
                throw new GoodDataLogoutException("Logout unsuccessful using http", statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
        }
        finally {
            request.reset();
        }
    }

    void setLogger(Logger log) {
        this.log = log;
    }
}

