/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.http.client;

import com.gooddata.http.client.GoodDataAuthException;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

class TokenUtils {
    TokenUtils() {
    }

    static String extractSST(HttpResponse response) {
        return TokenUtils.extractToken(response, "X-GDC-AuthSST");
    }

    static String extractTT(HttpResponse response) {
        return TokenUtils.extractToken(response, "X-GDC-AuthTT");
    }

    private static String extractToken(HttpResponse response, String headerName) {
        Validate.notNull((Object)response, (String)"response can't be null", (Object[])new Object[0]);
        Validate.notNull((Object)headerName, (String)"headerName can't be null", (Object[])new Object[0]);
        Header header = response.getFirstHeader(headerName);
        if (header == null) {
            throw new GoodDataAuthException("Unable to login. Response doesn't contain header " + headerName);
        }
        return header.getValue();
    }
}

