/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.accompanist.glide

import android.graphics.drawable.Drawable
import com.bumptech.glide.request.target.CustomTarget
import com.bumptech.glide.request.transition.Transition

/**
 * A [CustomTarget] which contains empty no-op implementations for the abstract functions.
 */
internal open class EmptyCustomTarget(
    width: Int,
    height: Int
) : CustomTarget<Drawable>(width, height) {
    open override fun onResourceReady(resource: Drawable, transition: Transition<in Drawable>?) = Unit
    open override fun onLoadCleared(resource: Drawable?) = Unit
}
