/*
 * Decompiled with CFR 0.152.
 */
package com.google.accompanist.insets;

import androidx.core.graphics.Insets;
import androidx.core.view.WindowInsetsAnimationCompat;
import androidx.core.view.WindowInsetsCompat;
import com.google.accompanist.insets.InsetsKt;
import com.google.accompanist.insets.MutableInsets;
import com.google.accompanist.insets.MutableWindowInsetsType;
import com.google.accompanist.insets.RootWindowInsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016J*\u0010\u000f\u001a\u00020\u0006*\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/google/accompanist/insets/InnerWindowInsetsAnimationCallback;", "Landroidx/core/view/WindowInsetsAnimationCompat$Callback;", "windowInsets", "Lcom/google/accompanist/insets/RootWindowInsets;", "(Lcom/google/accompanist/insets/RootWindowInsets;)V", "onEnd", "", "animation", "Landroidx/core/view/WindowInsetsAnimationCompat;", "onPrepare", "onProgress", "Landroidx/core/view/WindowInsetsCompat;", "platformInsets", "runningAnimations", "", "updateAnimation", "Lcom/google/accompanist/insets/MutableWindowInsetsType;", "type", "", "insets_release"})
@SourceDebugExtension(value={"SMAP\nWindowInsets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowInsets.kt\ncom/google/accompanist/insets/InnerWindowInsetsAnimationCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,555:1\n1747#2,3:556\n1#3:559\n*S KotlinDebug\n*F\n+ 1 WindowInsets.kt\ncom/google/accompanist/insets/InnerWindowInsetsAnimationCallback\n*L\n461#1:556,3\n*E\n"})
final class InnerWindowInsetsAnimationCallback
extends WindowInsetsAnimationCompat.Callback {
    @NotNull
    private final RootWindowInsets windowInsets;

    public InnerWindowInsetsAnimationCallback(@NotNull RootWindowInsets windowInsets) {
        Intrinsics.checkNotNullParameter((Object)windowInsets, (String)"windowInsets");
        super(0);
        this.windowInsets = windowInsets;
    }

    public void onPrepare(@NotNull WindowInsetsAnimationCompat animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        if ((animation.getTypeMask() & WindowInsetsCompat.Type.ime()) != 0) {
            this.windowInsets.getIme().onAnimationStart();
        }
        if ((animation.getTypeMask() & WindowInsetsCompat.Type.statusBars()) != 0) {
            this.windowInsets.getStatusBars().onAnimationStart();
        }
        if ((animation.getTypeMask() & WindowInsetsCompat.Type.navigationBars()) != 0) {
            this.windowInsets.getNavigationBars().onAnimationStart();
        }
        if ((animation.getTypeMask() & WindowInsetsCompat.Type.systemGestures()) != 0) {
            this.windowInsets.getSystemGestures().onAnimationStart();
        }
        if ((animation.getTypeMask() & WindowInsetsCompat.Type.displayCutout()) != 0) {
            this.windowInsets.getDisplayCutout().onAnimationStart();
        }
    }

    @NotNull
    public WindowInsetsCompat onProgress(@NotNull WindowInsetsCompat platformInsets, @NotNull List<WindowInsetsAnimationCompat> runningAnimations) {
        Intrinsics.checkNotNullParameter((Object)platformInsets, (String)"platformInsets");
        Intrinsics.checkNotNullParameter(runningAnimations, (String)"runningAnimations");
        this.updateAnimation(this.windowInsets.getIme(), platformInsets, runningAnimations, WindowInsetsCompat.Type.ime());
        this.updateAnimation(this.windowInsets.getStatusBars(), platformInsets, runningAnimations, WindowInsetsCompat.Type.statusBars());
        this.updateAnimation(this.windowInsets.getNavigationBars(), platformInsets, runningAnimations, WindowInsetsCompat.Type.navigationBars());
        this.updateAnimation(this.windowInsets.getSystemGestures(), platformInsets, runningAnimations, WindowInsetsCompat.Type.systemGestures());
        this.updateAnimation(this.windowInsets.getDisplayCutout(), platformInsets, runningAnimations, WindowInsetsCompat.Type.displayCutout());
        return platformInsets;
    }

    private final void updateAnimation(MutableWindowInsetsType $this$updateAnimation, WindowInsetsCompat platformInsets, List<WindowInsetsAnimationCompat> runningAnimations, int type) {
        boolean bl;
        block6: {
            Iterable $this$any$iv = runningAnimations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    WindowInsetsAnimationCompat it = (WindowInsetsAnimationCompat)element$iv;
                    boolean bl2 = false;
                    if (!((it.getTypeMask() | type) != 0)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            MutableInsets mutableInsets = $this$updateAnimation.getAnimatedInsets();
            Insets insets = platformInsets.getInsets(type);
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"platformInsets.getInsets(type)");
            InsetsKt.updateFrom(mutableInsets, insets);
            Iterable iterable = runningAnimations;
            MutableWindowInsetsType mutableWindowInsetsType = $this$updateAnimation;
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            WindowInsetsAnimationCompat it = (WindowInsetsAnimationCompat)iterator.next();
            boolean bl3 = false;
            float f = it.getFraction();
            while (iterator.hasNext()) {
                WindowInsetsAnimationCompat it2 = (WindowInsetsAnimationCompat)iterator.next();
                $i$a$-maxOf-InnerWindowInsetsAnimationCallback$updateAnimation$2 = false;
                float f2 = it2.getFraction();
                f = Math.max(f, f2);
            }
            float f3 = f;
            mutableWindowInsetsType.setAnimationFraction(f3);
        }
    }

    public void onEnd(@NotNull WindowInsetsAnimationCompat animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        if ((animation.getTypeMask() & WindowInsetsCompat.Type.ime()) != 0) {
            this.windowInsets.getIme().onAnimationEnd();
        }
        if ((animation.getTypeMask() & WindowInsetsCompat.Type.statusBars()) != 0) {
            this.windowInsets.getStatusBars().onAnimationEnd();
        }
        if ((animation.getTypeMask() & WindowInsetsCompat.Type.navigationBars()) != 0) {
            this.windowInsets.getNavigationBars().onAnimationEnd();
        }
        if ((animation.getTypeMask() & WindowInsetsCompat.Type.systemGestures()) != 0) {
            this.windowInsets.getSystemGestures().onAnimationEnd();
        }
        if ((animation.getTypeMask() & WindowInsetsCompat.Type.displayCutout()) != 0) {
            this.windowInsets.getDisplayCutout().onAnimationEnd();
        }
    }
}

