/*
 * Decompiled with CFR 0.152.
 */
package com.google.accompanist.insets;

import android.graphics.Insets;
import android.os.CancellationSignal;
import android.view.View;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimationControlListener;
import android.view.WindowInsetsAnimationController;
import android.view.WindowInsetsController;
import android.view.animation.Interpolator;
import androidx.annotation.RequiresApi;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.DynamicAnimationKt;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import com.google.accompanist.insets.SimpleImeAnimationController;
import com.google.accompanist.insets.SimpleImeAnimationControllerKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000e2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0016\b\u0002\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\u0019J/\u0010\u001a\u001a\u00020\u00132\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0016\b\u0002\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00172\b\b\u0002\u0010\u001e\u001a\u00020\u0017H\u0002J\u0006\u0010\u001f\u001a\u00020\u0013J\u0006\u0010 \u001a\u00020\u0013J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"J\u000e\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\"J\u0006\u0010&\u001a\u00020\u000eJ\u0006\u0010'\u001a\u00020\u000eJ\u0006\u0010(\u001a\u00020\u000eJ\u0010\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\fH\u0002J\b\u0010+\u001a\u00020\u0013H\u0002J=\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0016\u001a\u00020\u00172%\b\u0002\u0010\u0018\u001a\u001f\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(1\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012J&\u00102\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.2\u0016\b\u0002\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/google/accompanist/insets/SimpleImeAnimationController;", "", "()V", "animationControlListener", "Landroid/view/WindowInsetsAnimationControlListener;", "getAnimationControlListener", "()Landroid/view/WindowInsetsAnimationControlListener;", "animationControlListener$delegate", "Lkotlin/Lazy;", "currentSpringAnimation", "Landroidx/dynamicanimation/animation/SpringAnimation;", "insetsAnimationController", "Landroid/view/WindowInsetsAnimationController;", "isImeShownAtStart", "", "pendingRequestCancellationSignal", "Landroid/os/CancellationSignal;", "pendingRequestOnReady", "Lkotlin/Function1;", "", "animateImeToVisibility", "visible", "velocityY", "", "onFinished", "(ZLjava/lang/Float;Lkotlin/jvm/functions/Function1;)V", "animateToFinish", "(Ljava/lang/Float;Lkotlin/jvm/functions/Function1;)V", "calculateFlingDistance", "velocity", "friction", "cancel", "finish", "insetBy", "", "dy", "insetTo", "inset", "isInsetAnimationFinishing", "isInsetAnimationInProgress", "isInsetAnimationRequestPending", "onRequestReady", "controller", "reset", "startAndFling", "view", "Landroid/view/View;", "Lkotlin/ParameterName;", "name", "remainingVelocity", "startControlRequest", "insets_release"})
@RequiresApi(value=30)
public final class SimpleImeAnimationController {
    @Nullable
    private WindowInsetsAnimationController insetsAnimationController;
    @Nullable
    private CancellationSignal pendingRequestCancellationSignal;
    @Nullable
    private Function1<? super WindowInsetsAnimationController, Unit> pendingRequestOnReady;
    @NotNull
    private final Lazy animationControlListener$delegate = LazyKt.lazy((Function0)((Function0)new Function0<animationControlListener.1>(this){
        final /* synthetic */ SimpleImeAnimationController this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final animationControlListener.1 invoke() {
            return new WindowInsetsAnimationControlListener(this.this$0){
                final /* synthetic */ SimpleImeAnimationController this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onReady(@NotNull WindowInsetsAnimationController controller, int types) {
                    Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
                    SimpleImeAnimationController.access$onRequestReady(this.this$0, controller);
                }

                public void onFinished(@NotNull WindowInsetsAnimationController controller) {
                    Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
                    SimpleImeAnimationController.access$reset(this.this$0);
                }

                public void onCancelled(@Nullable WindowInsetsAnimationController controller) {
                    SimpleImeAnimationController.access$reset(this.this$0);
                }
            };
        }
    }));
    private boolean isImeShownAtStart;
    @Nullable
    private SpringAnimation currentSpringAnimation;

    private final WindowInsetsAnimationControlListener getAnimationControlListener() {
        Lazy lazy = this.animationControlListener$delegate;
        boolean bl = false;
        return (WindowInsetsAnimationControlListener)lazy.getValue();
    }

    public final void startControlRequest(@NotNull View view, @Nullable Function1<? super WindowInsetsAnimationController, Unit> onRequestReady) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        boolean bl = !this.isInsetAnimationInProgress();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Animation in progress. Can not start a new request to controlWindowInsetsAnimation()";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.isImeShownAtStart = view.getRootWindowInsets().isVisible(WindowInsets.Type.ime());
        this.pendingRequestCancellationSignal = new CancellationSignal();
        this.pendingRequestOnReady = onRequestReady;
        WindowInsetsController windowInsetsController = view.getWindowInsetsController();
        if (windowInsetsController != null) {
            windowInsetsController.controlWindowInsetsAnimation(WindowInsets.Type.ime(), -1L, (Interpolator)SimpleImeAnimationControllerKt.access$getLinearInterpolator$p(), this.pendingRequestCancellationSignal, this.getAnimationControlListener());
        }
    }

    public static /* synthetic */ void startControlRequest$default(SimpleImeAnimationController simpleImeAnimationController, View view, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        simpleImeAnimationController.startControlRequest(view, (Function1<? super WindowInsetsAnimationController, Unit>)function1);
    }

    public final void startAndFling(@NotNull View view, float velocityY, @Nullable Function1<? super Float, Unit> onFinished) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.startControlRequest(view, (Function1<? super WindowInsetsAnimationController, Unit>)((Function1)new Function1<WindowInsetsAnimationController, Unit>(this, velocityY, onFinished){
            final /* synthetic */ SimpleImeAnimationController this$0;
            final /* synthetic */ float $velocityY;
            final /* synthetic */ Function1<Float, Unit> $onFinished;
            {
                this.this$0 = $receiver;
                this.$velocityY = $velocityY;
                this.$onFinished = $onFinished;
                super(1);
            }

            public final void invoke(@NotNull WindowInsetsAnimationController it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.animateToFinish(Float.valueOf(this.$velocityY), this.$onFinished);
            }
        }));
    }

    public static /* synthetic */ void startAndFling$default(SimpleImeAnimationController simpleImeAnimationController, View view, float f, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        simpleImeAnimationController.startAndFling(view, f, (Function1<? super Float, Unit>)function1);
    }

    public final int insetBy(int dy) {
        WindowInsetsAnimationController windowInsetsAnimationController = this.insetsAnimationController;
        if (windowInsetsAnimationController == null) {
            throw new IllegalStateException("Current WindowInsetsAnimationController is null.This should only be called if isAnimationInProgress() returns true");
        }
        WindowInsetsAnimationController controller = windowInsetsAnimationController;
        return this.insetTo(controller.getCurrentInsets().bottom - dy);
    }

    public final int insetTo(int inset) {
        WindowInsetsAnimationController windowInsetsAnimationController = this.insetsAnimationController;
        if (windowInsetsAnimationController == null) {
            throw new IllegalStateException("Current WindowInsetsAnimationController is null.This should only be called if isAnimationInProgress() returns true");
        }
        WindowInsetsAnimationController controller = windowInsetsAnimationController;
        int hiddenBottom = controller.getHiddenStateInsets().bottom;
        int shownBottom = controller.getShownStateInsets().bottom;
        int startBottom = this.isImeShownAtStart ? shownBottom : hiddenBottom;
        int endBottom = this.isImeShownAtStart ? hiddenBottom : shownBottom;
        int coercedBottom = RangesKt.coerceIn((int)inset, (int)hiddenBottom, (int)shownBottom);
        int consumedDy = controller.getCurrentInsets().bottom - coercedBottom;
        controller.setInsetsAndAlpha(Insets.of((int)0, (int)0, (int)0, (int)coercedBottom), 1.0f, (float)(coercedBottom - startBottom) / (float)(endBottom - startBottom));
        return consumedDy;
    }

    public final boolean isInsetAnimationInProgress() {
        return this.insetsAnimationController != null;
    }

    public final boolean isInsetAnimationFinishing() {
        return this.currentSpringAnimation != null;
    }

    public final boolean isInsetAnimationRequestPending() {
        return this.pendingRequestCancellationSignal != null;
    }

    public final void cancel() {
        WindowInsetsAnimationController windowInsetsAnimationController = this.insetsAnimationController;
        if (windowInsetsAnimationController != null) {
            windowInsetsAnimationController.finish(this.isImeShownAtStart);
        }
        windowInsetsAnimationController = this.pendingRequestCancellationSignal;
        if (windowInsetsAnimationController != null) {
            windowInsetsAnimationController.cancel();
        }
        windowInsetsAnimationController = this.currentSpringAnimation;
        if (windowInsetsAnimationController != null) {
            windowInsetsAnimationController.cancel();
        }
        this.reset();
    }

    public final void finish() {
        WindowInsetsAnimationController controller = this.insetsAnimationController;
        if (controller == null) {
            CancellationSignal cancellationSignal = this.pendingRequestCancellationSignal;
            if (cancellationSignal != null) {
                cancellationSignal.cancel();
            }
            return;
        }
        int current = controller.getCurrentInsets().bottom;
        int shown = controller.getShownStateInsets().bottom;
        int hidden = controller.getHiddenStateInsets().bottom;
        int n = current;
        if (n == shown) {
            controller.finish(true);
        } else if (n == hidden) {
            controller.finish(false);
        } else if (controller.getCurrentFraction() >= 0.15f) {
            controller.finish(!this.isImeShownAtStart);
        } else {
            controller.finish(this.isImeShownAtStart);
        }
    }

    public final void animateToFinish(@Nullable Float velocityY, @Nullable Function1<? super Float, Unit> onFinished) {
        WindowInsetsAnimationController controller = this.insetsAnimationController;
        if (controller == null) {
            CancellationSignal cancellationSignal = this.pendingRequestCancellationSignal;
            if (cancellationSignal != null) {
                cancellationSignal.cancel();
            }
            return;
        }
        int current = controller.getCurrentInsets().bottom;
        int shown = controller.getShownStateInsets().bottom;
        int hidden = controller.getHiddenStateInsets().bottom;
        if (velocityY != null) {
            float flingDistance = SimpleImeAnimationController.calculateFlingDistance$default(this, velocityY.floatValue(), 0.0f, 2, null);
            int n = shown - hidden;
            boolean bl = false;
            if (flingDistance > (float)Math.abs(n)) {
                SimpleImeAnimationController.animateImeToVisibility$default(this, velocityY.floatValue() < 0.0f, velocityY, null, 4, null);
                return;
            }
        }
        if (current == shown) {
            controller.finish(true);
            Function1<? super Float, Unit> function1 = onFinished;
            if (function1 != null) {
                function1.invoke((Object)Float.valueOf(0.0f));
            }
        } else if (current == hidden) {
            controller.finish(false);
            Function1<? super Float, Unit> function1 = onFinished;
            if (function1 != null) {
                function1.invoke((Object)Float.valueOf(0.0f));
            }
        } else if (controller.getCurrentFraction() >= 0.15f) {
            SimpleImeAnimationController.animateImeToVisibility$default(this, !this.isImeShownAtStart, null, onFinished, 2, null);
        } else {
            SimpleImeAnimationController.animateImeToVisibility$default(this, this.isImeShownAtStart, null, onFinished, 2, null);
        }
    }

    public static /* synthetic */ void animateToFinish$default(SimpleImeAnimationController simpleImeAnimationController, Float f, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            f = null;
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        simpleImeAnimationController.animateToFinish(f, (Function1<? super Float, Unit>)function1);
    }

    private final void onRequestReady(WindowInsetsAnimationController controller) {
        this.pendingRequestCancellationSignal = null;
        this.insetsAnimationController = controller;
        Function1<? super WindowInsetsAnimationController, Unit> function1 = this.pendingRequestOnReady;
        if (function1 != null) {
            function1.invoke((Object)controller);
        }
        this.pendingRequestOnReady = null;
    }

    private final void reset() {
        this.insetsAnimationController = null;
        this.pendingRequestCancellationSignal = null;
        this.isImeShownAtStart = false;
        SpringAnimation springAnimation = this.currentSpringAnimation;
        if (springAnimation != null) {
            springAnimation.cancel();
        }
        this.currentSpringAnimation = null;
        this.pendingRequestOnReady = null;
    }

    /*
     * WARNING - void declaration
     */
    private final void animateImeToVisibility(boolean visible, Float velocityY, Function1<? super Float, Unit> onFinished) {
        void it;
        WindowInsetsAnimationController $this$animateImeToVisibility_u24lambda_u2d2;
        void $this$animateImeToVisibility_u24lambda_u2d1;
        void $this$withSpringForceProperties$iv;
        WindowInsetsAnimationController windowInsetsAnimationController = this.insetsAnimationController;
        if (windowInsetsAnimationController == null) {
            throw new IllegalStateException("Controller should not be null");
        }
        WindowInsetsAnimationController controller = windowInsetsAnimationController;
        windowInsetsAnimationController = DynamicAnimationKt.springAnimationOf((Function1)((Function1)new Function1<Float, Unit>(this){
            final /* synthetic */ SimpleImeAnimationController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(float it) {
                this.this$0.insetTo(MathKt.roundToInt((float)it));
            }
        }), (Function0)((Function0)new Function0<Float>(controller){
            final /* synthetic */ WindowInsetsAnimationController $controller;
            {
                this.$controller = $controller;
                super(0);
            }

            public final float invoke() {
                return this.$controller.getCurrentInsets().bottom;
            }
        }), (float)(visible ? (float)controller.getShownStateInsets().bottom : (float)controller.getHiddenStateInsets().bottom));
        boolean $i$f$withSpringForceProperties = false;
        if ($this$withSpringForceProperties$iv.getSpring() == null) {
            $this$withSpringForceProperties$iv.setSpring(new SpringForce());
        }
        SpringForce springForce = $this$withSpringForceProperties$iv.getSpring();
        Intrinsics.checkExpressionValueIsNotNull((Object)springForce, (String)"spring");
        SpringForce springForce2 = springForce;
        SimpleImeAnimationController simpleImeAnimationController = this;
        boolean $i$a$-withSpringForceProperties-SimpleImeAnimationController$animateImeToVisibility$42 = false;
        $this$animateImeToVisibility_u24lambda_u2d1.setDampingRatio(1.0f);
        $this$animateImeToVisibility_u24lambda_u2d1.setStiffness(1500.0f);
        Unit unit = Unit.INSTANCE;
        windowInsetsAnimationController = $this$withSpringForceProperties$iv;
        boolean bl = false;
        boolean bl2 = false;
        WindowInsetsAnimationController $i$a$-withSpringForceProperties-SimpleImeAnimationController$animateImeToVisibility$42 = windowInsetsAnimationController;
        boolean bl3 = false;
        if (velocityY != null) {
            $this$animateImeToVisibility_u24lambda_u2d2.setStartVelocity(velocityY.floatValue());
        }
        $this$animateImeToVisibility_u24lambda_u2d2.addEndListener(new DynamicAnimation.OnAnimationEndListener(this, onFinished){
            final /* synthetic */ SimpleImeAnimationController this$0;
            final /* synthetic */ Function1<Float, Unit> $onFinished;
            {
                this.this$0 = $receiver;
                this.$onFinished = $onFinished;
            }

            public final void onAnimationEnd(DynamicAnimation anim, boolean $noName_1, float $noName_2, float velocity) {
                if (Intrinsics.areEqual((Object)anim, (Object)SimpleImeAnimationController.access$getCurrentSpringAnimation$p(this.this$0))) {
                    SimpleImeAnimationController.access$setCurrentSpringAnimation$p(this.this$0, null);
                }
                this.this$0.finish();
                Function1<Float, Unit> function1 = this.$onFinished;
                if (function1 != null) {
                    function1.invoke((Object)Float.valueOf(velocity));
                }
            }
        });
        unit = Unit.INSTANCE;
        bl = false;
        bl2 = false;
        $this$animateImeToVisibility_u24lambda_u2d2 = windowInsetsAnimationController;
        boolean bl4 = false;
        it.start();
        unit = Unit.INSTANCE;
        simpleImeAnimationController.currentSpringAnimation = windowInsetsAnimationController;
    }

    static /* synthetic */ void animateImeToVisibility$default(SimpleImeAnimationController simpleImeAnimationController, boolean bl, Float f, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            f = null;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        simpleImeAnimationController.animateImeToVisibility(bl, f, (Function1<? super Float, Unit>)function1);
    }

    private final float calculateFlingDistance(float velocity, float friction) {
        return velocity / (friction * -4.2f);
    }

    static /* synthetic */ float calculateFlingDistance$default(SimpleImeAnimationController simpleImeAnimationController, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = 1.0f;
        }
        return simpleImeAnimationController.calculateFlingDistance(f, f2);
    }

    public static final /* synthetic */ SpringAnimation access$getCurrentSpringAnimation$p(SimpleImeAnimationController $this) {
        return $this.currentSpringAnimation;
    }

    public static final /* synthetic */ void access$setCurrentSpringAnimation$p(SimpleImeAnimationController $this, SpringAnimation springAnimation) {
        $this.currentSpringAnimation = springAnimation;
    }

    public static final /* synthetic */ void access$onRequestReady(SimpleImeAnimationController $this, WindowInsetsAnimationController controller) {
        $this.onRequestReady(controller);
    }

    public static final /* synthetic */ void access$reset(SimpleImeAnimationController $this) {
        $this.reset();
    }
}

