/*
 * Decompiled with CFR 0.152.
 */
package com.google.accompanist.permissions;

import android.app.Activity;
import android.content.Context;
import androidx.activity.result.ActivityResultLauncher;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.State;
import com.google.accompanist.permissions.ExperimentalPermissionsApi;
import com.google.accompanist.permissions.PermissionState;
import com.google.accompanist.permissions.PermissionStatus;
import com.google.accompanist.permissions.PermissionsUtilKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001a\u001a\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\r\u0010\u001d\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R+\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lcom/google/accompanist/permissions/MutablePermissionState;", "Lcom/google/accompanist/permissions/PermissionState;", "permission", "", "context", "Landroid/content/Context;", "activity", "Landroid/app/Activity;", "(Ljava/lang/String;Landroid/content/Context;Landroid/app/Activity;)V", "launcher", "Landroidx/activity/result/ActivityResultLauncher;", "getLauncher$permissions_release", "()Landroidx/activity/result/ActivityResultLauncher;", "setLauncher$permissions_release", "(Landroidx/activity/result/ActivityResultLauncher;)V", "getPermission", "()Ljava/lang/String;", "<set-?>", "Lcom/google/accompanist/permissions/PermissionStatus;", "status", "getStatus", "()Lcom/google/accompanist/permissions/PermissionStatus;", "setStatus", "(Lcom/google/accompanist/permissions/PermissionStatus;)V", "status$delegate", "Landroidx/compose/runtime/MutableState;", "getPermissionStatus", "launchPermissionRequest", "", "refreshPermissionStatus", "refreshPermissionStatus$permissions_release", "permissions_release"})
@ExperimentalPermissionsApi
@Stable
public final class MutablePermissionState
implements PermissionState {
    @NotNull
    private final String permission;
    @NotNull
    private final Context context;
    @NotNull
    private final Activity activity;
    @NotNull
    private final MutableState status$delegate;
    @Nullable
    private ActivityResultLauncher<String> launcher;

    public MutablePermissionState(@NotNull String permission, @NotNull Context context, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.permission = permission;
        this.context = context;
        this.activity = activity;
        this.status$delegate = SnapshotStateKt.mutableStateOf$default((Object)this.getPermissionStatus(), null, (int)2, null);
    }

    @Override
    @NotNull
    public String getPermission() {
        return this.permission;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PermissionStatus getStatus() {
        void $this$getValue$iv;
        State state = (State)this.status$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (PermissionStatus)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setStatus(@NotNull PermissionStatus permissionStatus) {
        void $this$setValue$iv;
        Intrinsics.checkNotNullParameter((Object)permissionStatus, (String)"<set-?>");
        MutableState mutableState = this.status$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)permissionStatus);
    }

    @Override
    public void launchPermissionRequest() {
        Unit unit;
        ActivityResultLauncher<String> activityResultLauncher = this.launcher;
        if (activityResultLauncher != null) {
            activityResultLauncher.launch((Object)this.getPermission());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("ActivityResultLauncher cannot be null");
        }
    }

    @Nullable
    public final ActivityResultLauncher<String> getLauncher$permissions_release() {
        return this.launcher;
    }

    public final void setLauncher$permissions_release(@Nullable ActivityResultLauncher<String> activityResultLauncher) {
        this.launcher = activityResultLauncher;
    }

    public final void refreshPermissionStatus$permissions_release() {
        this.setStatus(this.getPermissionStatus());
    }

    private final PermissionStatus getPermissionStatus() {
        boolean hasPermission = PermissionsUtilKt.checkPermission(this.context, this.getPermission());
        return hasPermission ? (PermissionStatus)PermissionStatus.Granted.INSTANCE : (PermissionStatus)new PermissionStatus.Denied(PermissionsUtilKt.shouldShowRationale(this.activity, this.getPermission()));
    }
}

