/*
 * Decompiled with CFR 0.152.
 */
package com.google.accompanist.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.DisposableEffectResult;
import androidx.compose.runtime.DisposableEffectScope;
import androidx.compose.runtime.EffectsKt;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.compose.LocalLifecycleOwnerKt;
import com.google.accompanist.permissions.ExperimentalPermissionsApi;
import com.google.accompanist.permissions.MutablePermissionState;
import com.google.accompanist.permissions.PermissionStatus;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u001f\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\u0010\u000f\u001a%\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\u0010\u0013\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0001*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0001*\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\"\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0000\u0010\u0005\"\u001e\u0010\u0006\u001a\u00020\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0004\u001a\u0004\b\b\u0010\u0005\u00a8\u0006\u001a"}, d2={"isGranted", "", "Lcom/google/accompanist/permissions/PermissionStatus;", "isGranted$annotations", "(Lcom/google/accompanist/permissions/PermissionStatus;)V", "(Lcom/google/accompanist/permissions/PermissionStatus;)Z", "shouldShowRationale", "getShouldShowRationale$annotations", "getShouldShowRationale", "PermissionLifecycleCheckerEffect", "", "permissionState", "Lcom/google/accompanist/permissions/MutablePermissionState;", "lifecycleEvent", "Landroidx/lifecycle/Lifecycle$Event;", "(Lcom/google/accompanist/permissions/MutablePermissionState;Landroidx/lifecycle/Lifecycle$Event;Landroidx/compose/runtime/Composer;II)V", "PermissionsLifecycleCheckerEffect", "permissions", "", "(Ljava/util/List;Landroidx/lifecycle/Lifecycle$Event;Landroidx/compose/runtime/Composer;II)V", "findActivity", "Landroid/app/Activity;", "Landroid/content/Context;", "checkPermission", "permission", "", "permissions_release"})
@SourceDebugExtension(value={"SMAP\nPermissionsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionsUtil.kt\ncom/google/accompanist/permissions/PermissionsUtilKt\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 CompositionLocal.kt\nandroidx/compose/runtime/CompositionLocal\n+ 4 Effects.kt\nandroidx/compose/runtime/DisposableEffectScope\n*L\n1#1,148:1\n1223#2,6:149\n1223#2,6:156\n1223#2,6:162\n1223#2,6:169\n77#3:155\n77#3:168\n64#4,5:175\n64#4,5:180\n*S KotlinDebug\n*F\n+ 1 PermissionsUtil.kt\ncom/google/accompanist/permissions/PermissionsUtilKt\n*L\n78#1:149,6\n90#1:156,6\n108#1:162,6\n122#1:169,6\n89#1:155\n121#1:168\n92#1:175,5\n124#1:180,5\n*E\n"})
public final class PermissionsUtilKt {
    public static final boolean isGranted(@NotNull PermissionStatus $this$isGranted) {
        Intrinsics.checkNotNullParameter((Object)$this$isGranted, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isGranted, (Object)PermissionStatus.Granted.INSTANCE);
    }

    @ExperimentalPermissionsApi
    public static /* synthetic */ void isGranted$annotations(PermissionStatus permissionStatus) {
    }

    public static final boolean getShouldShowRationale(@NotNull PermissionStatus $this$shouldShowRationale) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$shouldShowRationale, (String)"<this>");
        PermissionStatus permissionStatus = $this$shouldShowRationale;
        if (Intrinsics.areEqual((Object)permissionStatus, (Object)PermissionStatus.Granted.INSTANCE)) {
            bl = false;
        } else if (permissionStatus instanceof PermissionStatus.Denied) {
            bl = ((PermissionStatus.Denied)$this$shouldShowRationale).getShouldShowRationale();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @ExperimentalPermissionsApi
    public static /* synthetic */ void getShouldShowRationale$annotations(PermissionStatus permissionStatus) {
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalPermissionsApi
    @Composable
    public static final void PermissionLifecycleCheckerEffect(@NotNull MutablePermissionState permissionState, @Nullable Lifecycle.Event lifecycleEvent, @Nullable Composer $composer, int $changed, int n) {
        block15: {
            Intrinsics.checkNotNullParameter((Object)permissionState, (String)"permissionState");
            $composer = $composer.startRestartGroup(-1770945943);
            int $dirty = $changed;
            if ((n & 1) != 0) {
                $dirty |= 6;
            } else if (($changed & 6) == 0) {
                $dirty |= $composer.changed((Object)permissionState) ? 4 : 2;
            }
            if ((n & 2) != 0) {
                $dirty |= 0x30;
            } else if (($changed & 0x30) == 0) {
                $dirty |= $composer.changed((Object)lifecycleEvent) ? 32 : 16;
            }
            if (($dirty & 0x13) != 18 || !$composer.getSkipping()) {
                Object object;
                void $this$cache$iv;
                Lifecycle lifecycle;
                void this_$iv;
                Object object2;
                void invalid$iv;
                CompositionLocal $this$cache$iv2;
                if ((n & 2) != 0) {
                    lifecycleEvent = Lifecycle.Event.ON_RESUME;
                }
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)-1770945943, (int)$dirty, (int)-1, (String)"com.google.accompanist.permissions.PermissionLifecycleCheckerEffect (PermissionsUtil.kt:74)");
                }
                $composer.startReplaceGroup(-2101357749);
                Composer composer = $composer;
                boolean bl = ($dirty & 0xE) == 4;
                boolean $i$f$cache = false;
                Object it$iv = $this$cache$iv2.rememberedValue();
                boolean bl2 = false;
                if (invalid$iv != false || it$iv == Composer.Companion.getEmpty()) {
                    boolean bl3 = false;
                    LifecycleEventObserver value$iv = (arg_0, arg_1) -> PermissionsUtilKt.PermissionLifecycleCheckerEffect$lambda$1$lambda$0(lifecycleEvent, permissionState, arg_0, arg_1);
                    $this$cache$iv2.updateRememberedValue((Object)value$iv);
                    object2 = value$iv;
                } else {
                    object2 = it$iv;
                }
                LifecycleEventObserver lifecycleEventObserver = (LifecycleEventObserver)object2;
                $composer.endReplaceGroup();
                LifecycleEventObserver permissionCheckerObserver = lifecycleEventObserver;
                $this$cache$iv2 = (CompositionLocal)LocalLifecycleOwnerKt.getLocalLifecycleOwner();
                boolean $changed$iv22 = false;
                boolean $i$f$getCurrent = false;
                ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"CC:CompositionLocal.kt#9igjgp");
                it$iv = $composer.consume((CompositionLocal)this_$iv);
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                Lifecycle lifecycle2 = lifecycle = ((LifecycleOwner)it$iv).getLifecycle();
                LifecycleEventObserver lifecycleEventObserver2 = permissionCheckerObserver;
                $composer.startReplaceGroup(-2101338711);
                Composer $changed$iv22 = $composer;
                boolean invalid$iv2 = $composer.changedInstance((Object)lifecycle) | $composer.changedInstance((Object)permissionCheckerObserver);
                boolean $i$f$cache2 = false;
                Object it$iv2 = $this$cache$iv.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv2 || it$iv2 == Composer.Companion.getEmpty()) {
                    LifecycleEventObserver lifecycleEventObserver3 = lifecycleEventObserver2;
                    Lifecycle lifecycle3 = lifecycle2;
                    boolean bl4 = false;
                    Function1 function1 = arg_0 -> PermissionsUtilKt.PermissionLifecycleCheckerEffect$lambda$4$lambda$3(lifecycle, permissionCheckerObserver, arg_0);
                    lifecycle2 = lifecycle3;
                    lifecycleEventObserver2 = lifecycleEventObserver3;
                    Function1 value$iv = function1;
                    $this$cache$iv.updateRememberedValue((Object)value$iv);
                    object = value$iv;
                } else {
                    object = it$iv2;
                }
                composer = (Function1)object;
                $composer.endReplaceGroup();
                EffectsKt.DisposableEffect((Object)lifecycle2, (Object)lifecycleEventObserver2, (Function1)composer, (Composer)$composer, (int)0);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block15;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> PermissionsUtilKt.PermissionLifecycleCheckerEffect$lambda$5(permissionState, lifecycleEvent, $changed, n, arg_0, arg_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalPermissionsApi
    @Composable
    public static final void PermissionsLifecycleCheckerEffect(@NotNull List<MutablePermissionState> permissions, @Nullable Lifecycle.Event lifecycleEvent, @Nullable Composer $composer, int $changed, int n) {
        block15: {
            Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
            $composer = $composer.startRestartGroup(1533427666);
            int $dirty = $changed;
            if ((n & 1) != 0) {
                $dirty |= 6;
            } else if (($changed & 6) == 0) {
                $dirty |= $composer.changedInstance(permissions) ? 4 : 2;
            }
            if ((n & 2) != 0) {
                $dirty |= 0x30;
            } else if (($changed & 0x30) == 0) {
                $dirty |= $composer.changed((Object)lifecycleEvent) ? 32 : 16;
            }
            if (($dirty & 0x13) != 18 || !$composer.getSkipping()) {
                Object object;
                void $this$cache$iv;
                Lifecycle lifecycle;
                void this_$iv;
                Object object2;
                CompositionLocal $this$cache$iv2;
                if ((n & 2) != 0) {
                    lifecycleEvent = Lifecycle.Event.ON_RESUME;
                }
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)1533427666, (int)$dirty, (int)-1, (String)"com.google.accompanist.permissions.PermissionsLifecycleCheckerEffect (PermissionsUtil.kt:104)");
                }
                $composer.startReplaceGroup(-67706430);
                Composer composer = $composer;
                boolean invalid$iv = $composer.changed(permissions);
                boolean $i$f$cache = false;
                Object it$iv = $this$cache$iv2.rememberedValue();
                boolean bl = false;
                if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
                    boolean bl2 = false;
                    LifecycleEventObserver value$iv = (arg_0, arg_1) -> PermissionsUtilKt.PermissionsLifecycleCheckerEffect$lambda$7$lambda$6(lifecycleEvent, permissions, arg_0, arg_1);
                    $this$cache$iv2.updateRememberedValue((Object)value$iv);
                    object2 = value$iv;
                } else {
                    object2 = it$iv;
                }
                LifecycleEventObserver lifecycleEventObserver = (LifecycleEventObserver)object2;
                $composer.endReplaceGroup();
                LifecycleEventObserver permissionsCheckerObserver = lifecycleEventObserver;
                $this$cache$iv2 = (CompositionLocal)LocalLifecycleOwnerKt.getLocalLifecycleOwner();
                boolean $changed$iv22 = false;
                boolean $i$f$getCurrent = false;
                ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"CC:CompositionLocal.kt#9igjgp");
                it$iv = $composer.consume((CompositionLocal)this_$iv);
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                Lifecycle lifecycle2 = lifecycle = ((LifecycleOwner)it$iv).getLifecycle();
                LifecycleEventObserver lifecycleEventObserver2 = permissionsCheckerObserver;
                $composer.startReplaceGroup(-67685064);
                Composer $changed$iv22 = $composer;
                boolean invalid$iv2 = $composer.changedInstance((Object)lifecycle) | $composer.changedInstance((Object)permissionsCheckerObserver);
                boolean $i$f$cache2 = false;
                Object it$iv2 = $this$cache$iv.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv2 || it$iv2 == Composer.Companion.getEmpty()) {
                    LifecycleEventObserver lifecycleEventObserver3 = lifecycleEventObserver2;
                    Lifecycle lifecycle3 = lifecycle2;
                    boolean bl3 = false;
                    Function1 function1 = arg_0 -> PermissionsUtilKt.PermissionsLifecycleCheckerEffect$lambda$10$lambda$9(lifecycle, permissionsCheckerObserver, arg_0);
                    lifecycle2 = lifecycle3;
                    lifecycleEventObserver2 = lifecycleEventObserver3;
                    Function1 value$iv = function1;
                    $this$cache$iv.updateRememberedValue((Object)value$iv);
                    object = value$iv;
                } else {
                    object = it$iv2;
                }
                composer = (Function1)object;
                $composer.endReplaceGroup();
                EffectsKt.DisposableEffect((Object)lifecycle2, (Object)lifecycleEventObserver2, (Function1)composer, (Composer)$composer, (int)0);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block15;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> PermissionsUtilKt.PermissionsLifecycleCheckerEffect$lambda$11(permissions, lifecycleEvent, $changed, n, arg_0, arg_1));
        }
    }

    @NotNull
    public static final Activity findActivity(@NotNull Context $this$findActivity) {
        Intrinsics.checkNotNullParameter((Object)$this$findActivity, (String)"<this>");
        Context context = $this$findActivity;
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        throw new IllegalStateException("Permissions should be called in the context of an Activity");
    }

    public static final boolean checkPermission(@NotNull Context $this$checkPermission, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)$this$checkPermission, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return ContextCompat.checkSelfPermission((Context)$this$checkPermission, (String)permission) == 0;
    }

    public static final boolean shouldShowRationale(@NotNull Activity $this$shouldShowRationale, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldShowRationale, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)$this$shouldShowRationale, (String)permission);
    }

    private static final void PermissionLifecycleCheckerEffect$lambda$1$lambda$0(Lifecycle.Event $lifecycleEvent, MutablePermissionState $permissionState, LifecycleOwner lifecycleOwner, Lifecycle.Event event) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event == $lifecycleEvent && !Intrinsics.areEqual((Object)$permissionState.getStatus(), (Object)PermissionStatus.Granted.INSTANCE)) {
            $permissionState.refreshPermissionStatus$permissions_release();
        }
    }

    private static final DisposableEffectResult PermissionLifecycleCheckerEffect$lambda$4$lambda$3(Lifecycle $lifecycle, LifecycleEventObserver $permissionCheckerObserver, DisposableEffectScope $this$DisposableEffect) {
        Intrinsics.checkNotNullParameter((Object)$this$DisposableEffect, (String)"$this$DisposableEffect");
        $lifecycle.addObserver((LifecycleObserver)$permissionCheckerObserver);
        DisposableEffectScope this_$iv = $this$DisposableEffect;
        boolean $i$f$onDispose = false;
        return new DisposableEffectResult($lifecycle, $permissionCheckerObserver){
            final /* synthetic */ Lifecycle $lifecycle$inlined;
            final /* synthetic */ LifecycleEventObserver $permissionCheckerObserver$inlined;
            {
                this.$lifecycle$inlined = lifecycle;
                this.$permissionCheckerObserver$inlined = lifecycleEventObserver;
            }

            public void dispose() {
                boolean bl = false;
                this.$lifecycle$inlined.removeObserver((LifecycleObserver)this.$permissionCheckerObserver$inlined);
            }
        };
    }

    private static final Unit PermissionLifecycleCheckerEffect$lambda$5(MutablePermissionState $permissionState, Lifecycle.Event $lifecycleEvent, int $$changed, int $$default, Composer $composer, int $force) {
        PermissionsUtilKt.PermissionLifecycleCheckerEffect($permissionState, $lifecycleEvent, $composer, RecomposeScopeImplKt.updateChangedFlags((int)($$changed | 1)), $$default);
        return Unit.INSTANCE;
    }

    private static final void PermissionsLifecycleCheckerEffect$lambda$7$lambda$6(Lifecycle.Event $lifecycleEvent, List $permissions, LifecycleOwner lifecycleOwner, Lifecycle.Event event) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event == $lifecycleEvent) {
            for (MutablePermissionState permission : $permissions) {
                if (Intrinsics.areEqual((Object)permission.getStatus(), (Object)PermissionStatus.Granted.INSTANCE)) continue;
                permission.refreshPermissionStatus$permissions_release();
            }
        }
    }

    private static final DisposableEffectResult PermissionsLifecycleCheckerEffect$lambda$10$lambda$9(Lifecycle $lifecycle, LifecycleEventObserver $permissionsCheckerObserver, DisposableEffectScope $this$DisposableEffect) {
        Intrinsics.checkNotNullParameter((Object)$this$DisposableEffect, (String)"$this$DisposableEffect");
        $lifecycle.addObserver((LifecycleObserver)$permissionsCheckerObserver);
        DisposableEffectScope this_$iv = $this$DisposableEffect;
        boolean $i$f$onDispose = false;
        return new DisposableEffectResult($lifecycle, $permissionsCheckerObserver){
            final /* synthetic */ Lifecycle $lifecycle$inlined;
            final /* synthetic */ LifecycleEventObserver $permissionsCheckerObserver$inlined;
            {
                this.$lifecycle$inlined = lifecycle;
                this.$permissionsCheckerObserver$inlined = lifecycleEventObserver;
            }

            public void dispose() {
                boolean bl = false;
                this.$lifecycle$inlined.removeObserver((LifecycleObserver)this.$permissionsCheckerObserver$inlined);
            }
        };
    }

    private static final Unit PermissionsLifecycleCheckerEffect$lambda$11(List $permissions, Lifecycle.Event $lifecycleEvent, int $$changed, int $$default, Composer $composer, int $force) {
        PermissionsUtilKt.PermissionsLifecycleCheckerEffect($permissions, $lifecycleEvent, $composer, RecomposeScopeImplKt.updateChangedFlags((int)($$changed | 1)), $$default);
        return Unit.INSTANCE;
    }
}

