/*
 * Decompiled with CFR 0.152.
 */
package com.google.actions.api.test;

import com.google.actions.api.ActionRequest;
import com.google.actions.api.Capability;
import com.google.actions.api.impl.AogRequest;
import com.google.actions.api.impl.DialogflowRequest;
import com.google.api.services.actions_fulfillment.v2.model.AppRequest;
import com.google.api.services.actions_fulfillment.v2.model.Argument;
import com.google.api.services.actions_fulfillment.v2.model.Conversation;
import com.google.api.services.actions_fulfillment.v2.model.Date;
import com.google.api.services.actions_fulfillment.v2.model.DateTime;
import com.google.api.services.actions_fulfillment.v2.model.Device;
import com.google.api.services.actions_fulfillment.v2.model.Input;
import com.google.api.services.actions_fulfillment.v2.model.RawInput;
import com.google.api.services.actions_fulfillment.v2.model.Surface;
import com.google.api.services.actions_fulfillment.v2.model.TimeOfDay;
import com.google.api.services.actions_fulfillment.v2.model.User;
import com.google.api.services.actions_fulfillment.v2.model.UserProfile;
import com.google.api.services.dialogflow_fulfillment.v2.model.Intent;
import com.google.api.services.dialogflow_fulfillment.v2.model.OriginalDetectIntentRequest;
import com.google.api.services.dialogflow_fulfillment.v2.model.QueryResult;
import com.google.api.services.dialogflow_fulfillment.v2.model.WebhookRequest;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\u0018\u0000 62\u00020\u0001:\u00016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010 \u001a\u00020\u00002\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u001c\u0010\"\u001a\u00020\u00002\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\tJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\nJ\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\nJ\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\nJ\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\nJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0014J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\nJ\u000e\u0010/\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0014J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u000eJ\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0019J\u001a\u00104\u001a\u00020\u00002\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tJ\u000e\u00105\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/google/actions/api/test/MockRequestBuilder;", "", "()V", "appRequest", "Lcom/google/api/services/actions_fulfillment/v2/model/AppRequest;", "arguments", "", "Lcom/google/api/services/actions_fulfillment/v2/model/Argument;", "conversationData", "", "", "conversationId", "conversationType", "defaultUser", "Lcom/google/api/services/actions_fulfillment/v2/model/User;", "device", "Lcom/google/api/services/actions_fulfillment/v2/model/Device;", "inputType", "intent", "mediaOuput", "", "rawText", "screenOuput", "user", "userProfile", "Lcom/google/api/services/actions_fulfillment/v2/model/UserProfile;", "userStorage", "usesDialogflow", "webhookRequest", "Lcom/google/api/services/dialogflow_fulfillment/v2/model/WebhookRequest;", "build", "Lcom/google/actions/api/ActionRequest;", "setArguments", "args", "setConversationData", "data", "setConversationId", "id", "setConversationType", "type", "setDevice", "setInputType", "setIntent", "text", "setMediaOutput", "flag", "setRawText", "setScreenOuput", "setUser", "aUser", "setUserProfile", "aProfile", "setUserStorage", "setUsesDialogflow", "PreBuilt", "actions-on-google"})
public final class MockRequestBuilder {
    private final AppRequest appRequest = new AppRequest();
    private final WebhookRequest webhookRequest = new WebhookRequest();
    private final User defaultUser = new User();
    private boolean usesDialogflow = true;
    private String intent;
    private String rawText;
    private String inputType = "KEYBOARD";
    private List<Argument> arguments;
    private String conversationId = "1234";
    private String conversationType = "ACTIVE";
    private Map<String, ? extends Object> conversationData;
    private Map<String, ? extends Object> userStorage;
    private User user = this.defaultUser;
    private UserProfile userProfile;
    private boolean screenOuput = true;
    private boolean mediaOuput = true;
    private Device device;
    public static final PreBuilt PreBuilt = new PreBuilt(null);

    @NotNull
    public final MockRequestBuilder setIntent(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.intent = text;
        return this;
    }

    @NotNull
    public final MockRequestBuilder setUsesDialogflow(boolean flag) {
        this.usesDialogflow = flag;
        return this;
    }

    @NotNull
    public final MockRequestBuilder setRawText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.rawText = text;
        return this;
    }

    @NotNull
    public final MockRequestBuilder setInputType(@NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        this.inputType = type;
        return this;
    }

    @NotNull
    public final MockRequestBuilder setArguments(@NotNull List<Argument> args) {
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        this.arguments = args;
        return this;
    }

    @NotNull
    public final MockRequestBuilder setConversationId(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.conversationId = id;
        return this;
    }

    @NotNull
    public final MockRequestBuilder setConversationType(@NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        this.conversationType = type;
        return this;
    }

    @NotNull
    public final MockRequestBuilder setConversationData(@Nullable Map<String, ? extends Object> data) {
        this.conversationData = data;
        return this;
    }

    @NotNull
    public final MockRequestBuilder setUserStorage(@NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this.userStorage = data;
        return this;
    }

    @NotNull
    public final MockRequestBuilder setUser(@NotNull User aUser) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)aUser), (String)"aUser");
        this.user = aUser;
        return this;
    }

    @NotNull
    public final MockRequestBuilder setUserProfile(@NotNull UserProfile aProfile) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)aProfile), (String)"aProfile");
        this.userProfile = aProfile;
        return this;
    }

    @NotNull
    public final MockRequestBuilder setScreenOuput(boolean flag) {
        this.screenOuput = flag;
        return this;
    }

    @NotNull
    public final MockRequestBuilder setMediaOutput(boolean flag) {
        this.mediaOuput = flag;
        return this;
    }

    @NotNull
    public final MockRequestBuilder setDevice(@NotNull Device device) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)device), (String)"device");
        this.device = device;
        return this;
    }

    @NotNull
    public final ActionRequest build() {
        Gson gson = new Gson();
        if (this.userProfile != null) {
            this.user.setProfile(this.userProfile);
        }
        if (this.userStorage != null) {
            this.user.setUserStorage(gson.toJson(this.userStorage));
        }
        this.appRequest.setUser(this.user);
        Input input = new Input();
        input.setIntent(this.intent);
        if (this.arguments != null) {
            input.setArguments(this.arguments);
        }
        this.appRequest.setInputs(CollectionsKt.listOf((Object)((Object)input)));
        RawInput rawInput = new RawInput();
        rawInput.setQuery(this.rawText);
        rawInput.setInputType(this.inputType);
        Input input2 = this.appRequest.getInputs().get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)input2), (String)"appRequest.inputs[0]");
        input2.setRawInputs(CollectionsKt.listOf((Object)((Object)rawInput)));
        Conversation conversation = new Conversation();
        conversation.setConversationId(this.conversationId);
        conversation.setType(this.conversationType);
        if (this.conversationData != null && !this.usesDialogflow) {
            conversation.setConversationToken(gson.toJson(this.conversationData));
        }
        this.appRequest.setConversation(conversation);
        List capabilities = new ArrayList();
        com.google.api.services.actions_fulfillment.v2.model.Capability capability = new com.google.api.services.actions_fulfillment.v2.model.Capability().setName(Capability.AUDIO_OUTPUT.getValue());
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)capability), (String)"Capability().setName(\n  \u2026ility.AUDIO_OUTPUT.value)");
        capabilities.add(capability);
        com.google.api.services.actions_fulfillment.v2.model.Capability capability2 = new com.google.api.services.actions_fulfillment.v2.model.Capability().setName(Capability.WEB_BROWSER.getValue());
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)capability2), (String)"Capability().setName(\n  \u2026bility.WEB_BROWSER.value)");
        capabilities.add(capability2);
        if (this.screenOuput) {
            com.google.api.services.actions_fulfillment.v2.model.Capability capability3 = new com.google.api.services.actions_fulfillment.v2.model.Capability().setName(Capability.SCREEN_OUTPUT.getValue());
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)capability3), (String)"Capability().setName(\n  \u2026lity.SCREEN_OUTPUT.value)");
            capabilities.add(capability3);
        }
        if (this.mediaOuput) {
            com.google.api.services.actions_fulfillment.v2.model.Capability capability4 = new com.google.api.services.actions_fulfillment.v2.model.Capability().setName(Capability.MEDIA_RESPONSE_AUDIO.getValue());
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)capability4), (String)"Capability().setName(\n  \u2026DIA_RESPONSE_AUDIO.value)");
            capabilities.add(capability4);
        }
        Surface surface = new Surface();
        surface.setCapabilities(capabilities);
        this.appRequest.setSurface(surface);
        if (this.device != null) {
            this.appRequest.setDevice(this.device);
        }
        AogRequest aogRequest = new AogRequest(this.appRequest);
        if (this.usesDialogflow) {
            QueryResult queryResult = new QueryResult();
            Intent intentObj = new Intent();
            intentObj.setDisplayName(this.intent);
            queryResult.setIntent(intentObj);
            queryResult.setQueryText(this.rawText);
            this.webhookRequest.setQueryResult(queryResult);
            OriginalDetectIntentRequest wrappedRequest = new OriginalDetectIntentRequest();
            wrappedRequest.setSource("google");
            wrappedRequest.setVersion("2");
            wrappedRequest.setPayload((Map)((Object)this.appRequest));
            this.webhookRequest.setOriginalDetectIntentRequest(wrappedRequest);
            return new DialogflowRequest(this.webhookRequest, aogRequest);
        }
        return aogRequest;
    }

    public MockRequestBuilder() {
        this.defaultUser.setLastSeen("2018-05-24T19:03:47Z");
        this.defaultUser.setUserId("abcd");
        this.defaultUser.setLocale("en-US");
        this.defaultUser.setUserVerificationStatus("VERIFIED");
        this.webhookRequest.setSession("session-id");
    }

    @Nullable
    public static final /* synthetic */ String access$getIntent$p(MockRequestBuilder $this) {
        return $this.intent;
    }

    public static final /* synthetic */ boolean access$getUsesDialogflow$p(MockRequestBuilder $this) {
        return $this.usesDialogflow;
    }

    @Nullable
    public static final /* synthetic */ String access$getRawText$p(MockRequestBuilder $this) {
        return $this.rawText;
    }

    @Nullable
    public static final /* synthetic */ String access$getConversationType$p(MockRequestBuilder $this) {
        return $this.conversationType;
    }

    @Nullable
    public static final /* synthetic */ List access$getArguments$p(MockRequestBuilder $this) {
        return $this.arguments;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ$\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\f2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0012"}, d2={"Lcom/google/actions/api/test/MockRequestBuilder$PreBuilt;", "", "()V", "dateTime", "Lcom/google/actions/api/test/MockRequestBuilder;", "date", "Lcom/google/api/services/actions_fulfillment/v2/model/Date;", "time", "Lcom/google/api/services/actions_fulfillment/v2/model/TimeOfDay;", "intent", "", "usesDialogflow", "", "mediaPlaybackStatus", "status", "userConfirmation", "confirmation", "welcome", "actions-on-google"})
    public static final class PreBuilt {
        @NotNull
        public final MockRequestBuilder welcome(@NotNull String intent, boolean usesDialogflow) {
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            MockRequestBuilder rb = new MockRequestBuilder();
            rb.intent = intent;
            rb.usesDialogflow = usesDialogflow;
            rb.rawText = "talk to my app";
            rb.conversationType = "NEW";
            return rb;
        }

        @NotNull
        public static /* synthetic */ MockRequestBuilder welcome$default(PreBuilt preBuilt, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return preBuilt.welcome(string, bl);
        }

        @NotNull
        public final MockRequestBuilder userConfirmation(boolean confirmation, @NotNull String intent, boolean usesDialogflow) {
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            MockRequestBuilder rb = new MockRequestBuilder();
            rb.intent = intent;
            rb.usesDialogflow = usesDialogflow;
            rb.rawText = "yes";
            Argument arg = new Argument();
            arg.setName("CONFIRMATION");
            arg.setBoolValue(confirmation);
            rb.arguments = CollectionsKt.listOf((Object)((Object)arg));
            return rb;
        }

        @NotNull
        public static /* synthetic */ MockRequestBuilder userConfirmation$default(PreBuilt preBuilt, boolean bl, String string, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                string = "actions.intent.CONFIRMATION";
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return preBuilt.userConfirmation(bl, string, bl2);
        }

        @NotNull
        public final MockRequestBuilder dateTime(@NotNull Date date, @NotNull TimeOfDay time, @NotNull String intent, boolean usesDialogflow) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)date), (String)"date");
            Intrinsics.checkParameterIsNotNull((Object)((Object)time), (String)"time");
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            MockRequestBuilder rb = new MockRequestBuilder();
            rb.intent = intent;
            rb.usesDialogflow = usesDialogflow;
            rb.rawText = "5pm";
            Argument arg = new Argument();
            arg.setName("DATETIME");
            arg.setDatetimeValue(new DateTime().setDate(date).setTime(time));
            rb.arguments = CollectionsKt.listOf((Object)((Object)arg));
            return rb;
        }

        @NotNull
        public static /* synthetic */ MockRequestBuilder dateTime$default(PreBuilt preBuilt, Date date, TimeOfDay timeOfDay, String string, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                string = "actions.intent.DATETIME";
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            return preBuilt.dateTime(date, timeOfDay, string, bl);
        }

        @NotNull
        public final MockRequestBuilder mediaPlaybackStatus(@NotNull String status, @NotNull String intent, boolean usesDialogflow) {
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            MockRequestBuilder rb = new MockRequestBuilder();
            rb.intent = intent;
            rb.usesDialogflow = usesDialogflow;
            rb.rawText = "";
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("status", status);
            Argument arg = new Argument();
            arg.setName("MEDIA_STATUS");
            arg.setExtension((Map<String, Object>)map2);
            rb.arguments = CollectionsKt.listOf((Object)((Object)arg));
            return rb;
        }

        @NotNull
        public static /* synthetic */ MockRequestBuilder mediaPlaybackStatus$default(PreBuilt preBuilt, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = "FINISHED";
            }
            if ((n & 2) != 0) {
                string2 = "actions.intent.MEDIA_STATUS";
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            return preBuilt.mediaPlaybackStatus(string, string2, bl);
        }

        private PreBuilt() {
        }

        public /* synthetic */ PreBuilt(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

