/*
 * Decompiled with CFR 0.152.
 */
package com.google.actions.api.impl.io;

import com.google.actions.api.ActionContext;
import com.google.actions.api.ActionResponse;
import com.google.actions.api.impl.AogResponse;
import com.google.actions.api.impl.DialogflowResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.services.actions_fulfillment.v2.model.AppResponse;
import com.google.api.services.actions_fulfillment.v2.model.ExpectedInput;
import com.google.api.services.actions_fulfillment.v2.model.ExpectedIntent;
import com.google.api.services.actions_fulfillment.v2.model.FinalResponse;
import com.google.api.services.actions_fulfillment.v2.model.InputPrompt;
import com.google.api.services.actions_fulfillment.v2.model.RichResponse;
import com.google.api.services.actions_fulfillment.v2.model.RichResponseItem;
import com.google.api.services.actions_fulfillment.v2.model.SimpleResponse;
import com.google.api.services.actions_fulfillment.v2.model.StructuredResponse;
import com.google.api.services.dialogflow_fulfillment.v2.model.Context;
import com.google.api.services.dialogflow_fulfillment.v2.model.WebhookResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/google/actions/api/impl/io/ResponseSerializer;", "", "sessionId", "", "(Ljava/lang/String;)V", "checkSimpleResponseIsPresent", "", "aogResponse", "Lcom/google/actions/api/impl/AogResponse;", "getAsNamespaced", "name", "serializeAogResponse", "serializeDialogflowResponseV2", "dialogflowResponse", "Lcom/google/actions/api/impl/DialogflowResponse;", "setContext", "context", "Lcom/google/actions/api/ActionContext;", "webhookResponse", "Lcom/google/api/services/dialogflow_fulfillment/v2/model/WebhookResponse;", "toJsonV2", "response", "Lcom/google/actions/api/ActionResponse;", "Companion", "DFHelperIntent", "DialogflowGooglePayload", "actions-on-google"})
public final class ResponseSerializer {
    private final String sessionId;
    private static final boolean includeVersionMetadata = false;
    private static final Logger LOG;
    @NotNull
    private static final List<String> HELPER_INTENTS_REQUIRING_SIMPLE_RESPONSE;
    @Deprecated
    public static final Companion Companion;

    @NotNull
    public final String toJsonV2(@NotNull ActionResponse response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        ActionResponse actionResponse = response;
        if (actionResponse instanceof DialogflowResponse) {
            return this.serializeDialogflowResponseV2((DialogflowResponse)response);
        }
        if (actionResponse instanceof AogResponse) {
            return this.serializeAogResponse((AogResponse)response);
        }
        LOG.warn("Unable to serialize the response.");
        throw (Throwable)new Exception("Unable to serialize the response");
    }

    private final String serializeDialogflowResponseV2(DialogflowResponse dialogflowResponse) {
        HashMap hashMap;
        String string;
        Map map2;
        Gson gson = new GsonBuilder().create();
        AogResponse googlePayload = dialogflowResponse.getGooglePayload$actions_on_google();
        WebhookResponse webhookResponse = dialogflowResponse.getWebhookResponse();
        Map<String, Object> conversationData = dialogflowResponse.getConversationData$actions_on_google();
        List<ActionContext> contexts = dialogflowResponse.getContexts$actions_on_google();
        if (googlePayload != null) {
            DialogflowGooglePayload aogPayload = new DialogflowGooglePayload(googlePayload);
            HashMap map3 = new HashMap();
            map2 = map3;
            string = "google";
            hashMap = aogPayload;
            map2.put(string, hashMap);
            webhookResponse.setPayload(map3);
        }
        if (conversationData != null) {
            ActionContext context = new ActionContext("_actions_on_google", 99);
            HashMap paramsMap = new HashMap();
            map2 = paramsMap;
            string = "data";
            String string2 = gson.toJson(conversationData);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"gson.toJson(conversationData)");
            hashMap = string2;
            map2.put(string, hashMap);
            context.setParameters(paramsMap);
            this.setContext(context, webhookResponse);
        }
        List<ActionContext> list = contexts;
        if (list != null) {
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                ActionContext it = (ActionContext)element$iv;
                this.setContext(it, webhookResponse);
            }
        }
        Map webhookResponseMap = MapsKt.toMutableMap((Map)((Map)((Object)webhookResponse)));
        if (includeVersionMetadata) {
            HashMap metadata = new HashMap();
            map2 = metadata;
            string = "google_library";
            hashMap = Companion.getLibraryMetadata();
            map2.put(string, hashMap);
            map2 = webhookResponseMap;
            string = "metadata";
            hashMap = metadata;
            map2.put(string, hashMap);
        }
        String string3 = gson.toJson((Object)webhookResponseMap);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"gson.toJson(webhookResponseMap)");
        return string3;
    }

    private final void setContext(ActionContext context, WebhookResponse webhookResponse) {
        block6: {
            block5: {
                Context ctx;
                Context context2;
                List<Context> list = webhookResponse.getOutputContexts();
                if (list != null) {
                    Object v2;
                    block4: {
                        Iterable iterable;
                        Iterable iterable2 = iterable = (Iterable)list;
                        for (Object t : iterable2) {
                            Context it;
                            Context context3 = it = (Context)((Object)t);
                            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)context3), (String)"it");
                            if (!Intrinsics.areEqual((Object)context3.getName(), (Object)context.getName())) continue;
                            v2 = t;
                            break block4;
                        }
                        v2 = null;
                    }
                    context2 = v2;
                } else {
                    context2 = ctx = null;
                }
                if (ctx == null) break block5;
                ctx.setLifespanCount(context.getLifespan());
                ctx.setParameters(context.getParameters());
                break block6;
            }
            if (webhookResponse.getOutputContexts() == null) {
                webhookResponse.setOutputContexts(new ArrayList());
            }
            Context dfContext = new Context();
            dfContext.setName(this.getAsNamespaced(context.getName()));
            dfContext.setLifespanCount(context.getLifespan());
            dfContext.setParameters(context.getParameters());
            List<Context> list = webhookResponse.getOutputContexts();
            if (list == null) break block6;
            list.add(dfContext);
        }
    }

    private final String getAsNamespaced(String name) {
        String namespace = this.sessionId + "/contexts/";
        if (StringsKt.startsWith$default((String)name, (String)namespace, (boolean)false, (int)2, null)) {
            return name;
        }
        return namespace + name;
    }

    private final String serializeAogResponse(AogResponse aogResponse) throws Exception {
        aogResponse.prepareAppResponse$actions_on_google();
        this.checkSimpleResponseIsPresent(aogResponse);
        AppResponse appResponse = aogResponse.getAppResponse();
        if (appResponse == null) {
            Intrinsics.throwNpe();
        }
        Map appResponseMap = MapsKt.toMutableMap((Map)((Map)((Object)appResponse)));
        if (includeVersionMetadata) {
            HashMap<String, String> map2 = new HashMap<String, String>();
            Map map3 = map2;
            String string = "GoogleLibraryInfo";
            Map<String, String> map4 = Companion.getLibraryMetadata();
            map3.put(string, map4);
            map3 = appResponseMap;
            string = "ResponseMetadata";
            map4 = map2;
            map3.put(string, map4);
        }
        String string = new Gson().toJson((Object)appResponseMap);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Gson().toJson(appResponseMap)");
        return string;
    }

    private final void checkSimpleResponseIsPresent(AogResponse aogResponse) throws Exception {
        boolean hasSimpleResponse;
        boolean requireSimpleResponse;
        block12: {
            int numSuggestions;
            Object object;
            RichResponse richResponse;
            List<ExpectedIntent> helperIntents;
            AppResponse appResponse = aogResponse.getAppResponse();
            if (appResponse == null) {
                return;
            }
            AppResponse appResponse2 = appResponse;
            requireSimpleResponse = false;
            hasSimpleResponse = false;
            Object object2 = appResponse2.getExpectedInputs();
            List<ExpectedIntent> list = object2 != null && (object2 = object2.get(0)) != null ? ((ExpectedInput)((Object)object2)).getPossibleIntents() : (helperIntents = null);
            if (helperIntents != null) {
                Iterator<ExpectedIntent> iterator = helperIntents.iterator();
                while (iterator.hasNext()) {
                    ExpectedIntent helperIntent;
                    ExpectedIntent expectedIntent = helperIntent = iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)expectedIntent), (String)"helperIntent");
                    if (!HELPER_INTENTS_REQUIRING_SIMPLE_RESPONSE.contains(expectedIntent.getIntent())) continue;
                    requireSimpleResponse = true;
                }
            }
            if (appResponse2.getExpectUserResponse() != null) {
                Object object3 = appResponse2.getExpectedInputs();
                richResponse = object3 != null && (object3 = object3.get(0)) != null && (object3 = ((ExpectedInput)((Object)object3)).getInputPrompt()) != null ? ((InputPrompt)((Object)object3)).getRichInitialPrompt() : null;
            } else {
                FinalResponse finalResponse = appResponse2.getFinalResponse();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)finalResponse), (String)"appResponse.finalResponse");
                richResponse = finalResponse.getRichResponse();
            }
            int n = (object = richResponse) != null && (object = ((RichResponse)((Object)object)).getSuggestions()) != null ? object.size() : (numSuggestions = 0);
            if (numSuggestions > 0) {
                requireSimpleResponse = true;
            }
            RichResponse richResponse2 = richResponse;
            if ((richResponse2 != null ? richResponse2.getLinkOutSuggestion() : null) != null) {
                requireSimpleResponse = true;
            }
            RichResponse richResponse3 = richResponse;
            if ((richResponse3 != null ? richResponse3.getItems() : null) == null) break block12;
            Iterator<RichResponseItem> iterator = richResponse.getItems().iterator();
            while (iterator.hasNext()) {
                RichResponseItem item;
                block14: {
                    block13: {
                        RichResponseItem richResponseItem = item = iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)richResponseItem), (String)"item");
                        if (richResponseItem.getBasicCard() != null || item.getCarouselBrowse() != null || item.getTableCard() != null || item.getMediaResponse() != null) break block13;
                        StructuredResponse structuredResponse = item.getStructuredResponse();
                        if ((structuredResponse != null ? structuredResponse.getOrderUpdate() : null) == null) break block14;
                    }
                    requireSimpleResponse = true;
                }
                if (item.getSimpleResponse() == null) continue;
                hasSimpleResponse = true;
            }
        }
        if (requireSimpleResponse && !hasSimpleResponse) {
            throw (Throwable)new Exception("A simple response is required in addition to this type of response");
        }
    }

    public ResponseSerializer(@Nullable String sessionId) {
        this.sessionId = sessionId;
    }

    public /* synthetic */ ResponseSerializer(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    public ResponseSerializer() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger((String)ResponseSerializer.class.getName());
        HELPER_INTENTS_REQUIRING_SIMPLE_RESPONSE = CollectionsKt.listOf((Object)"actions.intent.OPTION");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR$\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\b\u0018\u00010\u001dR\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lcom/google/actions/api/impl/io/ResponseSerializer$DialogflowGooglePayload;", "", "aogResponse", "Lcom/google/actions/api/impl/AogResponse;", "(Lcom/google/actions/api/impl/io/ResponseSerializer;Lcom/google/actions/api/impl/AogResponse;)V", "expectUserResponse", "", "getExpectUserResponse$actions_on_google", "()Z", "setExpectUserResponse$actions_on_google", "(Z)V", "isSsml", "isSsml$actions_on_google", "setSsml$actions_on_google", "noInputPrompts", "", "Lcom/google/api/services/actions_fulfillment/v2/model/SimpleResponse;", "getNoInputPrompts$actions_on_google", "()[Lcom/google/api/services/actions_fulfillment/v2/model/SimpleResponse;", "setNoInputPrompts$actions_on_google", "([Lcom/google/api/services/actions_fulfillment/v2/model/SimpleResponse;)V", "[Lcom/google/api/services/actions_fulfillment/v2/model/SimpleResponse;", "richResponse", "Lcom/google/api/services/actions_fulfillment/v2/model/RichResponse;", "getRichResponse$actions_on_google", "()Lcom/google/api/services/actions_fulfillment/v2/model/RichResponse;", "setRichResponse$actions_on_google", "(Lcom/google/api/services/actions_fulfillment/v2/model/RichResponse;)V", "systemIntent", "Lcom/google/actions/api/impl/io/ResponseSerializer$DFHelperIntent;", "Lcom/google/actions/api/impl/io/ResponseSerializer;", "getSystemIntent$actions_on_google", "()Lcom/google/actions/api/impl/io/ResponseSerializer$DFHelperIntent;", "setSystemIntent$actions_on_google", "(Lcom/google/actions/api/impl/io/ResponseSerializer$DFHelperIntent;)V", "userStorage", "", "getUserStorage$actions_on_google", "()Ljava/lang/String;", "setUserStorage$actions_on_google", "(Ljava/lang/String;)V", "actions-on-google"})
    private final class DialogflowGooglePayload {
        private boolean expectUserResponse;
        @Nullable
        private RichResponse richResponse;
        @Nullable
        private SimpleResponse[] noInputPrompts;
        private boolean isSsml;
        @Nullable
        private DFHelperIntent systemIntent;
        @Nullable
        private String userStorage;

        public final boolean getExpectUserResponse$actions_on_google() {
            return this.expectUserResponse;
        }

        public final void setExpectUserResponse$actions_on_google(boolean bl) {
            this.expectUserResponse = bl;
        }

        @Nullable
        public final RichResponse getRichResponse$actions_on_google() {
            return this.richResponse;
        }

        public final void setRichResponse$actions_on_google(@Nullable RichResponse richResponse) {
            this.richResponse = richResponse;
        }

        @Nullable
        public final SimpleResponse[] getNoInputPrompts$actions_on_google() {
            return this.noInputPrompts;
        }

        public final void setNoInputPrompts$actions_on_google(@Nullable SimpleResponse[] simpleResponseArray) {
            this.noInputPrompts = simpleResponseArray;
        }

        public final boolean isSsml$actions_on_google() {
            return this.isSsml;
        }

        public final void setSsml$actions_on_google(boolean bl) {
            this.isSsml = bl;
        }

        @Nullable
        public final DFHelperIntent getSystemIntent$actions_on_google() {
            return this.systemIntent;
        }

        public final void setSystemIntent$actions_on_google(@Nullable DFHelperIntent dFHelperIntent) {
            this.systemIntent = dFHelperIntent;
        }

        @Nullable
        public final String getUserStorage$actions_on_google() {
            return this.userStorage;
        }

        public final void setUserStorage$actions_on_google(@Nullable String string) {
            this.userStorage = string;
        }

        public DialogflowGooglePayload(AogResponse aogResponse) {
            Map<String, Object> userStorage;
            Collection expectedIntent;
            Intrinsics.checkParameterIsNotNull((Object)aogResponse, (String)"aogResponse");
            this.expectUserResponse = aogResponse.getExpectUserResponse();
            if (aogResponse.getAppResponse() != null) {
                ResponseSerializer.this.checkSimpleResponseIsPresent(aogResponse);
                AppResponse appResponse = aogResponse.getAppResponse();
                if (this.expectUserResponse) {
                    Object object = appResponse;
                    this.richResponse = object != null && (object = object.getExpectedInputs()) != null && (object = (ExpectedInput)((Object)object.get(0))) != null && (object = ((ExpectedInput)((Object)object)).getInputPrompt()) != null ? ((InputPrompt)((Object)object)).getRichInitialPrompt() : null;
                    Object object2 = appResponse;
                    Object object3 = object2 != null && (object2 = object2.getExpectedInputs()) != null && (object2 = (ExpectedInput)((Object)object2.get(0))) != null && (object2 = ((ExpectedInput)((Object)object2)).getPossibleIntents()) != null ? (ExpectedIntent)((Object)object2.get(0)) : (expectedIntent = null);
                    if (expectedIntent != null) {
                        DFHelperIntent dFHelperIntent = new DFHelperIntent();
                        String string = ((ExpectedIntent)((Object)expectedIntent)).getIntent();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expectedIntent.intent");
                        DFHelperIntent dFHelperIntent2 = dFHelperIntent.setIntent(string);
                        Map<String, Object> map2 = ((ExpectedIntent)((Object)expectedIntent)).getInputValueData();
                        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"expectedIntent.inputValueData");
                        this.systemIntent = dFHelperIntent2.setData(map2);
                    }
                } else {
                    GenericJson genericJson = appResponse;
                    this.richResponse = genericJson != null && (genericJson = genericJson.getFinalResponse()) != null ? genericJson.getRichResponse() : null;
                }
            } else {
                this.richResponse = aogResponse.getRichResponse();
                List<ExpectedIntent> helperIntents = aogResponse.getHelperIntents$actions_on_google();
                if (helperIntents != null && !(expectedIntent = (Collection)helperIntents).isEmpty()) {
                    ExpectedIntent aogHelperIntent = helperIntents.get(0);
                    DFHelperIntent dFHelperIntent = new DFHelperIntent();
                    String string = aogHelperIntent.getIntent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aogHelperIntent.intent");
                    DFHelperIntent dFHelperIntent3 = dFHelperIntent.setIntent(string);
                    Map<String, Object> map3 = aogHelperIntent.getInputValueData();
                    Intrinsics.checkExpressionValueIsNotNull(map3, (String)"aogHelperIntent.inputValueData");
                    this.systemIntent = dFHelperIntent3.setData(map3);
                }
            }
            if ((userStorage = aogResponse.getUserStorage$actions_on_google()) != null) {
                HashMap dataMap = new HashMap();
                Map map4 = dataMap;
                String string = "data";
                Map<String, Object> map5 = userStorage;
                map4.put(string, map5);
                this.userStorage = new Gson().toJson(dataMap);
            }
            this.isSsml = false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004J\u0006\u0010\u0010\u001a\u00020\nJ\u001a\u0010\u0011\u001a\u00060\u0000R\u00020\u00122\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004J\u0012\u0010\u0013\u001a\u00060\u0000R\u00020\u00122\u0006\u0010\t\u001a\u00020\nR\"\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/google/actions/api/impl/io/ResponseSerializer$DFHelperIntent;", "", "(Lcom/google/actions/api/impl/io/ResponseSerializer;)V", "data", "", "getData$actions_on_google", "()Ljava/util/Map;", "setData$actions_on_google", "(Ljava/util/Map;)V", "intent", "", "getIntent$actions_on_google", "()Ljava/lang/String;", "setIntent$actions_on_google", "(Ljava/lang/String;)V", "getData", "getIntent", "setData", "Lcom/google/actions/api/impl/io/ResponseSerializer;", "setIntent", "actions-on-google"})
    private final class DFHelperIntent {
        @NotNull
        private String intent = "";
        @NotNull
        private Map<?, ?> data = new HashMap();

        @NotNull
        public final String getIntent$actions_on_google() {
            return this.intent;
        }

        public final void setIntent$actions_on_google(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.intent = string;
        }

        @NotNull
        public final Map<?, ?> getData$actions_on_google() {
            return this.data;
        }

        public final void setData$actions_on_google(@NotNull Map<?, ?> map2) {
            Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
            this.data = map2;
        }

        @NotNull
        public final String getIntent() {
            return this.intent;
        }

        @NotNull
        public final DFHelperIntent setIntent(@NotNull String intent) {
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            this.intent = intent;
            return this;
        }

        @NotNull
        public final Map<?, ?> getData() {
            return this.data;
        }

        @NotNull
        public final DFHelperIntent setData(@NotNull Map<?, ?> data) {
            Intrinsics.checkParameterIsNotNull(data, (String)"data");
            this.data = data;
            return this;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0012R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/google/actions/api/impl/io/ResponseSerializer$Companion;", "", "()V", "HELPER_INTENTS_REQUIRING_SIMPLE_RESPONSE", "", "", "getHELPER_INTENTS_REQUIRING_SIMPLE_RESPONSE", "()Ljava/util/List;", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "includeVersionMetadata", "", "getIncludeVersionMetadata", "()Z", "getLibraryMetadata", "", "actions-on-google"})
    private static final class Companion {
        public final boolean getIncludeVersionMetadata() {
            return includeVersionMetadata;
        }

        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final Map<String, String> getLibraryMetadata() {
            ResourceBundle metadataProperties = ResourceBundle.getBundle("metadata");
            HashMap map2 = new HashMap();
            Map map3 = map2;
            String string = "name";
            String string2 = "actions";
            map3.put(string, string2);
            map3 = map2;
            string = "language";
            string2 = "java";
            map3.put(string, string2);
            map3 = map2;
            string = "version";
            String string3 = metadataProperties.getString("version");
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"metadataProperties.getString(\"version\")");
            string2 = string3;
            map3.put(string, string2);
            return map2;
        }

        @NotNull
        public final List<String> getHELPER_INTENTS_REQUIRING_SIMPLE_RESPONSE() {
            return HELPER_INTENTS_REQUIRING_SIMPLE_RESPONSE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

