/*
 * Decompiled with CFR 0.152.
 */
package com.google.actions.api;

import com.google.actions.api.ActionRequest;
import com.google.actions.api.ActionResponse;
import com.google.actions.api.App;
import com.google.actions.api.DefaultApp;
import com.google.actions.api.ForIntent;
import com.google.actions.api.response.ResponseBuilder;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0010\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000bH&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH&J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0002J*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u0010\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0016J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00102\u0006\u0010\u000e\u001a\u00020\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/google/actions/api/DefaultApp;", "Lcom/google/actions/api/App;", "()V", "errorMsg_badReturnValue", "", "getErrorMsg_badReturnValue", "()Ljava/lang/String;", "createRequest", "Lcom/google/actions/api/ActionRequest;", "inputJson", "headers", "", "getResponseBuilder", "Lcom/google/actions/api/response/ResponseBuilder;", "request", "handleError", "Ljava/util/concurrent/CompletableFuture;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "handleRequest", "routeRequest", "Lcom/google/actions/api/ActionResponse;", "Companion", "actions-on-google"})
public abstract class DefaultApp
implements App {
    @NotNull
    private final String errorMsg_badReturnValue = "The return value of an intent handler must be ActionResponse or CompletableFuture<ActionResponse>";
    private static final Logger LOG;
    @Deprecated
    public static final Companion Companion;

    @NotNull
    public final String getErrorMsg_badReturnValue() {
        return this.errorMsg_badReturnValue;
    }

    @NotNull
    public abstract ActionRequest createRequest(@NotNull String var1, @Nullable Map<?, ?> var2);

    @NotNull
    public abstract ResponseBuilder getResponseBuilder(@NotNull ActionRequest var1);

    @Override
    @NotNull
    public CompletableFuture<String> handleRequest(@Nullable String inputJson, @Nullable Map<?, ?> headers) {
        CompletableFuture<ActionResponse> future;
        CharSequence charSequence;
        if (inputJson == null || (charSequence = (CharSequence)inputJson).length() == 0) {
            return this.handleError("Invalid or empty JSON");
        }
        try {
            ActionRequest request = this.createRequest(inputJson, headers);
            future = this.routeRequest(request);
        }
        catch (Exception e) {
            return this.handleError(e);
        }
        CompletionStage completionStage = ((CompletableFuture)future.thenApply((Function)handleRequest.1.INSTANCE)).exceptionally((Function)handleRequest.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"future\n                .\u2026le -> throwable.message }");
        return completionStage;
    }

    @NotNull
    public final CompletableFuture<ActionResponse> routeRequest(@NotNull ActionRequest request) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        String intent = request.getIntent();
        Class<ForIntent> forIntentType = ForIntent.class;
        for (Method method : this.getClass().getDeclaredMethods()) {
            CompletableFuture completableFuture;
            ForIntent forIntent;
            if (!method.isAnnotationPresent(forIntentType)) continue;
            ForIntent annotation = method.getAnnotation(forIntentType);
            if (annotation == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.actions.api.ForIntent");
            }
            if (!Intrinsics.areEqual((Object)forIntent.value(), (Object)intent)) continue;
            Object result = method.invoke((Object)this, request);
            if (result instanceof ActionResponse) {
                CompletableFuture completableFuture2 = CompletableFuture.completedFuture(result);
                completableFuture = completableFuture2;
                Intrinsics.checkExpressionValueIsNotNull(completableFuture2, (String)"CompletableFuture.completedFuture(result)");
            } else if (result instanceof CompletableFuture) {
                completableFuture = (CompletableFuture)result;
            } else {
                LOG.warn(this.errorMsg_badReturnValue);
                throw (Throwable)new Exception(this.errorMsg_badReturnValue);
            }
            return completableFuture;
        }
        LOG.warn("Intent handler not found: {}", (Object)intent);
        throw (Throwable)new Exception("Intent handler not found - " + intent);
    }

    @NotNull
    public final CompletableFuture<String> handleError(@NotNull Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        exception.printStackTrace();
        return this.handleError(exception.getMessage());
    }

    private final CompletableFuture<String> handleError(String message) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        future.completeExceptionally(new Exception(message));
        return future;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger((String)DefaultApp.class.getName());
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/actions/api/DefaultApp$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "actions-on-google"})
    private static final class Companion {
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

