/*
 * Decompiled with CFR 0.152.
 */
package com.google.actions.api.smarthome;

import com.google.actions.api.App;
import com.google.actions.api.smarthome.DisconnectRequest;
import com.google.actions.api.smarthome.ExecuteRequest;
import com.google.actions.api.smarthome.ExecuteResponse;
import com.google.actions.api.smarthome.QueryRequest;
import com.google.actions.api.smarthome.QueryResponse;
import com.google.actions.api.smarthome.SmartHomeApp;
import com.google.actions.api.smarthome.SmartHomeRequest;
import com.google.actions.api.smarthome.SmartHomeResponse;
import com.google.actions.api.smarthome.SyncRequest;
import com.google.actions.api.smarthome.SyncResponse;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.home.graph.v1.HomeGraphApiServiceGrpc;
import com.google.home.graph.v1.HomeGraphApiServiceProto;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.auth.MoreCallCredentials;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0002J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0002J*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0010\u0010\u0019\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u001aH\u0016J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0010\u0010\u0019\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u001aH&J\"\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020!2\u0010\u0010\u0019\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u001aH&J\"\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020$2\u0010\u0010\u0019\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u001aH&J\"\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020'2\u0010\u0010\u0019\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u001aH&J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020*J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0007J\"\u0010.\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\r2\u0010\u0010\u0019\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u001aH\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0005\u00a8\u0006/"}, d2={"Lcom/google/actions/api/smarthome/SmartHomeApp;", "Lcom/google/actions/api/App;", "()V", "credentials", "Lcom/google/auth/oauth2/GoogleCredentials;", "(Lcom/google/auth/oauth2/GoogleCredentials;)V", "fileName", "", "(Ljava/lang/String;)V", "getCredentials", "()Lcom/google/auth/oauth2/GoogleCredentials;", "setCredentials", "createRequest", "Lcom/google/actions/api/smarthome/SmartHomeRequest;", "inputJson", "getAsJson", "response", "Lcom/google/actions/api/smarthome/SmartHomeResponse;", "handleError", "Ljava/util/concurrent/CompletableFuture;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "handleRequest", "headers", "", "onDisconnect", "", "request", "Lcom/google/actions/api/smarthome/DisconnectRequest;", "onExecute", "Lcom/google/actions/api/smarthome/ExecuteResponse;", "Lcom/google/actions/api/smarthome/ExecuteRequest;", "onQuery", "Lcom/google/actions/api/smarthome/QueryResponse;", "Lcom/google/actions/api/smarthome/QueryRequest;", "onSync", "Lcom/google/actions/api/smarthome/SyncResponse;", "Lcom/google/actions/api/smarthome/SyncRequest;", "reportState", "Lcom/google/home/graph/v1/HomeGraphApiServiceProto$ReportStateAndNotificationResponse;", "Lcom/google/home/graph/v1/HomeGraphApiServiceProto$ReportStateAndNotificationRequest;", "requestSync", "Lcom/google/home/graph/v1/HomeGraphApiServiceProto$RequestSyncDevicesResponse;", "agentUserId", "routeRequest", "actions-on-google"})
public abstract class SmartHomeApp
implements App {
    @Nullable
    private GoogleCredentials credentials;

    @Nullable
    public final GoogleCredentials getCredentials() {
        return this.credentials;
    }

    public final void setCredentials(@Nullable GoogleCredentials googleCredentials) {
        this.credentials = googleCredentials;
    }

    @NotNull
    public final SmartHomeRequest createRequest(@NotNull String inputJson) {
        Intrinsics.checkParameterIsNotNull((Object)inputJson, (String)"inputJson");
        return SmartHomeRequest.Companion.create(inputJson);
    }

    @NotNull
    public abstract SyncResponse onSync(@NotNull SyncRequest var1, @Nullable Map<?, ?> var2);

    @NotNull
    public abstract QueryResponse onQuery(@NotNull QueryRequest var1, @Nullable Map<?, ?> var2);

    @NotNull
    public abstract ExecuteResponse onExecute(@NotNull ExecuteRequest var1, @Nullable Map<?, ?> var2);

    public abstract void onDisconnect(@NotNull DisconnectRequest var1, @Nullable Map<?, ?> var2);

    @NotNull
    public final HomeGraphApiServiceProto.RequestSyncDevicesResponse requestSync(@NotNull String agentUserId) {
        Intrinsics.checkParameterIsNotNull((Object)agentUserId, (String)"agentUserId");
        if (this.credentials == null) {
            throw (Throwable)new IllegalArgumentException("You must pass credentials in the app constructor");
        }
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)"homegraph.googleapis.com").build();
        HomeGraphApiServiceGrpc.HomeGraphApiServiceBlockingStub blockingStub = (HomeGraphApiServiceGrpc.HomeGraphApiServiceBlockingStub)HomeGraphApiServiceGrpc.newBlockingStub((Channel)channel).withCallCredentials(MoreCallCredentials.from((Credentials)((Credentials)this.credentials)));
        HomeGraphApiServiceProto.RequestSyncDevicesRequest request = HomeGraphApiServiceProto.RequestSyncDevicesRequest.newBuilder().setAgentUserId(agentUserId).build();
        HomeGraphApiServiceProto.RequestSyncDevicesResponse requestSyncDevicesResponse = blockingStub.requestSyncDevices(request);
        Intrinsics.checkExpressionValueIsNotNull((Object)requestSyncDevicesResponse, (String)"blockingStub.requestSyncDevices(request)");
        return requestSyncDevicesResponse;
    }

    @NotNull
    public final HomeGraphApiServiceProto.ReportStateAndNotificationResponse reportState(@NotNull HomeGraphApiServiceProto.ReportStateAndNotificationRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        if (this.credentials == null) {
            throw (Throwable)new IllegalArgumentException("You must pass credentials in the app constructor");
        }
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)"homegraph.googleapis.com").build();
        HomeGraphApiServiceGrpc.HomeGraphApiServiceBlockingStub blockingStub = (HomeGraphApiServiceGrpc.HomeGraphApiServiceBlockingStub)HomeGraphApiServiceGrpc.newBlockingStub((Channel)channel).withCallCredentials(MoreCallCredentials.from((Credentials)((Credentials)this.credentials)));
        HomeGraphApiServiceProto.ReportStateAndNotificationResponse reportStateAndNotificationResponse = blockingStub.reportStateAndNotification(request);
        Intrinsics.checkExpressionValueIsNotNull((Object)reportStateAndNotificationResponse, (String)"blockingStub.reportStateAndNotification(request)");
        return reportStateAndNotificationResponse;
    }

    @Override
    @NotNull
    public CompletableFuture<String> handleRequest(@Nullable String inputJson, @Nullable Map<?, ?> headers) {
        Object object;
        if (inputJson == null || (object = (CharSequence)inputJson).length() == 0) {
            return this.handleError("Invalid or empty JSON");
        }
        try {
            SmartHomeRequest request = this.createRequest(inputJson);
            SmartHomeResponse response = this.routeRequest(request, headers);
            CompletableFuture<SmartHomeResponse> future = new CompletableFuture<SmartHomeResponse>();
            future.complete(response);
            CompletionStage completionStage = ((CompletableFuture)future.thenApply(new Function<T, U>(this){
                final /* synthetic */ SmartHomeApp this$0;

                @NotNull
                public final String apply(SmartHomeResponse it) {
                    SmartHomeResponse smartHomeResponse = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)smartHomeResponse, (String)"it");
                    return SmartHomeApp.access$getAsJson(this.this$0, smartHomeResponse);
                }
                {
                    this.this$0 = smartHomeApp;
                }
            })).exceptionally((Function)handleRequest.2.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"future.thenApply { this.\u2026le -> throwable.message }");
            object = completionStage;
        }
        catch (Exception e) {
            object = this.handleError(e);
        }
        return object;
    }

    private final SmartHomeResponse routeRequest(SmartHomeRequest request, Map<?, ?> headers) throws Exception {
        Class<?> clazz = request.getClass();
        if (Intrinsics.areEqual(clazz, SyncRequest.class)) {
            SmartHomeRequest smartHomeRequest = request;
            if (smartHomeRequest == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.actions.api.smarthome.SyncRequest");
            }
            return this.onSync((SyncRequest)smartHomeRequest, headers);
        }
        if (Intrinsics.areEqual(clazz, QueryRequest.class)) {
            SmartHomeRequest smartHomeRequest = request;
            if (smartHomeRequest == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.actions.api.smarthome.QueryRequest");
            }
            return this.onQuery((QueryRequest)smartHomeRequest, headers);
        }
        if (Intrinsics.areEqual(clazz, ExecuteRequest.class)) {
            SmartHomeRequest smartHomeRequest = request;
            if (smartHomeRequest == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.actions.api.smarthome.ExecuteRequest");
            }
            return this.onExecute((ExecuteRequest)smartHomeRequest, headers);
        }
        if (Intrinsics.areEqual(clazz, DisconnectRequest.class)) {
            SmartHomeRequest smartHomeRequest = request;
            if (smartHomeRequest == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.actions.api.smarthome.DisconnectRequest");
            }
            this.onDisconnect((DisconnectRequest)smartHomeRequest, headers);
            return new SmartHomeResponse();
        }
        throw (Throwable)new Exception("Intent handler not found - " + request.getInputs()[0].getIntent());
    }

    private final CompletableFuture<String> handleError(Exception exception) {
        exception.printStackTrace();
        return this.handleError(exception.getMessage());
    }

    private final CompletableFuture<String> handleError(String message) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        future.completeExceptionally(new Exception(message));
        return future;
    }

    private final String getAsJson(SmartHomeResponse response) {
        String string = response.build().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.build().toString()");
        return string;
    }

    public SmartHomeApp() {
    }

    public SmartHomeApp(@NotNull GoogleCredentials credentials) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        this.credentials = credentials;
    }

    public SmartHomeApp(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        FileInputStream stream = new FileInputStream("key.json");
        this.credentials = GoogleCredentials.fromStream((InputStream)stream);
    }

    @NotNull
    public static final /* synthetic */ String access$getAsJson(SmartHomeApp $this, @NotNull SmartHomeResponse response) {
        return $this.getAsJson(response);
    }
}

