/*
 * Decompiled with CFR 0.152.
 */
package com.google.actions.api.smarthome;

import com.google.actions.api.smarthome.DisconnectRequest;
import com.google.actions.api.smarthome.ExecuteRequest;
import com.google.actions.api.smarthome.QueryRequest;
import com.google.actions.api.smarthome.SyncRequest;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086.\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/google/actions/api/smarthome/SmartHomeRequest;", "", "()V", "inputs", "", "Lcom/google/actions/api/smarthome/SmartHomeRequest$RequestInputs;", "getInputs", "()[Lcom/google/actions/api/smarthome/SmartHomeRequest$RequestInputs;", "setInputs", "([Lcom/google/actions/api/smarthome/SmartHomeRequest$RequestInputs;)V", "[Lcom/google/actions/api/smarthome/SmartHomeRequest$RequestInputs;", "requestId", "", "getRequestId", "()Ljava/lang/String;", "setRequestId", "(Ljava/lang/String;)V", "Companion", "RequestInputs", "actions-on-google"})
public class SmartHomeRequest {
    @NotNull
    public String requestId;
    @NotNull
    public RequestInputs[] inputs;
    private static final String SYNC_INTENT = "action.devices.SYNC";
    private static final String QUERY_INTENT = "action.devices.QUERY";
    private static final String EXEC_INTENT = "action.devices.EXECUTE";
    private static final String DISCON_INTENT = "action.devices.DISCONNECT";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getRequestId() {
        String string = this.requestId;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"requestId");
        }
        return string;
    }

    public final void setRequestId(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.requestId = string;
    }

    @NotNull
    public final RequestInputs[] getInputs() {
        if (this.inputs == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputs");
        }
        return this.inputs;
    }

    public final void setInputs(@NotNull RequestInputs[] requestInputsArray) {
        Intrinsics.checkParameterIsNotNull((Object)requestInputsArray, (String)"<set-?>");
        this.inputs = requestInputsArray;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/google/actions/api/smarthome/SmartHomeRequest$RequestInputs;", "", "()V", "intent", "", "getIntent", "()Ljava/lang/String;", "setIntent", "(Ljava/lang/String;)V", "actions-on-google"})
    public static class RequestInputs {
        @NotNull
        public String intent;

        @NotNull
        public final String getIntent() {
            String string = this.intent;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"intent");
            }
            return string;
        }

        public final void setIntent(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.intent = string;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/google/actions/api/smarthome/SmartHomeRequest$Companion;", "", "()V", "DISCON_INTENT", "", "EXEC_INTENT", "QUERY_INTENT", "SYNC_INTENT", "create", "Lcom/google/actions/api/smarthome/SmartHomeRequest;", "inputJson", "actions-on-google"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SmartHomeRequest create(@NotNull String inputJson) {
            String intent;
            Intrinsics.checkParameterIsNotNull((Object)inputJson, (String)"inputJson");
            JSONObject json = new JSONObject(inputJson);
            String requestId = json.getString("requestId");
            JSONArray inputs = json.getJSONArray("inputs");
            JSONObject request = inputs.getJSONObject(0);
            String string = intent = request.getString("intent");
            if (string != null) {
                switch (string) {
                    case "action.devices.SYNC": {
                        SyncRequest syncRequest = new SyncRequest();
                        String string2 = requestId;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"requestId");
                        syncRequest.setRequestId(string2);
                        syncRequest.setInputs(new RequestInputs[]{new SyncRequest.Inputs()});
                        syncRequest.getInputs()[0].setIntent(intent);
                        return syncRequest;
                    }
                    case "action.devices.QUERY": {
                        QueryRequest queryRequest = new QueryRequest();
                        String string3 = requestId;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"requestId");
                        queryRequest.setRequestId(string3);
                        queryRequest.setInputs(new RequestInputs[]{new QueryRequest.Inputs()});
                        queryRequest.getInputs()[0].setIntent(intent);
                        RequestInputs requestInputs = queryRequest.getInputs()[0];
                        if (requestInputs == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.google.actions.api.smarthome.QueryRequest.Inputs");
                        }
                        ((QueryRequest.Inputs)requestInputs).setPayload(new QueryRequest.Inputs.Payload());
                        ArrayList<QueryRequest.Inputs.Payload.Device> devicesList = new ArrayList<QueryRequest.Inputs.Payload.Device>();
                        JSONArray devicesJsonArray = json.getJSONArray("inputs").getJSONObject(0).getJSONObject("payload").getJSONArray("devices");
                        int n = 0;
                        int n2 = devicesJsonArray.length();
                        while (n < n2) {
                            void i;
                            JSONObject deviceJson = devicesJsonArray.getJSONObject((int)i);
                            QueryRequest.Inputs.Payload.Device deviceObject = new QueryRequest.Inputs.Payload.Device();
                            String string4 = deviceJson.getString("id");
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"deviceJson.getString(\"id\")");
                            deviceObject.setId(string4);
                            if (deviceJson.has("customData")) {
                                deviceObject.setCustomData(deviceJson.getJSONObject("customData").toMap());
                            }
                            devicesList.add(deviceObject);
                            ++i;
                        }
                        QueryRequest.Inputs.Payload.Device[] array = new QueryRequest.Inputs.Payload.Device[devicesList.size()];
                        RequestInputs requestInputs2 = queryRequest.getInputs()[0];
                        if (requestInputs2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.google.actions.api.smarthome.QueryRequest.Inputs");
                        }
                        QueryRequest.Inputs.Payload payload = ((QueryRequest.Inputs)requestInputs2).getPayload();
                        QueryRequest.Inputs.Payload.Device[] deviceArray = devicesList.toArray(array);
                        Intrinsics.checkExpressionValueIsNotNull((Object)deviceArray, (String)"devicesList.toArray(array)");
                        payload.setDevices(deviceArray);
                        return queryRequest;
                    }
                    case "action.devices.EXECUTE": {
                        ExecuteRequest executeRequest = new ExecuteRequest();
                        String string5 = requestId;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"requestId");
                        executeRequest.setRequestId(string5);
                        executeRequest.setInputs(new RequestInputs[]{new ExecuteRequest.Inputs()});
                        executeRequest.getInputs()[0].setIntent(intent);
                        RequestInputs requestInputs = executeRequest.getInputs()[0];
                        if (requestInputs == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.google.actions.api.smarthome.ExecuteRequest.Inputs");
                        }
                        ((ExecuteRequest.Inputs)requestInputs).setPayload(new ExecuteRequest.Inputs.Payload());
                        ArrayList<ExecuteRequest.Inputs.Payload.Commands> commandsList = new ArrayList<ExecuteRequest.Inputs.Payload.Commands>();
                        JSONArray commandsJsonArray = json.getJSONArray("inputs").getJSONObject(0).getJSONObject("payload").getJSONArray("commands");
                        int array = 0;
                        int n = commandsJsonArray.length();
                        while (array < n) {
                            void i;
                            ArrayList<ExecuteRequest.Inputs.Payload.Commands.Devices> devicesList = new ArrayList<ExecuteRequest.Inputs.Payload.Commands.Devices>();
                            JSONArray devicesJsonArray = commandsJsonArray.getJSONObject((int)i).getJSONArray("devices");
                            int n3 = 0;
                            int n4 = devicesJsonArray.length();
                            while (n3 < n4) {
                                void j;
                                JSONObject deviceJson = devicesJsonArray.getJSONObject((int)j);
                                ExecuteRequest.Inputs.Payload.Commands.Devices deviceObject = new ExecuteRequest.Inputs.Payload.Commands.Devices();
                                String string6 = deviceJson.getString("id");
                                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"deviceJson.getString(\"id\")");
                                deviceObject.setId(string6);
                                if (deviceJson.has("customData")) {
                                    deviceObject.setCustomData(deviceJson.getJSONObject("customData").toMap());
                                }
                                devicesList.add(deviceObject);
                                ++j;
                            }
                            ArrayList<ExecuteRequest.Inputs.Payload.Commands.Execution> executionsList = new ArrayList<ExecuteRequest.Inputs.Payload.Commands.Execution>();
                            JSONArray executionsJsonArray = commandsJsonArray.getJSONObject((int)i).getJSONArray("execution");
                            int deviceJson = 0;
                            int deviceObject = executionsJsonArray.length();
                            while (deviceJson < deviceObject) {
                                void j;
                                JSONObject executionJson = executionsJsonArray.getJSONObject((int)j);
                                ExecuteRequest.Inputs.Payload.Commands.Execution executionObject = new ExecuteRequest.Inputs.Payload.Commands.Execution();
                                String string7 = executionJson.getString("command");
                                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"executionJson.getString(\"command\")");
                                executionObject.setCommand(string7);
                                JSONObject jSONObject = executionJson.getJSONObject("params");
                                executionObject.setParams(jSONObject != null ? jSONObject.toMap() : null);
                                JSONObject jSONObject2 = executionJson.optJSONObject("challenge");
                                executionObject.setChallenge(jSONObject2 != null ? jSONObject2.toMap() : null);
                                executionsList.add(executionObject);
                                ++j;
                            }
                            ExecuteRequest.Inputs.Payload.Commands command = new ExecuteRequest.Inputs.Payload.Commands();
                            ExecuteRequest.Inputs.Payload.Commands.Devices[] devicesArray = new ExecuteRequest.Inputs.Payload.Commands.Devices[devicesList.size()];
                            ExecuteRequest.Inputs.Payload.Commands.Devices[] devicesArray2 = devicesList.toArray(devicesArray);
                            Intrinsics.checkExpressionValueIsNotNull((Object)devicesArray2, (String)"devicesList.toArray(devicesArray)");
                            command.setDevices(devicesArray2);
                            ExecuteRequest.Inputs.Payload.Commands.Execution[] executionArray = new ExecuteRequest.Inputs.Payload.Commands.Execution[executionsList.size()];
                            ExecuteRequest.Inputs.Payload.Commands.Execution[] executionArray2 = executionsList.toArray(executionArray);
                            Intrinsics.checkExpressionValueIsNotNull((Object)executionArray2, (String)"executionsList.toArray(executionArray)");
                            command.setExecution(executionArray2);
                            commandsList.add(command);
                            ++i;
                        }
                        ExecuteRequest.Inputs.Payload.Commands[] commandsArray = new ExecuteRequest.Inputs.Payload.Commands[commandsList.size()];
                        RequestInputs requestInputs3 = executeRequest.getInputs()[0];
                        if (requestInputs3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.google.actions.api.smarthome.ExecuteRequest.Inputs");
                        }
                        ExecuteRequest.Inputs.Payload payload = ((ExecuteRequest.Inputs)requestInputs3).getPayload();
                        ExecuteRequest.Inputs.Payload.Commands[] commandsArray2 = commandsList.toArray(commandsArray);
                        Intrinsics.checkExpressionValueIsNotNull((Object)commandsArray2, (String)"commandsList.toArray(commandsArray)");
                        payload.setCommands(commandsArray2);
                        return executeRequest;
                    }
                    case "action.devices.DISCONNECT": {
                        DisconnectRequest disconnectRequest = new DisconnectRequest();
                        String string8 = requestId;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"requestId");
                        disconnectRequest.setRequestId(string8);
                        disconnectRequest.setInputs(new RequestInputs[]{new DisconnectRequest.Inputs()});
                        disconnectRequest.getInputs()[0].setIntent(intent);
                        return disconnectRequest;
                    }
                }
            }
            throw (Throwable)new IllegalArgumentException("Unable to process request");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

