/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.adk.web.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * DTO for POST /apps/{appName}/eval_sets/{evalSetId}/add-session requests. Contains information to
 * associate a session with an evaluation set.
 */
public class AddSessionToEvalSetRequest {
  @JsonProperty("evalId")
  public String evalId;

  @JsonProperty("sessionId")
  public String sessionId;

  @JsonProperty("userId")
  public String userId;

  public AddSessionToEvalSetRequest() {}

  public String getEvalId() {
    return evalId;
  }

  public String getSessionId() {
    return sessionId;
  }

  public String getUserId() {
    return userId;
  }
}
