/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web.controller;

import com.google.adk.web.dto.AddSessionToEvalSetRequest;
import com.google.adk.web.dto.RunEvalRequest;
import com.google.adk.web.dto.RunEvalResult;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EvaluationController {
    private static final Logger log = LoggerFactory.getLogger(EvaluationController.class);

    @PostMapping(value={"/apps/{appName}/eval_sets/{evalSetId}"})
    public ResponseEntity<Object> createEvalSet(@PathVariable String appName, @PathVariable String evalSetId) {
        log.warn("Endpoint /apps/{}/eval_sets/{} (POST) is not implemented", (Object)appName, (Object)evalSetId);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED).body(Collections.singletonMap("message", "Eval set creation not implemented"));
    }

    @GetMapping(value={"/apps/{appName}/eval_sets"})
    public List<String> listEvalSets(@PathVariable String appName) {
        log.warn("Endpoint /apps/{}/eval_sets (GET) is not implemented", (Object)appName);
        return Collections.emptyList();
    }

    @PostMapping(value={"/apps/{appName}/eval_sets/{evalSetId}/add-session"})
    public ResponseEntity<Object> addSessionToEvalSet(@PathVariable String appName, @PathVariable String evalSetId, @RequestBody AddSessionToEvalSetRequest req) {
        log.warn("Endpoint /apps/{}/eval_sets/{}/add-session is not implemented. Request details: evalId={}, sessionId={}, userId={}", new Object[]{appName, evalSetId, req.getEvalId(), req.getSessionId(), req.getUserId()});
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED).body(Collections.singletonMap("message", "Adding session to eval set not implemented"));
    }

    @GetMapping(value={"/apps/{appName}/eval_sets/{evalSetId}/evals"})
    public List<String> listEvalsInEvalSet(@PathVariable String appName, @PathVariable String evalSetId) {
        log.warn("Endpoint /apps/{}/eval_sets/{}/evals is not implemented", (Object)appName, (Object)evalSetId);
        return Collections.emptyList();
    }

    @PostMapping(value={"/apps/{appName}/eval_sets/{evalSetId}/run-eval"})
    public List<RunEvalResult> runEval(@PathVariable String appName, @PathVariable String evalSetId, @RequestBody RunEvalRequest req) {
        log.warn("Endpoint /apps/{}/eval_sets/{}/run-eval is not implemented. Request details: evalIds={}, evalMetrics={}", new Object[]{appName, evalSetId, req.getEvalIds(), req.getEvalMetrics()});
        return Collections.emptyList();
    }

    @GetMapping(value={"/apps/{appName}/eval_results/{evalResultId}"})
    public ResponseEntity<Object> getEvalResult(@PathVariable String appName, @PathVariable String evalResultId) {
        log.warn("Endpoint /apps/{}/eval_results/{} (GET) is not implemented", (Object)appName, (Object)evalResultId);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED).body(Collections.singletonMap("message", "Get evaluation result not implemented"));
    }

    @GetMapping(value={"/apps/{appName}/eval_results"})
    public List<String> listEvalResults(@PathVariable String appName) {
        log.warn("Endpoint /apps/{}/eval_results (GET) is not implemented", (Object)appName);
        return Collections.emptyList();
    }
}

