/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.Telemetry;
import com.google.adk.agents.CallbackContext;
import com.google.adk.agents.Callbacks;
import com.google.adk.agents.InvocationContext;
import com.google.adk.events.Event;
import com.google.genai.types.Content;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;

public abstract class BaseAgent {
    private final String name;
    private final String description;
    private BaseAgent parentAgent;
    private List<? extends BaseAgent> subAgents;
    private final Optional<Callbacks.BeforeAgentCallback> beforeAgentCallback;
    private final Optional<Callbacks.AfterAgentCallback> afterAgentCallback;

    public BaseAgent(String name, String description, List<? extends BaseAgent> subAgents, Callbacks.BeforeAgentCallback beforeAgentCallback, Callbacks.AfterAgentCallback afterAgentCallback) {
        this.name = name;
        this.description = description;
        this.parentAgent = null;
        this.subAgents = subAgents != null ? subAgents : Collections.emptyList();
        this.beforeAgentCallback = Optional.ofNullable(beforeAgentCallback);
        this.afterAgentCallback = Optional.ofNullable(afterAgentCallback);
        for (BaseAgent baseAgent : this.subAgents) {
            baseAgent.parentAgent(this);
        }
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public BaseAgent parentAgent() {
        return this.parentAgent;
    }

    protected void parentAgent(BaseAgent parentAgent) {
        this.parentAgent = parentAgent;
    }

    public BaseAgent rootAgent() {
        BaseAgent agent = this;
        while (agent.parentAgent() != null) {
            agent = agent.parentAgent();
        }
        return agent;
    }

    public BaseAgent findAgent(String name) {
        if (this.name().equals(name)) {
            return this;
        }
        return this.findSubAgent(name);
    }

    public @Nullable BaseAgent findSubAgent(String name) {
        for (BaseAgent baseAgent : this.subAgents) {
            if (baseAgent.name().equals(name)) {
                return baseAgent;
            }
            BaseAgent result = baseAgent.findSubAgent(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public List<? extends BaseAgent> subAgents() {
        return this.subAgents;
    }

    public Optional<Callbacks.BeforeAgentCallback> beforeAgentCallback() {
        return this.beforeAgentCallback;
    }

    public Optional<Callbacks.AfterAgentCallback> afterAgentCallback() {
        return this.afterAgentCallback;
    }

    private InvocationContext createInvocationContext(InvocationContext parentContext) {
        InvocationContext invocationContext = InvocationContext.copyOf(parentContext);
        invocationContext.agent(this);
        if (parentContext.branch().filter(s -> !s.isEmpty()).isPresent()) {
            invocationContext.branch(parentContext.branch().get() + "." + this.name());
        }
        return invocationContext;
    }

    public Flowable<Event> runAsync(InvocationContext parentContext) {
        Tracer tracer = Telemetry.getTracer();
        return Flowable.defer(() -> {
            Span span = tracer.spanBuilder("agent_run [" + this.name() + "]").startSpan();
            try (Scope scope = span.makeCurrent();){
                InvocationContext invocationContext = this.createInvocationContext(parentContext);
                Flowable executionFlowable = this.beforeAgentCallback.map(callback -> this.callCallback(callback::call, invocationContext)).orElse(Single.just(Optional.empty())).flatMapPublisher(beforeEvent -> {
                    if (beforeEvent.isPresent()) {
                        if (((Event)beforeEvent.get()).content().isPresent()) {
                            return Flowable.just((Object)((Event)beforeEvent.get()));
                        }
                        if (invocationContext.endInvocation()) {
                            return Flowable.just((Object)((Event)beforeEvent.get()));
                        }
                    }
                    Flowable beforeEvents = Flowable.fromOptional((Optional)beforeEvent);
                    Flowable mainEvents = Flowable.defer(() -> this.runAsyncImpl(invocationContext));
                    Flowable afterEvents = this.afterAgentCallback.map(callback -> Flowable.defer(() -> this.callCallback(callback::call, invocationContext).flatMapPublisher(Flowable::fromOptional))).orElse(Flowable.empty());
                    return Flowable.concat((Publisher)beforeEvents, (Publisher)mainEvents, (Publisher)afterEvents);
                });
                Flowable flowable = executionFlowable.doFinally(() -> ((Span)span).end());
                return flowable;
            }
        });
    }

    private Single<Optional<Event>> callCallback(Function<CallbackContext, Maybe<Content>> agentCallback, InvocationContext invocationContext) {
        CallbackContext callbackContext = new CallbackContext(invocationContext, null);
        return agentCallback.apply(callbackContext).map(Optional::of).defaultIfEmpty(Optional.empty()).map(optionalContent -> {
            boolean hasStateDelta;
            boolean hasContent = optionalContent.isPresent();
            boolean bl = hasStateDelta = !callbackContext.eventActions().stateDelta().isEmpty();
            if (hasContent || hasStateDelta) {
                Event.Builder eventBuilder = Event.builder().id(Event.generateEventId()).invocationId(invocationContext.invocationId()).author(this.name()).branch(invocationContext.branch()).actions(callbackContext.eventActions());
                if (hasContent) {
                    eventBuilder.content((Optional<Content>)optionalContent);
                    return Optional.of(eventBuilder.build());
                }
                return Optional.of(eventBuilder.build());
            }
            return Optional.empty();
        });
    }

    public Flowable<Event> runLive(InvocationContext parentContext) {
        Tracer tracer = Telemetry.getTracer();
        return Flowable.defer(() -> {
            Span span = tracer.spanBuilder("agent_run [" + this.name() + "]").startSpan();
            try (Scope scope = span.makeCurrent();){
                InvocationContext invocationContext = this.createInvocationContext(parentContext);
                Flowable<Event> executionFlowable = this.runLiveImpl(invocationContext);
                Flowable flowable = executionFlowable.doFinally(() -> ((Span)span).end());
                return flowable;
            }
        });
    }

    protected abstract Flowable<Event> runAsyncImpl(InvocationContext var1);

    protected abstract Flowable<Event> runLiveImpl(InvocationContext var1);
}

