/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.adk.SchemaUtils;
import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.Callbacks;
import com.google.adk.agents.InvocationContext;
import com.google.adk.events.Event;
import com.google.adk.examples.BaseExampleProvider;
import com.google.adk.examples.Example;
import com.google.adk.flows.llmflows.AutoFlow;
import com.google.adk.flows.llmflows.BaseLlmFlow;
import com.google.adk.flows.llmflows.SingleFlow;
import com.google.adk.models.BaseLlm;
import com.google.adk.models.Model;
import com.google.adk.tools.BaseTool;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.types.Content;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.Schema;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class LlmAgent
extends BaseAgent {
    private final Optional<Model> model;
    private final Optional<String> instruction;
    private final Optional<String> globalInstruction;
    private final List<BaseTool> tools;
    private final Optional<GenerateContentConfig> generateContentConfig;
    private final Optional<BaseExampleProvider> exampleProvider;
    private final IncludeContents includeContents;
    private final boolean planning;
    private final boolean disallowTransferToParent;
    private final boolean disallowTransferToPeers;
    private final Optional<Callbacks.BeforeModelCallback> beforeModelCallback;
    private final Optional<Callbacks.AfterModelCallback> afterModelCallback;
    private final Optional<Callbacks.BeforeToolCallback> beforeToolCallback;
    private final Optional<Callbacks.AfterToolCallback> afterToolCallback;
    private final Optional<Schema> inputSchema;
    private final Optional<Schema> outputSchema;
    private final Optional<Executor> executor;
    private final Optional<String> outputKey;
    private volatile Model resolvedModel;
    private final BaseLlmFlow llmFlow;

    private LlmAgent(Builder builder) {
        super(builder.name, builder.description, builder.subAgents, builder.beforeAgentCallback, builder.afterAgentCallback);
        this.model = Optional.ofNullable(builder.model);
        this.instruction = Optional.ofNullable(builder.instruction);
        this.globalInstruction = Optional.ofNullable(builder.globalInstruction);
        this.generateContentConfig = Optional.ofNullable(builder.generateContentConfig);
        this.exampleProvider = Optional.ofNullable(builder.exampleProvider);
        this.includeContents = builder.includeContents != null ? builder.includeContents : IncludeContents.DEFAULT;
        this.planning = builder.planning != null ? builder.planning : false;
        this.disallowTransferToParent = builder.disallowTransferToParent;
        this.disallowTransferToPeers = builder.disallowTransferToPeers;
        this.beforeModelCallback = Optional.ofNullable(builder.beforeModelCallback);
        this.afterModelCallback = Optional.ofNullable(builder.afterModelCallback);
        this.beforeToolCallback = Optional.ofNullable(builder.beforeToolCallback);
        this.afterToolCallback = Optional.ofNullable(builder.afterToolCallback);
        this.inputSchema = Optional.ofNullable(builder.inputSchema);
        this.outputSchema = Optional.ofNullable(builder.outputSchema);
        this.executor = Optional.ofNullable(builder.executor);
        this.outputKey = Optional.ofNullable(builder.outputKey);
        this.tools = builder.tools != null ? builder.tools : Collections.emptyList();
        this.llmFlow = this.determineLlmFlow();
        Preconditions.checkArgument((!this.name().isEmpty() ? 1 : 0) != 0, (Object)"Agent name cannot be empty.");
    }

    public static Builder builder() {
        return new Builder();
    }

    private BaseLlmFlow determineLlmFlow() {
        if (this.disallowTransferToParent() && this.disallowTransferToPeers() && this.subAgents().isEmpty()) {
            return new SingleFlow();
        }
        return new AutoFlow();
    }

    private void maybeSaveOutputToState(Event event) {
        if (this.outputKey().isPresent() && event.finalResponse() && event.content().isPresent()) {
            Object output;
            String rawResult = event.content().flatMap(Content::parts).orElse(Collections.emptyList()).stream().map(part -> part.text().orElse("")).collect(Collectors.joining());
            Optional<Schema> outputSchema = this.outputSchema();
            if (outputSchema.isPresent()) {
                try {
                    Map<String, Object> validatedMap = SchemaUtils.validateOutputSchema(rawResult, outputSchema.get());
                    output = validatedMap;
                }
                catch (JsonProcessingException e) {
                    System.err.println("Error: LlmAgent output for outputKey '" + this.outputKey().get() + "' was not valid JSON, despite an outputSchema being present. Saving raw output to state. Error: " + e.getMessage());
                    output = rawResult;
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Error: LlmAgent output for outputKey '" + this.outputKey().get() + "' did not match the outputSchema. Saving raw output to state. Error: " + e.getMessage());
                    output = rawResult;
                }
            } else {
                output = rawResult;
            }
            event.actions().stateDelta().put(this.outputKey().get(), output);
        }
    }

    @Override
    protected Flowable<Event> runAsyncImpl(InvocationContext invocationContext) {
        return this.llmFlow.run(invocationContext).doOnNext(this::maybeSaveOutputToState);
    }

    @Override
    protected Flowable<Event> runLiveImpl(InvocationContext invocationContext) {
        return this.llmFlow.runLive(invocationContext).doOnNext(this::maybeSaveOutputToState);
    }

    public Optional<String> instruction() {
        return this.instruction;
    }

    public Optional<String> globalInstruction() {
        return this.globalInstruction;
    }

    public Optional<Model> model() {
        return this.model;
    }

    public boolean planning() {
        return this.planning;
    }

    public Optional<GenerateContentConfig> generateContentConfig() {
        return this.generateContentConfig;
    }

    public Optional<BaseExampleProvider> exampleProvider() {
        return this.exampleProvider;
    }

    public IncludeContents includeContents() {
        return this.includeContents;
    }

    public List<BaseTool> tools() {
        return this.tools;
    }

    public boolean disallowTransferToParent() {
        return this.disallowTransferToParent;
    }

    public boolean disallowTransferToPeers() {
        return this.disallowTransferToPeers;
    }

    public Optional<Callbacks.BeforeModelCallback> beforeModelCallback() {
        return this.beforeModelCallback;
    }

    public Optional<Callbacks.AfterModelCallback> afterModelCallback() {
        return this.afterModelCallback;
    }

    public Optional<Callbacks.BeforeToolCallback> beforeToolCallback() {
        return this.beforeToolCallback;
    }

    public Optional<Callbacks.AfterToolCallback> afterToolCallback() {
        return this.afterToolCallback;
    }

    public Optional<Schema> inputSchema() {
        return this.inputSchema;
    }

    public Optional<Schema> outputSchema() {
        return this.outputSchema;
    }

    public Optional<Executor> executor() {
        return this.executor;
    }

    public Optional<String> outputKey() {
        return this.outputKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model resolvedModel() {
        if (this.resolvedModel == null) {
            LlmAgent llmAgent = this;
            synchronized (llmAgent) {
                if (this.resolvedModel == null) {
                    this.resolvedModel = this.resolveModelInternal();
                }
            }
        }
        return this.resolvedModel;
    }

    private Model resolveModelInternal() {
        if (this.model.isPresent() && this.model().isPresent()) {
            return this.model.get();
        }
        for (BaseAgent current = this.parentAgent(); current != null; current = current.parentAgent()) {
            if (!(current instanceof LlmAgent)) continue;
            return ((LlmAgent)current).resolvedModel();
        }
        throw new IllegalStateException("No model found for agent " + this.name() + " or its ancestors.");
    }

    public static class Builder {
        private String name;
        private String description;
        private Model model;
        private String instruction;
        private String globalInstruction;
        private List<BaseAgent> subAgents;
        private List<BaseTool> tools;
        private GenerateContentConfig generateContentConfig;
        private BaseExampleProvider exampleProvider;
        private IncludeContents includeContents;
        private Boolean planning;
        private Boolean disallowTransferToParent;
        private Boolean disallowTransferToPeers;
        private Callbacks.BeforeModelCallback beforeModelCallback;
        private Callbacks.AfterModelCallback afterModelCallback;
        private Callbacks.BeforeAgentCallback beforeAgentCallback;
        private Callbacks.AfterAgentCallback afterAgentCallback;
        private Callbacks.BeforeToolCallback beforeToolCallback;
        private Callbacks.AfterToolCallback afterToolCallback;
        private Schema inputSchema;
        private Schema outputSchema;
        private Executor executor;
        private String outputKey;

        @CanIgnoreReturnValue
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder model(String model) {
            this.model = Model.builder().modelName(model).build();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder model(BaseLlm model) {
            this.model = Model.builder().model(model).build();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder globalInstruction(String globalInstruction) {
            this.globalInstruction = globalInstruction;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder subAgents(List<? extends BaseAgent> subAgents) {
            this.subAgents = ImmutableList.copyOf(subAgents);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder subAgents(BaseAgent ... subAgents) {
            this.subAgents = ImmutableList.copyOf((Object[])subAgents);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder tools(List<? extends BaseTool> tools) {
            this.tools = ImmutableList.copyOf(tools);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder tools(BaseTool ... tools) {
            this.tools = ImmutableList.copyOf((Object[])tools);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder generateContentConfig(GenerateContentConfig generateContentConfig) {
            this.generateContentConfig = generateContentConfig;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder exampleProvider(BaseExampleProvider exampleProvider) {
            this.exampleProvider = exampleProvider;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder exampleProvider(final List<Example> examples) {
            this.exampleProvider = new BaseExampleProvider(){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public List<Example> getExamples(String query) {
                    return examples;
                }
            };
            return this;
        }

        @CanIgnoreReturnValue
        public Builder exampleProvider(final Example ... examples) {
            this.exampleProvider = new BaseExampleProvider(){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = this$0;
                }

                public ImmutableList<Example> getExamples(String query) {
                    return ImmutableList.copyOf((Object[])examples);
                }
            };
            return this;
        }

        @CanIgnoreReturnValue
        public Builder includeContents(IncludeContents includeContents) {
            this.includeContents = includeContents;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder planning(boolean planning) {
            this.planning = planning;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder disallowTransferToParent(boolean disallowTransferToParent) {
            this.disallowTransferToParent = disallowTransferToParent;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder disallowTransferToPeers(boolean disallowTransferToPeers) {
            this.disallowTransferToPeers = disallowTransferToPeers;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeModelCallback(Callbacks.BeforeModelCallback beforeModelCallback) {
            this.beforeModelCallback = beforeModelCallback;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeModelCallbackSync(Callbacks.BeforeModelCallbackSync beforeModelCallbackSync) {
            this.beforeModelCallback = (callbackContext, llmRequest) -> Maybe.fromOptional(beforeModelCallbackSync.call(callbackContext, llmRequest));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterModelCallback(Callbacks.AfterModelCallback afterModelCallback) {
            this.afterModelCallback = afterModelCallback;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterModelCallbackSync(Callbacks.AfterModelCallbackSync afterModelCallbackSync) {
            this.afterModelCallback = (callbackContext, llmResponse) -> Maybe.fromOptional(afterModelCallbackSync.call(callbackContext, llmResponse));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeAgentCallback(Callbacks.BeforeAgentCallback beforeAgentCallback) {
            this.beforeAgentCallback = beforeAgentCallback;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeAgentCallbackSync(Callbacks.BeforeAgentCallbackSync beforeAgentCallbackSync) {
            this.beforeAgentCallback = callbackContext -> Maybe.fromOptional(beforeAgentCallbackSync.call(callbackContext));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterAgentCallback(Callbacks.AfterAgentCallback afterAgentCallback) {
            this.afterAgentCallback = afterAgentCallback;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterAgentCallbackSync(Callbacks.AfterAgentCallbackSync afterAgentCallbackSync) {
            this.afterAgentCallback = callbackContext -> Maybe.fromOptional(afterAgentCallbackSync.call(callbackContext));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeToolCallback(Callbacks.BeforeToolCallback beforeToolCallback) {
            this.beforeToolCallback = beforeToolCallback;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeToolCallbackSync(Callbacks.BeforeToolCallbackSync beforeToolCallbackSync) {
            this.beforeToolCallback = (invocationContext, baseTool, input, toolContext) -> Maybe.fromOptional(beforeToolCallbackSync.call(invocationContext, baseTool, input, toolContext));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterToolCallback(Callbacks.AfterToolCallback afterToolCallback) {
            this.afterToolCallback = afterToolCallback;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterToolCallbackSync(Callbacks.AfterToolCallbackSync afterToolCallbackSync) {
            this.afterToolCallback = (invocationContext, baseTool, input, toolContext, response) -> Maybe.fromOptional(afterToolCallbackSync.call(invocationContext, baseTool, input, toolContext, response));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder inputSchema(Schema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder outputSchema(Schema outputSchema) {
            this.outputSchema = outputSchema;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public LlmAgent build() {
            this.disallowTransferToParent = this.disallowTransferToParent != null && this.disallowTransferToParent != false;
            this.disallowTransferToPeers = this.disallowTransferToPeers != null && this.disallowTransferToPeers != false;
            if (this.outputSchema != null) {
                if (!this.disallowTransferToParent.booleanValue() || !this.disallowTransferToPeers.booleanValue()) {
                    System.err.println("Warning: Invalid config for agent " + this.name + ": outputSchema cannot co-exist with agent transfer configurations. Setting disallowTransferToParent=true and disallowTransferToPeers=true.");
                    this.disallowTransferToParent = true;
                    this.disallowTransferToPeers = true;
                }
                if (this.subAgents != null && !this.subAgents.isEmpty()) {
                    throw new IllegalArgumentException("Invalid config for agent " + this.name + ": if outputSchema is set, subAgents must be empty to disable agent transfer.");
                }
                if (this.tools != null && !this.tools.isEmpty()) {
                    throw new IllegalArgumentException("Invalid config for agent " + this.name + ": if outputSchema is set, tools must be empty.");
                }
            }
            return new LlmAgent(this);
        }
    }

    public static enum IncludeContents {
        DEFAULT,
        NONE;

    }
}

