/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.Callbacks;
import com.google.adk.agents.InvocationContext;
import com.google.adk.events.Event;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.List;

public class ParallelAgent
extends BaseAgent {
    private ParallelAgent(String name, String description, List<? extends BaseAgent> subAgents, Callbacks.BeforeAgentCallback beforeAgentCallback, Callbacks.AfterAgentCallback afterAgentCallback) {
        super(name, description, subAgents, beforeAgentCallback, afterAgentCallback);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void setBranchForCurrentAgent(BaseAgent currentAgent, InvocationContext invocationContext) {
        String branch = invocationContext.branch().orElse(null);
        if (Strings.isNullOrEmpty((String)branch)) {
            invocationContext.branch(currentAgent.name());
        } else {
            invocationContext.branch(branch + "." + currentAgent.name());
        }
    }

    @Override
    protected Flowable<Event> runAsyncImpl(InvocationContext invocationContext) {
        ParallelAgent.setBranchForCurrentAgent(this, invocationContext);
        List<? extends BaseAgent> currentSubAgents = this.subAgents();
        if (currentSubAgents == null || currentSubAgents.isEmpty()) {
            return Flowable.empty();
        }
        ArrayList<Flowable<Event>> agentFlowables = new ArrayList<Flowable<Event>>();
        for (BaseAgent baseAgent : currentSubAgents) {
            agentFlowables.add(baseAgent.runAsync(invocationContext));
        }
        return Flowable.merge(agentFlowables);
    }

    @Override
    protected Flowable<Event> runLiveImpl(InvocationContext invocationContext) {
        return Flowable.error((Throwable)new UnsupportedOperationException("runLive is not defined for ParallelAgent yet."));
    }

    public static class Builder {
        private String name;
        private String description;
        private List<? extends BaseAgent> subAgents;
        private Callbacks.BeforeAgentCallback beforeAgentCallback;
        private Callbacks.AfterAgentCallback afterAgentCallback;

        @CanIgnoreReturnValue
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder subAgents(List<? extends BaseAgent> subAgents) {
            this.subAgents = subAgents;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder subAgents(BaseAgent ... subAgents) {
            this.subAgents = ImmutableList.copyOf((Object[])subAgents);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeAgentCallback(Callbacks.BeforeAgentCallback beforeAgentCallback) {
            this.beforeAgentCallback = beforeAgentCallback;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterAgentCallback(Callbacks.AfterAgentCallback afterAgentCallback) {
            this.afterAgentCallback = afterAgentCallback;
            return this;
        }

        public ParallelAgent build() {
            return new ParallelAgent(this.name, this.description, this.subAgents, this.beforeAgentCallback, this.afterAgentCallback);
        }
    }
}

