/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.types.Part;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public class EventActions {
    private Optional<Boolean> skipSummarization = Optional.empty();
    private ConcurrentMap<String, Object> stateDelta = new ConcurrentHashMap<String, Object>();
    private ConcurrentMap<String, Part> artifactDelta = new ConcurrentHashMap<String, Part>();
    private Optional<String> transferToAgent = Optional.empty();
    private Optional<Boolean> escalate = Optional.empty();
    private ConcurrentMap<String, ConcurrentMap<String, Object>> requestedAuthConfigs = new ConcurrentHashMap<String, ConcurrentMap<String, Object>>();

    @JsonProperty(value="skipSummarization")
    public Optional<Boolean> skipSummarization() {
        return this.skipSummarization;
    }

    public void setSkipSummarization(@Nullable Boolean skipSummarization) {
        this.skipSummarization = Optional.ofNullable(skipSummarization);
    }

    public void setSkipSummarization(Optional<Boolean> skipSummarization) {
        this.skipSummarization = skipSummarization;
    }

    public void setSkipSummarization(boolean skipSummarization) {
        this.skipSummarization = Optional.of(skipSummarization);
    }

    @JsonProperty(value="stateDelta")
    public ConcurrentMap<String, Object> stateDelta() {
        return this.stateDelta;
    }

    public void setStateDelta(ConcurrentMap<String, Object> stateDelta) {
        this.stateDelta = stateDelta;
    }

    @JsonProperty(value="artifactDelta")
    public ConcurrentMap<String, Part> artifactDelta() {
        return this.artifactDelta;
    }

    public void setArtifactDelta(ConcurrentMap<String, Part> artifactDelta) {
        this.artifactDelta = artifactDelta;
    }

    @JsonProperty(value="transferToAgent")
    public Optional<String> transferToAgent() {
        return this.transferToAgent;
    }

    public void setTransferToAgent(Optional<String> transferToAgent) {
        this.transferToAgent = transferToAgent;
    }

    public void setTransferToAgent(String transferToAgent) {
        this.transferToAgent = Optional.ofNullable(transferToAgent);
    }

    @JsonProperty(value="escalate")
    public Optional<Boolean> escalate() {
        return this.escalate;
    }

    public void setEscalate(Optional<Boolean> escalate) {
        this.escalate = escalate;
    }

    public void setEscalate(boolean escalate) {
        this.escalate = Optional.of(escalate);
    }

    @JsonProperty(value="requestedAuthConfigs")
    public ConcurrentMap<String, ConcurrentMap<String, Object>> requestedAuthConfigs() {
        return this.requestedAuthConfigs;
    }

    public void setRequestedAuthConfigs(ConcurrentMap<String, ConcurrentMap<String, Object>> requestedAuthConfigs) {
        this.requestedAuthConfigs = requestedAuthConfigs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventActions)) {
            return false;
        }
        EventActions that = (EventActions)o;
        return Objects.equals(this.skipSummarization, that.skipSummarization) && Objects.equals(this.stateDelta, that.stateDelta) && Objects.equals(this.artifactDelta, that.artifactDelta) && Objects.equals(this.transferToAgent, that.transferToAgent) && Objects.equals(this.escalate, that.escalate) && Objects.equals(this.requestedAuthConfigs, that.requestedAuthConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.skipSummarization, this.stateDelta, this.artifactDelta, this.transferToAgent, this.escalate, this.requestedAuthConfigs);
    }

    public static class Builder {
        private Optional<Boolean> skipSummarization = Optional.empty();
        private ConcurrentMap<String, Object> stateDelta = new ConcurrentHashMap<String, Object>();
        private ConcurrentMap<String, Part> artifactDelta = new ConcurrentHashMap<String, Part>();
        private Optional<String> transferToAgent = Optional.empty();
        private Optional<Boolean> escalate = Optional.empty();
        private ConcurrentMap<String, ConcurrentMap<String, Object>> requestedAuthConfigs = new ConcurrentHashMap<String, ConcurrentMap<String, Object>>();

        public Builder() {
        }

        private Builder(EventActions eventActions) {
            this.skipSummarization = eventActions.skipSummarization();
            this.stateDelta = new ConcurrentHashMap<String, Object>(eventActions.stateDelta());
            this.artifactDelta = new ConcurrentHashMap<String, Part>(eventActions.artifactDelta());
            this.transferToAgent = eventActions.transferToAgent();
            this.escalate = eventActions.escalate();
            this.requestedAuthConfigs = new ConcurrentHashMap<String, ConcurrentMap<String, Object>>(eventActions.requestedAuthConfigs());
        }

        @JsonProperty(value="skipSummarization")
        @CanIgnoreReturnValue
        public Builder skipSummarization(boolean skipSummarization) {
            this.skipSummarization = Optional.of(skipSummarization);
            return this;
        }

        @JsonProperty(value="stateDelta")
        @CanIgnoreReturnValue
        public Builder stateDelta(ConcurrentMap<String, Object> value) {
            this.stateDelta = value;
            return this;
        }

        @JsonProperty(value="artifactDelta")
        @CanIgnoreReturnValue
        public Builder artifactDelta(ConcurrentMap<String, Part> value) {
            this.artifactDelta = value;
            return this;
        }

        @JsonProperty(value="transferToAgent")
        @CanIgnoreReturnValue
        public Builder transferToAgent(String agentId) {
            this.transferToAgent = Optional.ofNullable(agentId);
            return this;
        }

        @JsonProperty(value="escalate")
        @CanIgnoreReturnValue
        public Builder escalate(boolean escalate) {
            this.escalate = Optional.of(escalate);
            return this;
        }

        @JsonProperty(value="requestedAuthConfigs")
        @CanIgnoreReturnValue
        public Builder requestedAuthConfigs(ConcurrentMap<String, ConcurrentMap<String, Object>> value) {
            this.requestedAuthConfigs = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder merge(EventActions other) {
            if (other.skipSummarization().isPresent()) {
                this.skipSummarization = other.skipSummarization();
            }
            if (other.stateDelta() != null) {
                this.stateDelta.putAll(other.stateDelta());
            }
            if (other.artifactDelta() != null) {
                this.artifactDelta.putAll(other.artifactDelta());
            }
            if (other.transferToAgent().isPresent()) {
                this.transferToAgent = other.transferToAgent();
            }
            if (other.escalate().isPresent()) {
                this.escalate = other.escalate();
            }
            if (other.requestedAuthConfigs() != null) {
                this.requestedAuthConfigs.putAll(other.requestedAuthConfigs());
            }
            return this;
        }

        public EventActions build() {
            EventActions eventActions = new EventActions();
            eventActions.setSkipSummarization(this.skipSummarization);
            eventActions.setStateDelta(this.stateDelta);
            eventActions.setArtifactDelta(this.artifactDelta);
            eventActions.setTransferToAgent(this.transferToAgent);
            eventActions.setEscalate(this.escalate);
            eventActions.setRequestedAuthConfigs(this.requestedAuthConfigs);
            return eventActions;
        }
    }
}

