/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.models;

import com.google.adk.models.BaseLlm;
import com.google.adk.models.Gemini;
import com.google.genai.Client;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LlmRegistry {
    private static final Map<String, BaseLlm> instances = new ConcurrentHashMap<String, BaseLlm>();
    private static Client geminiApiClient = Client.builder().build();
    private static final Map<String, LlmFactory> llmFactories = new ConcurrentHashMap<String, LlmFactory>();

    private static Client getGeminiApiClient() {
        return geminiApiClient;
    }

    public static void registerLlm(String modelNamePattern, LlmFactory factory) {
        llmFactories.put(modelNamePattern, factory);
    }

    public static BaseLlm getLlm(String modelName) {
        return instances.computeIfAbsent(modelName, LlmRegistry::createLlm);
    }

    private static BaseLlm createLlm(String modelName) {
        for (Map.Entry<String, LlmFactory> entry : llmFactories.entrySet()) {
            if (!modelName.matches(entry.getKey())) continue;
            return entry.getValue().create(modelName);
        }
        throw new IllegalArgumentException("Unsupported model: " + modelName);
    }

    static void registerTestLlm(String modelNamePattern, LlmFactory factory) {
        llmFactories.put(modelNamePattern, factory);
        instances.keySet().removeIf(modelName -> modelName.matches(modelNamePattern));
    }

    static {
        LlmRegistry.registerLlm("gemini-.*", modelName -> new Gemini(modelName, LlmRegistry.getGeminiApiClient()));
    }

    @FunctionalInterface
    public static interface LlmFactory {
        public BaseLlm create(String var1);
    }
}

