/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.sessions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.adk.JsonBaseModel;
import com.google.adk.events.Event;
import com.google.adk.sessions.State;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

@JsonDeserialize(builder=Builder.class)
public final class Session
extends JsonBaseModel {
    private final String id;
    private final String appName;
    private final String userId;
    private final State state;
    private final List<Event> events;
    private Instant lastUpdateTime;

    public static Builder builder(String id) {
        return new Builder(id);
    }

    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @JsonProperty(value="state")
    public ConcurrentMap<String, Object> state() {
        return this.state;
    }

    @JsonProperty(value="events")
    public List<Event> events() {
        return this.events;
    }

    @JsonProperty(value="appName")
    public String appName() {
        return this.appName;
    }

    @JsonProperty(value="userId")
    public String userId() {
        return this.userId;
    }

    public void lastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    @JsonProperty(value="lastUpdateTime")
    public double getLastUpdateTimeAsDouble() {
        if (this.lastUpdateTime == null) {
            return 0.0;
        }
        long seconds = this.lastUpdateTime.getEpochSecond();
        int nanos = this.lastUpdateTime.getNano();
        return (double)seconds + (double)nanos / (double)TimeUnit.SECONDS.toNanos(1L);
    }

    public static Session fromJson(String json) {
        return Session.fromJsonString(json, Session.class);
    }

    private Session(String appName, String userId, String id, State state, List<Event> events, Instant lastUpdateTime) {
        this.id = id;
        this.appName = appName;
        this.userId = userId;
        this.state = state;
        this.events = events;
        this.lastUpdateTime = lastUpdateTime;
    }

    public static final class Builder {
        private String id;
        private String appName;
        private String userId;
        private State state = new State(new ConcurrentHashMap<String, Object>());
        private List<Event> events = new ArrayList<Event>();
        private Instant lastUpdateTime = Instant.EPOCH;

        public Builder(String id) {
            this.id = id;
        }

        @JsonCreator
        private Builder() {
        }

        @JsonProperty(value="id")
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        @JsonProperty(value="state")
        public Builder state(ConcurrentMap<String, Object> state) {
            this.state = new State(state);
            return this;
        }

        @JsonProperty(value="appName")
        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        @JsonProperty(value="userId")
        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="events")
        public Builder events(List<Event> events) {
            this.events = events;
            return this;
        }

        public Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @JsonProperty(value="lastUpdateTime")
        public Builder lastUpdateTimeSeconds(double seconds) {
            long secs = (long)seconds;
            long nanos = (long)((seconds - (double)secs) * (double)TimeUnit.SECONDS.toNanos(1L));
            this.lastUpdateTime = Instant.ofEpochSecond(secs, nanos);
            return this;
        }

        public Session build() {
            if (this.id == null) {
                throw new IllegalStateException("Session id is null");
            }
            return new Session(this.appName, this.userId, this.id, this.state, this.events, this.lastUpdateTime);
        }
    }
}

