/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.adk.JsonBaseModel;
import com.google.adk.tools.Annotations;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.Schema;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public final class FunctionCallingUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    static FunctionDeclaration buildFunctionDeclaration(Method func, List<String> ignoreParams) {
        if (!Modifier.isStatic(func.getModifiers())) {
            throw new IllegalArgumentException("Instance methods are not supported. Please use static methods.");
        }
        String name = func.getAnnotation(Annotations.Schema.class) != null && !func.getAnnotation(Annotations.Schema.class).name().isEmpty() ? func.getAnnotation(Annotations.Schema.class).name() : func.getName();
        FunctionDeclaration.Builder builder = FunctionDeclaration.builder().name(name);
        if (func.getAnnotation(Annotations.Schema.class) != null && !func.getAnnotation(Annotations.Schema.class).description().isEmpty()) {
            builder.description(func.getAnnotation(Annotations.Schema.class).description());
        }
        ArrayList<String> required = new ArrayList<String>();
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        for (Parameter param : func.getParameters()) {
            String paramName;
            String string = paramName = param.getAnnotation(Annotations.Schema.class) != null && !param.getAnnotation(Annotations.Schema.class).name().isEmpty() ? param.getAnnotation(Annotations.Schema.class).name() : param.getName();
            if (ignoreParams.contains(paramName)) continue;
            required.add(paramName);
            properties.put(paramName, FunctionCallingUtils.buildSchemaFromParameter(param));
        }
        builder.parameters(Schema.builder().required(required).properties(properties).type("OBJECT").build());
        Type returnType = func.getGenericReturnType();
        if (returnType != Void.TYPE) {
            Type realReturnType = returnType;
            if (returnType instanceof ParameterizedType) {
                ParameterizedType parameterizedReturnType = (ParameterizedType)returnType;
                String returnTypeName = ((Class)parameterizedReturnType.getRawType()).getName();
                if (returnTypeName.equals("io.reactivex.rxjava3.core.Maybe") && (returnType = parameterizedReturnType.getActualTypeArguments()[0]) instanceof ParameterizedType) {
                    ParameterizedType maybeParameterizedType = (ParameterizedType)returnType;
                    returnTypeName = ((Class)maybeParameterizedType.getRawType()).getName();
                }
                if (returnTypeName.equals("java.util.Map") || returnTypeName.equals("com.google.common.collect.ImmutableMap")) {
                    return builder.response(FunctionCallingUtils.buildSchemaFromType(returnType)).build();
                }
            }
            throw new IllegalArgumentException("Return type should be Map or Maybe<Map>, but it was " + realReturnType.getTypeName());
        }
        return builder.build();
    }

    static FunctionDeclaration buildFunctionDeclaration(JsonBaseModel func, String description) {
        String jsonString = func.toJson();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)jsonString) ? 1 : 0) != 0, (Object)"Input String can't be null or empty.");
        FunctionDeclaration declaration = FunctionDeclaration.fromJson((String)jsonString);
        declaration = declaration.toBuilder().description(description).build();
        if (!declaration.name().isPresent() || ((String)declaration.name().get()).isEmpty()) {
            throw new IllegalArgumentException("name field must be present.");
        }
        return declaration;
    }

    private static Schema buildSchemaFromParameter(Parameter param) {
        Schema.Builder builder = Schema.builder();
        if (param.getAnnotation(Annotations.Schema.class) != null && !param.getAnnotation(Annotations.Schema.class).description().isEmpty()) {
            builder.description(param.getAnnotation(Annotations.Schema.class).description());
        }
        switch (param.getType().getName()) {
            case "java.lang.String": {
                builder.type("STRING");
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                builder.type("BOOLEAN");
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                builder.type("INTEGER");
                break;
            }
            case "double": 
            case "java.lang.Double": 
            case "float": 
            case "java.lang.Float": 
            case "long": 
            case "java.lang.Long": {
                builder.type("NUMBER");
                break;
            }
            case "java.util.List": {
                builder.type("ARRAY").items(FunctionCallingUtils.buildSchemaFromType(((ParameterizedType)param.getParameterizedType()).getActualTypeArguments()[0]));
                break;
            }
            case "java.util.Map": {
                builder.type("OBJECT");
                break;
            }
            default: {
                BeanDescription beanDescription = OBJECT_MAPPER.getSerializationConfig().introspect(OBJECT_MAPPER.constructType(param.getType()));
                LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
                for (BeanPropertyDefinition property : beanDescription.findProperties()) {
                    properties.put(property.getName(), FunctionCallingUtils.buildSchemaFromType(property.getRawPrimaryType()));
                }
                builder.type("OBJECT").properties(properties);
            }
        }
        return builder.build();
    }

    public static Schema buildSchemaFromType(Type type) {
        Schema.Builder builder = Schema.builder();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            switch (((Class)parameterizedType.getRawType()).getName()) {
                case "java.util.List": {
                    builder.type("ARRAY").items(FunctionCallingUtils.buildSchemaFromType(parameterizedType.getActualTypeArguments()[0]));
                    break;
                }
                case "java.util.Map": 
                case "com.google.common.collect.ImmutableMap": {
                    builder.type("OBJECT");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported generic type: " + String.valueOf(type));
                }
            }
        } else if (type instanceof Class) {
            Class clazz = (Class)type;
            switch (clazz.getName()) {
                case "java.lang.String": {
                    builder.type("STRING");
                    break;
                }
                case "boolean": 
                case "java.lang.Boolean": {
                    builder.type("BOOLEAN");
                    break;
                }
                case "int": 
                case "java.lang.Integer": {
                    builder.type("INTEGER");
                    break;
                }
                case "double": 
                case "java.lang.Double": 
                case "float": 
                case "java.lang.Float": 
                case "long": 
                case "java.lang.Long": {
                    builder.type("NUMBER");
                    break;
                }
                case "java.util.Map": 
                case "com.google.common.collect.ImmutableMap": {
                    builder.type("OBJECT");
                    break;
                }
                default: {
                    BeanDescription beanDescription = OBJECT_MAPPER.getSerializationConfig().introspect(OBJECT_MAPPER.constructType(type));
                    LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
                    for (BeanPropertyDefinition property : beanDescription.findProperties()) {
                        properties.put(property.getName(), FunctionCallingUtils.buildSchemaFromType(property.getRawPrimaryType()));
                    }
                    builder.type("OBJECT").properties(properties);
                }
            }
        }
        return builder.build();
    }
}

